@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin

import com.pulumi.alicloud.adb.ResourceGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a AnalyticDB for MySQL (ADB) Resource Group resource.
 * For information about AnalyticDB for MySQL (ADB) Resource Group and how to use it, see [What is Resource Group](https://www.alibabacloud.com/help/en/analyticdb-for-mysql/latest/api-doc-adb-2019-03-15-api-doc-createdbresourcegroup).
 * > **NOTE:** Available since v1.195.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const default = alicloud.adb.getZones({});
 * const defaultGetResourceGroups = alicloud.resourcemanager.getResourceGroups({
 *     status: "OK",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "10.4.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const defaultDBCluster = new alicloud.adb.DBCluster("default", {
 *     computeResource: "48Core192GB",
 *     dbClusterCategory: "MixedStorage",
 *     dbClusterVersion: "3.0",
 *     dbNodeClass: "E32",
 *     dbNodeStorage: 100,
 *     description: name,
 *     elasticIoResource: 1,
 *     maintainTime: "04:00Z-05:00Z",
 *     mode: "flexible",
 *     paymentType: "PayAsYouGo",
 *     resourceGroupId: defaultGetResourceGroups.then(defaultGetResourceGroups => defaultGetResourceGroups.ids?.[0]),
 *     securityIps: [
 *         "10.168.1.12",
 *         "10.168.1.11",
 *     ],
 *     vpcId: defaultNetwork.id,
 *     vswitchId: defaultSwitch.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * const defaultResourceGroup = new alicloud.adb.ResourceGroup("default", {
 *     groupName: "TF_EXAMPLE",
 *     groupType: "batch",
 *     nodeNum: 0,
 *     dbClusterId: defaultDBCluster.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.adb.get_zones()
 * default_get_resource_groups = alicloud.resourcemanager.get_resource_groups(status="OK")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="10.4.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=name)
 * default_db_cluster = alicloud.adb.DBCluster("default",
 *     compute_resource="48Core192GB",
 *     db_cluster_category="MixedStorage",
 *     db_cluster_version="3.0",
 *     db_node_class="E32",
 *     db_node_storage=100,
 *     description=name,
 *     elastic_io_resource=1,
 *     maintain_time="04:00Z-05:00Z",
 *     mode="flexible",
 *     payment_type="PayAsYouGo",
 *     resource_group_id=default_get_resource_groups.ids[0],
 *     security_ips=[
 *         "10.168.1.12",
 *         "10.168.1.11",
 *     ],
 *     vpc_id=default_network.id,
 *     vswitch_id=default_switch.id,
 *     zone_id=default.zones[0].id,
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * default_resource_group = alicloud.adb.ResourceGroup("default",
 *     group_name="TF_EXAMPLE",
 *     group_type="batch",
 *     node_num=0,
 *     db_cluster_id=default_db_cluster.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = AliCloud.Adb.GetZones.Invoke();
 *     var defaultGetResourceGroups = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
 *     {
 *         Status = "OK",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "10.4.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = name,
 *     });
 *     var defaultDBCluster = new AliCloud.Adb.DBCluster("default", new()
 *     {
 *         ComputeResource = "48Core192GB",
 *         DbClusterCategory = "MixedStorage",
 *         DbClusterVersion = "3.0",
 *         DbNodeClass = "E32",
 *         DbNodeStorage = 100,
 *         Description = name,
 *         ElasticIoResource = 1,
 *         MaintainTime = "04:00Z-05:00Z",
 *         Mode = "flexible",
 *         PaymentType = "PayAsYouGo",
 *         ResourceGroupId = defaultGetResourceGroups.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0]),
 *         SecurityIps = new[]
 *         {
 *             "10.168.1.12",
 *             "10.168.1.11",
 *         },
 *         VpcId = defaultNetwork.Id,
 *         VswitchId = defaultSwitch.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 *     var defaultResourceGroup = new AliCloud.Adb.ResourceGroup("default", new()
 *     {
 *         GroupName = "TF_EXAMPLE",
 *         GroupType = "batch",
 *         NodeNum = 0,
 *         DbClusterId = defaultDBCluster.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/adb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := adb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetResourceGroups, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
 * 			Status: pulumi.StringRef("OK"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultDBCluster, err := adb.NewDBCluster(ctx, "default", &adb.DBClusterArgs{
 * 			ComputeResource:   pulumi.String("48Core192GB"),
 * 			DbClusterCategory: pulumi.String("MixedStorage"),
 * 			DbClusterVersion:  pulumi.String("3.0"),
 * 			DbNodeClass:       pulumi.String("E32"),
 * 			DbNodeStorage:     pulumi.Int(100),
 * 			Description:       pulumi.String(name),
 * 			ElasticIoResource: pulumi.Int(1),
 * 			MaintainTime:      pulumi.String("04:00Z-05:00Z"),
 * 			Mode:              pulumi.String("flexible"),
 * 			PaymentType:       pulumi.String("PayAsYouGo"),
 * 			ResourceGroupId:   pulumi.String(defaultGetResourceGroups.Ids[0]),
 * 			SecurityIps: pulumi.StringArray{
 * 				pulumi.String("10.168.1.12"),
 * 				pulumi.String("10.168.1.11"),
 * 			},
 * 			VpcId:     defaultNetwork.ID(),
 * 			VswitchId: defaultSwitch.ID(),
 * 			ZoneId:    pulumi.String(_default.Zones[0].Id),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = adb.NewResourceGroup(ctx, "default", &adb.ResourceGroupArgs{
 * 			GroupName:   pulumi.String("TF_EXAMPLE"),
 * 			GroupType:   pulumi.String("batch"),
 * 			NodeNum:     pulumi.Int(0),
 * 			DbClusterId: defaultDBCluster.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.adb.AdbFunctions;
 * import com.pulumi.alicloud.adb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.adb.DBCluster;
 * import com.pulumi.alicloud.adb.DBClusterArgs;
 * import com.pulumi.alicloud.adb.ResourceGroup;
 * import com.pulumi.alicloud.adb.ResourceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         final var default = AdbFunctions.getZones();
 *         final var defaultGetResourceGroups = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
 *             .status("OK")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("10.4.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var defaultDBCluster = new DBCluster("defaultDBCluster", DBClusterArgs.builder()
 *             .computeResource("48Core192GB")
 *             .dbClusterCategory("MixedStorage")
 *             .dbClusterVersion("3.0")
 *             .dbNodeClass("E32")
 *             .dbNodeStorage(100)
 *             .description(name)
 *             .elasticIoResource(1)
 *             .maintainTime("04:00Z-05:00Z")
 *             .mode("flexible")
 *             .paymentType("PayAsYouGo")
 *             .resourceGroupId(defaultGetResourceGroups.applyValue(getResourceGroupsResult -> getResourceGroupsResult.ids()[0]))
 *             .securityIps(
 *                 "10.168.1.12",
 *                 "10.168.1.11")
 *             .vpcId(defaultNetwork.id())
 *             .vswitchId(defaultSwitch.id())
 *             .zoneId(default_.zones()[0].id())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *         var defaultResourceGroup = new ResourceGroup("defaultResourceGroup", ResourceGroupArgs.builder()
 *             .groupName("TF_EXAMPLE")
 *             .groupType("batch")
 *             .nodeNum(0)
 *             .dbClusterId(defaultDBCluster.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 10.4.0.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}
 *   defaultDBCluster:
 *     type: alicloud:adb:DBCluster
 *     name: default
 *     properties:
 *       computeResource: 48Core192GB
 *       dbClusterCategory: MixedStorage
 *       dbClusterVersion: '3.0'
 *       dbNodeClass: E32
 *       dbNodeStorage: 100
 *       description: ${name}
 *       elasticIoResource: 1
 *       maintainTime: 04:00Z-05:00Z
 *       mode: flexible
 *       paymentType: PayAsYouGo
 *       resourceGroupId: ${defaultGetResourceGroups.ids[0]}
 *       securityIps:
 *         - 10.168.1.12
 *         - 10.168.1.11
 *       vpcId: ${defaultNetwork.id}
 *       vswitchId: ${defaultSwitch.id}
 *       zoneId: ${default.zones[0].id}
 *       tags:
 *         Created: TF
 *         For: example
 *   defaultResourceGroup:
 *     type: alicloud:adb:ResourceGroup
 *     name: default
 *     properties:
 *       groupName: TF_EXAMPLE
 *       groupType: batch
 *       nodeNum: 0
 *       dbClusterId: ${defaultDBCluster.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:adb:getZones
 *       Arguments: {}
 *   defaultGetResourceGroups:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments:
 *         status: OK
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Adb Resource Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:adb/resourceGroup:ResourceGroup example <db_cluster_id>:<group_name>
 * ```
 * @property dbClusterId The ID of the DBCluster.
 * @property groupName The name of the resource group. The `group_name` can be up to 255 characters in length and can contain digits, uppercase letters, hyphens (-), and underscores (_). It must start with a digit or uppercase letter.
 * @property groupType The query execution mode. Default value: `interactive`. Valid values: `interactive`, `batch`.
 * @property nodeNum The number of nodes.
 * @property users The database accounts with which to associate the resource group.
 */
public data class ResourceGroupArgs(
    public val dbClusterId: Output<String>? = null,
    public val groupName: Output<String>? = null,
    public val groupType: Output<String>? = null,
    public val nodeNum: Output<Int>? = null,
    public val users: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.adb.ResourceGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.adb.ResourceGroupArgs =
        com.pulumi.alicloud.adb.ResourceGroupArgs.builder()
            .dbClusterId(dbClusterId?.applyValue({ args0 -> args0 }))
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .groupType(groupType?.applyValue({ args0 -> args0 }))
            .nodeNum(nodeNum?.applyValue({ args0 -> args0 }))
            .users(users?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ResourceGroupArgs].
 */
@PulumiTagMarker
public class ResourceGroupArgsBuilder internal constructor() {
    private var dbClusterId: Output<String>? = null

    private var groupName: Output<String>? = null

    private var groupType: Output<String>? = null

    private var nodeNum: Output<Int>? = null

    private var users: Output<List<String>>? = null

    /**
     * @param value The ID of the DBCluster.
     */
    @JvmName("xbloxjsdfitsotxt")
    public suspend fun dbClusterId(`value`: Output<String>) {
        this.dbClusterId = value
    }

    /**
     * @param value The name of the resource group. The `group_name` can be up to 255 characters in length and can contain digits, uppercase letters, hyphens (-), and underscores (_). It must start with a digit or uppercase letter.
     */
    @JvmName("yduekbeqgdjrcwhv")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value The query execution mode. Default value: `interactive`. Valid values: `interactive`, `batch`.
     */
    @JvmName("djlbmqpjghfsqyxp")
    public suspend fun groupType(`value`: Output<String>) {
        this.groupType = value
    }

    /**
     * @param value The number of nodes.
     */
    @JvmName("kyqawwuishyimupf")
    public suspend fun nodeNum(`value`: Output<Int>) {
        this.nodeNum = value
    }

    /**
     * @param value The database accounts with which to associate the resource group.
     */
    @JvmName("aebyjatlsadcabbl")
    public suspend fun users(`value`: Output<List<String>>) {
        this.users = value
    }

    @JvmName("uolthyfqgtfsefyw")
    public suspend fun users(vararg values: Output<String>) {
        this.users = Output.all(values.asList())
    }

    /**
     * @param values The database accounts with which to associate the resource group.
     */
    @JvmName("fymxgewcgvrrswyp")
    public suspend fun users(values: List<Output<String>>) {
        this.users = Output.all(values)
    }

    /**
     * @param value The ID of the DBCluster.
     */
    @JvmName("eaorauqmfeeijdhp")
    public suspend fun dbClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterId = mapped
    }

    /**
     * @param value The name of the resource group. The `group_name` can be up to 255 characters in length and can contain digits, uppercase letters, hyphens (-), and underscores (_). It must start with a digit or uppercase letter.
     */
    @JvmName("mjbonnykbqlfvtvi")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value The query execution mode. Default value: `interactive`. Valid values: `interactive`, `batch`.
     */
    @JvmName("pdgqqltgtgorgkge")
    public suspend fun groupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupType = mapped
    }

    /**
     * @param value The number of nodes.
     */
    @JvmName("revgcillnmjexspk")
    public suspend fun nodeNum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeNum = mapped
    }

    /**
     * @param value The database accounts with which to associate the resource group.
     */
    @JvmName("tduwliyusokdqxxe")
    public suspend fun users(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.users = mapped
    }

    /**
     * @param values The database accounts with which to associate the resource group.
     */
    @JvmName("yiqgpwktxomjmdje")
    public suspend fun users(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.users = mapped
    }

    internal fun build(): ResourceGroupArgs = ResourceGroupArgs(
        dbClusterId = dbClusterId,
        groupName = groupName,
        groupType = groupType,
        nodeNum = nodeNum,
        users = users,
    )
}
