@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin.inputs

import com.pulumi.alicloud.adb.inputs.GetDBClustersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDBClusters.
 * @property description The description of DBCluster.
 * @property descriptionRegex A regex string to filter results by DBCluster description.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of DBCluster IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property resourceGroupId The ID of the resource group.
 * @property status The status of the resource.
 * @property tags A map of tags assigned to the cluster.
 */
public data class GetDBClustersPlainArgs(
    public val description: String? = null,
    public val descriptionRegex: String? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.adb.inputs.GetDBClustersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.adb.inputs.GetDBClustersPlainArgs =
        com.pulumi.alicloud.adb.inputs.GetDBClustersPlainArgs.builder()
            .description(description?.let({ args0 -> args0 }))
            .descriptionRegex(descriptionRegex?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetDBClustersPlainArgs].
 */
@PulumiTagMarker
public class GetDBClustersPlainArgsBuilder internal constructor() {
    private var description: String? = null

    private var descriptionRegex: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var resourceGroupId: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value The description of DBCluster.
     */
    @JvmName("vxssrpkidbsrwumb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.description = mapped
    }

    /**
     * @param value A regex string to filter results by DBCluster description.
     */
    @JvmName("nqobifrtpkqxcqxu")
    public suspend fun descriptionRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.descriptionRegex = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("foyriiqlcrswfebg")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of DBCluster IDs.
     */
    @JvmName("fbfcunribaddragt")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of DBCluster IDs.
     */
    @JvmName("wdwchkiskkurjjdt")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("jtmagpunolboqdkh")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("dsyteuubilafhgau")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("oiukvejeiglqpaap")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("tbgvgqrdmcefvflj")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The status of the resource.
     */
    @JvmName("rnetvdqdnpqaucnr")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A map of tags assigned to the cluster.
     */
    @JvmName("mpcbnuvnnmmpdxby")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A map of tags assigned to the cluster.
     */
    @JvmName("sgrdlglclmqnymjt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetDBClustersPlainArgs = GetDBClustersPlainArgs(
        description = description,
        descriptionRegex = descriptionRegex,
        enableDetails = enableDetails,
        ids = ids,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        resourceGroupId = resourceGroupId,
        status = status,
        tags = tags,
    )
}
