@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin.inputs

import com.pulumi.alicloud.adb.inputs.GetResourceGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResourceGroups.
 * @property dbClusterId DBClusterId
 * @property groupName The name of the resource pool, which cannot exceed 64 bytes in length.
 * @property ids A list of AnalyticDB for MySQL (ADB) Resource Group IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetResourceGroupsPlainArgs(
    public val dbClusterId: String,
    public val groupName: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.adb.inputs.GetResourceGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.adb.inputs.GetResourceGroupsPlainArgs =
        com.pulumi.alicloud.adb.inputs.GetResourceGroupsPlainArgs.builder()
            .dbClusterId(dbClusterId.let({ args0 -> args0 }))
            .groupName(groupName?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResourceGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetResourceGroupsPlainArgsBuilder internal constructor() {
    private var dbClusterId: String? = null

    private var groupName: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    /**
     * @param value DBClusterId
     */
    @JvmName("rxfjipbogysosvyb")
    public suspend fun dbClusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbClusterId = mapped
    }

    /**
     * @param value The name of the resource pool, which cannot exceed 64 bytes in length.
     */
    @JvmName("vekguvjomubfyegs")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupName = mapped
    }

    /**
     * @param value A list of AnalyticDB for MySQL (ADB) Resource Group IDs.
     */
    @JvmName("cqblllrwnlmbshju")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of AnalyticDB for MySQL (ADB) Resource Group IDs.
     */
    @JvmName("hprawktqkeilpban")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("gjdnpyvnsphowffo")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetResourceGroupsPlainArgs = GetResourceGroupsPlainArgs(
        dbClusterId = dbClusterId ?: throw PulumiNullFieldException("dbClusterId"),
        groupName = groupName,
        ids = ids,
        outputFile = outputFile,
    )
}
