@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin.inputs

import com.pulumi.alicloud.adb.inputs.GetZonesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getZones.
 * @property multi Indicate whether the zones can be used in a multi AZ configuration. Default to `false`. Multi AZ is usually used to launch ADB instances.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetZonesPlainArgs(
    public val multi: Boolean? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.adb.inputs.GetZonesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.adb.inputs.GetZonesPlainArgs =
        com.pulumi.alicloud.adb.inputs.GetZonesPlainArgs.builder()
            .multi(multi?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetZonesPlainArgs].
 */
@PulumiTagMarker
public class GetZonesPlainArgsBuilder internal constructor() {
    private var multi: Boolean? = null

    private var outputFile: String? = null

    /**
     * @param value Indicate whether the zones can be used in a multi AZ configuration. Default to `false`. Multi AZ is usually used to launch ADB instances.
     */
    @JvmName("opsafvkscideoavo")
    public suspend fun multi(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.multi = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("rdcbghqybeeixpft")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetZonesPlainArgs = GetZonesPlainArgs(
        multi = multi,
        outputFile = outputFile,
    )
}
