@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin.inputs

import com.pulumi.alicloud.adb.inputs.LakeAccountAccountPrivilegeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property privilegeObject Object associated to privileges. See `privilege_object` below.
 * @property privilegeType The type of privileges.
 * @property privileges privilege list.
 */
public data class LakeAccountAccountPrivilegeArgs(
    public val privilegeObject: Output<LakeAccountAccountPrivilegePrivilegeObjectArgs>? = null,
    public val privilegeType: Output<String>? = null,
    public val privileges: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.adb.inputs.LakeAccountAccountPrivilegeArgs> {
    override fun toJava(): com.pulumi.alicloud.adb.inputs.LakeAccountAccountPrivilegeArgs =
        com.pulumi.alicloud.adb.inputs.LakeAccountAccountPrivilegeArgs.builder()
            .privilegeObject(privilegeObject?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privilegeType(privilegeType?.applyValue({ args0 -> args0 }))
            .privileges(privileges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [LakeAccountAccountPrivilegeArgs].
 */
@PulumiTagMarker
public class LakeAccountAccountPrivilegeArgsBuilder internal constructor() {
    private var privilegeObject: Output<LakeAccountAccountPrivilegePrivilegeObjectArgs>? = null

    private var privilegeType: Output<String>? = null

    private var privileges: Output<List<String>>? = null

    /**
     * @param value Object associated to privileges. See `privilege_object` below.
     */
    @JvmName("gngpstbjiodglkft")
    public suspend fun privilegeObject(`value`: Output<LakeAccountAccountPrivilegePrivilegeObjectArgs>) {
        this.privilegeObject = value
    }

    /**
     * @param value The type of privileges.
     */
    @JvmName("kkmhxktmepugvrtr")
    public suspend fun privilegeType(`value`: Output<String>) {
        this.privilegeType = value
    }

    /**
     * @param value privilege list.
     */
    @JvmName("sruwogvnsbkqutlv")
    public suspend fun privileges(`value`: Output<List<String>>) {
        this.privileges = value
    }

    @JvmName("btcmauvpblwitkvq")
    public suspend fun privileges(vararg values: Output<String>) {
        this.privileges = Output.all(values.asList())
    }

    /**
     * @param values privilege list.
     */
    @JvmName("ceqsgtbtlpgqfpyk")
    public suspend fun privileges(values: List<Output<String>>) {
        this.privileges = Output.all(values)
    }

    /**
     * @param value Object associated to privileges. See `privilege_object` below.
     */
    @JvmName("ssexweaadfkrwesv")
    public suspend fun privilegeObject(`value`: LakeAccountAccountPrivilegePrivilegeObjectArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privilegeObject = mapped
    }

    /**
     * @param argument Object associated to privileges. See `privilege_object` below.
     */
    @JvmName("bclpdxnudlfkoaro")
    public suspend fun privilegeObject(argument: suspend LakeAccountAccountPrivilegePrivilegeObjectArgsBuilder.() -> Unit) {
        val toBeMapped = LakeAccountAccountPrivilegePrivilegeObjectArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privilegeObject = mapped
    }

    /**
     * @param value The type of privileges.
     */
    @JvmName("jilvumqaldhrpjku")
    public suspend fun privilegeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privilegeType = mapped
    }

    /**
     * @param value privilege list.
     */
    @JvmName("oaidqkwosbvsqkxj")
    public suspend fun privileges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privileges = mapped
    }

    /**
     * @param values privilege list.
     */
    @JvmName("ewwspfqhskgnvaqp")
    public suspend fun privileges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privileges = mapped
    }

    internal fun build(): LakeAccountAccountPrivilegeArgs = LakeAccountAccountPrivilegeArgs(
        privilegeObject = privilegeObject,
        privilegeType = privilegeType,
        privileges = privileges,
    )
}
