@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin.inputs

import com.pulumi.alicloud.adb.inputs.LakeAccountAccountPrivilegePrivilegeObjectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property column The name of column.
 * @property database The name of database.
 * @property table The name of table.
 */
public data class LakeAccountAccountPrivilegePrivilegeObjectArgs(
    public val column: Output<String>? = null,
    public val database: Output<String>? = null,
    public val table: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.adb.inputs.LakeAccountAccountPrivilegePrivilegeObjectArgs> {
    override fun toJava(): com.pulumi.alicloud.adb.inputs.LakeAccountAccountPrivilegePrivilegeObjectArgs =
        com.pulumi.alicloud.adb.inputs.LakeAccountAccountPrivilegePrivilegeObjectArgs.builder()
            .column(column?.applyValue({ args0 -> args0 }))
            .database(database?.applyValue({ args0 -> args0 }))
            .table(table?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LakeAccountAccountPrivilegePrivilegeObjectArgs].
 */
@PulumiTagMarker
public class LakeAccountAccountPrivilegePrivilegeObjectArgsBuilder internal constructor() {
    private var column: Output<String>? = null

    private var database: Output<String>? = null

    private var table: Output<String>? = null

    /**
     * @param value The name of column.
     */
    @JvmName("eutrvltclugdcult")
    public suspend fun column(`value`: Output<String>) {
        this.column = value
    }

    /**
     * @param value The name of database.
     */
    @JvmName("wvmvlcnxwwyxoern")
    public suspend fun database(`value`: Output<String>) {
        this.database = value
    }

    /**
     * @param value The name of table.
     */
    @JvmName("bnelxjeeadvldlqt")
    public suspend fun table(`value`: Output<String>) {
        this.table = value
    }

    /**
     * @param value The name of column.
     */
    @JvmName("ehgwrfamgmpnmnvj")
    public suspend fun column(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.column = mapped
    }

    /**
     * @param value The name of database.
     */
    @JvmName("vhjqflfacadtgwfn")
    public suspend fun database(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value The name of table.
     */
    @JvmName("oikelghkkqkufohy")
    public suspend fun table(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.table = mapped
    }

    internal fun build(): LakeAccountAccountPrivilegePrivilegeObjectArgs =
        LakeAccountAccountPrivilegePrivilegeObjectArgs(
            column = column,
            database = database,
            table = table,
        )
}
