@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property autoRenewPeriod
 * @property chargeType Billing method. Value options: `PostPaid` for Pay-As-You-Go and `PrePaid` for subscription.
 * @property commodityCode
 * @property computeResource
 * @property connectionString
 * @property createTime The CreateTime of the ADB cluster.
 * @property dbClusterCategory
 * @property dbClusterId
 * @property dbClusterNetworkType
 * @property dbClusterType
 * @property dbClusterVersion
 * @property dbNodeClass The DBNodeClass of the ADB cluster.
 * @property dbNodeCount The DBNodeCount of the ADB cluster.
 * @property dbNodeStorage The DBNodeStorage of the ADB cluster.
 * @property description The description of the ADB cluster.
 * @property diskType
 * @property dtsJobId
 * @property elasticIoResource
 * @property engine
 * @property engineVersion
 * @property executorCount
 * @property expireTime Expiration time. Pay-As-You-Go clusters never expire.
 * @property expired The expired of the ADB cluster.
 * @property id The ID of the ADB cluster.
 * @property lockMode The LockMode of the ADB cluster.
 * @property lockReason
 * @property maintainTime
 * @property mode
 * @property networkType The DBClusterNetworkType of the ADB cluster.
 * @property paymentType
 * @property port
 * @property rdsInstanceId
 * @property regionId Region ID the cluster belongs to.
 * @property renewalStatus
 * @property resourceGroupId
 * @property securityIps
 * @property status The status of the cluster. Valid values: `Preparing`, `Creating`, `Restoring`, `Running`, `Deleting`, `ClassChanging`, `NetAddressCreating`, `NetAddressDeleting`. For more information, see [Cluster status](https://www.alibabacloud.com/help/doc-detail/143075.htm).
 * @property storageResource
 * @property tags A mapping of tags to assign to the resource.
 * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
 * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
 * @property vpcCloudInstanceId
 * @property vpcId ID of the VPC the cluster belongs to.
 * @property vswitchId
 * @property zoneId The ZoneId of the ADB cluster.
 */
public data class GetClustersCluster(
    public val autoRenewPeriod: Int,
    public val chargeType: String,
    public val commodityCode: String,
    public val computeResource: String,
    public val connectionString: String,
    public val createTime: String,
    public val dbClusterCategory: String,
    public val dbClusterId: String,
    public val dbClusterNetworkType: String,
    public val dbClusterType: String,
    public val dbClusterVersion: String,
    public val dbNodeClass: String,
    public val dbNodeCount: Int,
    public val dbNodeStorage: Int,
    public val description: String,
    public val diskType: String,
    public val dtsJobId: String,
    public val elasticIoResource: Int,
    public val engine: String,
    public val engineVersion: String,
    public val executorCount: String,
    public val expireTime: String,
    public val expired: String,
    public val id: String,
    public val lockMode: String,
    public val lockReason: String,
    public val maintainTime: String,
    public val mode: String,
    public val networkType: String,
    public val paymentType: String,
    public val port: Int,
    public val rdsInstanceId: String,
    public val regionId: String,
    public val renewalStatus: String,
    public val resourceGroupId: String,
    public val securityIps: List<String>,
    public val status: String,
    public val storageResource: String,
    public val tags: Map<String, String>,
    public val vpcCloudInstanceId: String,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.adb.outputs.GetClustersCluster): GetClustersCluster = GetClustersCluster(
            autoRenewPeriod = javaType.autoRenewPeriod(),
            chargeType = javaType.chargeType(),
            commodityCode = javaType.commodityCode(),
            computeResource = javaType.computeResource(),
            connectionString = javaType.connectionString(),
            createTime = javaType.createTime(),
            dbClusterCategory = javaType.dbClusterCategory(),
            dbClusterId = javaType.dbClusterId(),
            dbClusterNetworkType = javaType.dbClusterNetworkType(),
            dbClusterType = javaType.dbClusterType(),
            dbClusterVersion = javaType.dbClusterVersion(),
            dbNodeClass = javaType.dbNodeClass(),
            dbNodeCount = javaType.dbNodeCount(),
            dbNodeStorage = javaType.dbNodeStorage(),
            description = javaType.description(),
            diskType = javaType.diskType(),
            dtsJobId = javaType.dtsJobId(),
            elasticIoResource = javaType.elasticIoResource(),
            engine = javaType.engine(),
            engineVersion = javaType.engineVersion(),
            executorCount = javaType.executorCount(),
            expireTime = javaType.expireTime(),
            expired = javaType.expired(),
            id = javaType.id(),
            lockMode = javaType.lockMode(),
            lockReason = javaType.lockReason(),
            maintainTime = javaType.maintainTime(),
            mode = javaType.mode(),
            networkType = javaType.networkType(),
            paymentType = javaType.paymentType(),
            port = javaType.port(),
            rdsInstanceId = javaType.rdsInstanceId(),
            regionId = javaType.regionId(),
            renewalStatus = javaType.renewalStatus(),
            resourceGroupId = javaType.resourceGroupId(),
            securityIps = javaType.securityIps().map({ args0 -> args0 }),
            status = javaType.status(),
            storageResource = javaType.storageResource(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcCloudInstanceId = javaType.vpcCloudInstanceId(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
