@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getClusters.
 * @property clusters A list of ADB clusters. Each element contains the following attributes:
 * @property description The description of the ADB cluster.
 * @property descriptionRegex
 * @property descriptions A list of ADB cluster descriptions.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of ADB cluster IDs.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property resourceGroupId
 * @property status Status of the cluster.
 * @property tags
 * @property totalCount
 */
public data class GetClustersResult(
    public val clusters: List<GetClustersCluster>,
    public val description: String? = null,
    public val descriptionRegex: String? = null,
    public val descriptions: List<String>,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val totalCount: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.adb.outputs.GetClustersResult): GetClustersResult = GetClustersResult(
            clusters = javaType.clusters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.adb.kotlin.outputs.GetClustersCluster.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            descriptionRegex = javaType.descriptionRegex().map({ args0 -> args0 }).orElse(null),
            descriptions = javaType.descriptions().map({ args0 -> args0 }),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            totalCount = javaType.totalCount(),
        )
    }
}
