@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDBClusterLakeVersions.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property resourceGroupId
 * @property status
 * @property versions
 */
public data class GetDBClusterLakeVersionsResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val versions: List<GetDBClusterLakeVersionsVersion>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.adb.outputs.GetDBClusterLakeVersionsResult): GetDBClusterLakeVersionsResult = GetDBClusterLakeVersionsResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            versions = javaType.versions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.adb.kotlin.outputs.GetDBClusterLakeVersionsVersion.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
