@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property commodityCode The name of the service.
 * @property computeResource The specifications of computing resources in elastic mode. The increase of resources can speed up queries.
 * @property connectionString The endpoint of the cluster.
 * @property createTime The CreateTime of the ADB cluster.
 * @property dbClusterId The ID of the DBCluster.
 * @property dbClusterVersion The db cluster version.
 * @property engine The engine of the database.
 * @property engineVersion The engine version of the database.
 * @property expireTime The time when the cluster expires.
 * @property expired Indicates whether the cluster has expired.
 * @property id The ID of the DBCluster.
 * @property lockMode The lock mode of the cluster.
 * @property lockReason The reason why the cluster is locked.
 * @property paymentType The payment type of the resource.
 * @property port The port that is used to access the cluster.
 * @property resourceGroupId The ID of the resource group.
 * @property status The status of the resource.
 * @property storageResource The specifications of storage resources in elastic mode. The resources are used for data read and write operations.
 * @property vpcId The vpc id.
 * @property vswitchId The vswitch id.
 * @property zoneId The zone ID  of the resource.
 */
public data class GetDBClusterLakeVersionsVersion(
    public val commodityCode: String,
    public val computeResource: String,
    public val connectionString: String,
    public val createTime: String,
    public val dbClusterId: String,
    public val dbClusterVersion: String,
    public val engine: String,
    public val engineVersion: String,
    public val expireTime: String,
    public val expired: String,
    public val id: String,
    public val lockMode: String,
    public val lockReason: String,
    public val paymentType: String,
    public val port: String,
    public val resourceGroupId: String,
    public val status: String,
    public val storageResource: String,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.adb.outputs.GetDBClusterLakeVersionsVersion): GetDBClusterLakeVersionsVersion = GetDBClusterLakeVersionsVersion(
            commodityCode = javaType.commodityCode(),
            computeResource = javaType.computeResource(),
            connectionString = javaType.connectionString(),
            createTime = javaType.createTime(),
            dbClusterId = javaType.dbClusterId(),
            dbClusterVersion = javaType.dbClusterVersion(),
            engine = javaType.engine(),
            engineVersion = javaType.engineVersion(),
            expireTime = javaType.expireTime(),
            expired = javaType.expired(),
            id = javaType.id(),
            lockMode = javaType.lockMode(),
            lockReason = javaType.lockReason(),
            paymentType = javaType.paymentType(),
            port = javaType.port(),
            resourceGroupId = javaType.resourceGroupId(),
            status = javaType.status(),
            storageResource = javaType.storageResource(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
