@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property autoRenewPeriod Auto-renewal period of an cluster, in the unit of the month.
 * @property chargeType The payment type of the resource.
 * @property commodityCode The name of the service.
 * @property computeResource The specifications of computing resources in elastic mode. The increase of resources can speed up queries. AnalyticDB for MySQL automatically scales computing resources.
 * @property connectionString The endpoint of the cluster.
 * @property createTime The CreateTime of the ADB cluster.
 * @property dbClusterCategory The db cluster category.
 * @property dbClusterId The db cluster id.
 * @property dbClusterNetworkType The db cluster network type.
 * @property dbClusterType The db cluster type.
 * @property dbClusterVersion The db cluster version.
 * @property dbNodeClass The db node class.
 * @property dbNodeCount The db node count.
 * @property dbNodeStorage The db node storage.
 * @property description The description of DBCluster.
 * @property diskType The type of the disk.
 * @property dtsJobId The ID of the data synchronization task in Data Transmission Service (DTS). This parameter is valid only for analytic instances.
 * @property elasticIoResource The elastic io resource.
 * @property engine The engine of the database.
 * @property engineVersion The engine version of the database.
 * @property executorCount The number of nodes. The node resources are used for data computing in elastic mode.
 * @property expireTime The time when the cluster expires.
 * @property expired Indicates whether the cluster has expired.
 * @property id The ID of the DBCluster.
 * @property lockMode The lock mode of the cluster.
 * @property lockReason The reason why the cluster is locked.
 * @property maintainTime The maintenance window of the cluster.
 * @property mode The lock mode of the cluster.
 * @property networkType The db cluster network type.
 * @property paymentType The payment type of the resource.
 * @property port The port that is used to access the cluster.
 * @property rdsInstanceId The ID of the ApsaraDB RDS instance from which data is synchronized to the cluster. This parameter is valid only for analytic instances.
 * @property regionId The region ID  of the resource.
 * @property renewalStatus The status of renewal.
 * @property resourceGroupId The ID of the resource group.
 * @property securityIps List of IP addresses allowed to access all databases of an cluster.
 * @property status The status of the resource.
 * @property storageResource The specifications of storage resources in elastic mode. The resources are used for data read and write operations. The increase of resources can improve the read and write performance of your cluster.
 * @property tags A map of tags assigned to the cluster.
 * @property vpcCloudInstanceId The vpc cloud instance id.
 * @property vpcId The vpc id.
 * @property vswitchId The vswitch id.
 * @property zoneId The zone ID  of the resource.
 */
public data class GetDBClustersCluster(
    public val autoRenewPeriod: Int,
    public val chargeType: String,
    public val commodityCode: String,
    public val computeResource: String,
    public val connectionString: String,
    public val createTime: String,
    public val dbClusterCategory: String,
    public val dbClusterId: String,
    public val dbClusterNetworkType: String,
    public val dbClusterType: String,
    public val dbClusterVersion: String,
    public val dbNodeClass: String,
    public val dbNodeCount: Int,
    public val dbNodeStorage: Int,
    public val description: String,
    public val diskType: String,
    public val dtsJobId: String,
    public val elasticIoResource: Int,
    public val engine: String,
    public val engineVersion: String,
    public val executorCount: String,
    public val expireTime: String,
    public val expired: String,
    public val id: String,
    public val lockMode: String,
    public val lockReason: String,
    public val maintainTime: String,
    public val mode: String,
    public val networkType: String,
    public val paymentType: String,
    public val port: Int,
    public val rdsInstanceId: String,
    public val regionId: String,
    public val renewalStatus: String,
    public val resourceGroupId: String,
    public val securityIps: List<String>,
    public val status: String,
    public val storageResource: String,
    public val tags: Map<String, String>,
    public val vpcCloudInstanceId: String,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.adb.outputs.GetDBClustersCluster): GetDBClustersCluster = GetDBClustersCluster(
            autoRenewPeriod = javaType.autoRenewPeriod(),
            chargeType = javaType.chargeType(),
            commodityCode = javaType.commodityCode(),
            computeResource = javaType.computeResource(),
            connectionString = javaType.connectionString(),
            createTime = javaType.createTime(),
            dbClusterCategory = javaType.dbClusterCategory(),
            dbClusterId = javaType.dbClusterId(),
            dbClusterNetworkType = javaType.dbClusterNetworkType(),
            dbClusterType = javaType.dbClusterType(),
            dbClusterVersion = javaType.dbClusterVersion(),
            dbNodeClass = javaType.dbNodeClass(),
            dbNodeCount = javaType.dbNodeCount(),
            dbNodeStorage = javaType.dbNodeStorage(),
            description = javaType.description(),
            diskType = javaType.diskType(),
            dtsJobId = javaType.dtsJobId(),
            elasticIoResource = javaType.elasticIoResource(),
            engine = javaType.engine(),
            engineVersion = javaType.engineVersion(),
            executorCount = javaType.executorCount(),
            expireTime = javaType.expireTime(),
            expired = javaType.expired(),
            id = javaType.id(),
            lockMode = javaType.lockMode(),
            lockReason = javaType.lockReason(),
            maintainTime = javaType.maintainTime(),
            mode = javaType.mode(),
            networkType = javaType.networkType(),
            paymentType = javaType.paymentType(),
            port = javaType.port(),
            rdsInstanceId = javaType.rdsInstanceId(),
            regionId = javaType.regionId(),
            renewalStatus = javaType.renewalStatus(),
            resourceGroupId = javaType.resourceGroupId(),
            securityIps = javaType.securityIps().map({ args0 -> args0 }),
            status = javaType.status(),
            storageResource = javaType.storageResource(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcCloudInstanceId = javaType.vpcCloudInstanceId(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
