@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime Creation time.
 * @property dbClusterId DBClusterId
 * @property groupName The name of the resource pool, which cannot exceed 64 bytes in length.
 * @property groupType Query type, value description:
 * * **etl**: Batch query mode.
 * * **interactive**: interactive Query mode
 * * **default_type**: the default query mode.
 * @property id The `key` of the resource supplied above.The value is formulated as `<db_cluster_id>:<group_name>`.
 * @property nodeNum The number of nodes. The default number of nodes is 0. The number of nodes must be less than or equal to the number of nodes whose resource name is USER_DEFAULT.
 * @property user Binding User.
 */
public data class GetResourceGroupsGroup(
    public val createTime: String,
    public val dbClusterId: String,
    public val groupName: String,
    public val groupType: String,
    public val id: String,
    public val nodeNum: Int,
    public val user: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.adb.outputs.GetResourceGroupsGroup): GetResourceGroupsGroup = GetResourceGroupsGroup(
            createTime = javaType.createTime(),
            dbClusterId = javaType.dbClusterId(),
            groupName = javaType.groupName(),
            groupType = javaType.groupType(),
            id = javaType.id(),
            nodeNum = javaType.nodeNum(),
            user = javaType.user(),
        )
    }
}
