@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getResourceGroups.
 * @property dbClusterId DB cluster id.
 * @property groupName The name of the resource pool.
 * @property groups A list of Resource Group Entries. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 */
public data class GetResourceGroupsResult(
    public val dbClusterId: String,
    public val groupName: String? = null,
    public val groups: List<GetResourceGroupsGroup>,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.adb.outputs.GetResourceGroupsResult): GetResourceGroupsResult = GetResourceGroupsResult(
            dbClusterId = javaType.dbClusterId(),
            groupName = javaType.groupName().map({ args0 -> args0 }).orElse(null),
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.adb.kotlin.outputs.GetResourceGroupsGroup.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
