@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property privilegeObject Object associated to privileges. See `privilege_object` below.
 * @property privilegeType The type of privileges.
 * @property privileges privilege list.
 */
public data class LakeAccountAccountPrivilege(
    public val privilegeObject: LakeAccountAccountPrivilegePrivilegeObject? = null,
    public val privilegeType: String? = null,
    public val privileges: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.adb.outputs.LakeAccountAccountPrivilege): LakeAccountAccountPrivilege = LakeAccountAccountPrivilege(
            privilegeObject = javaType.privilegeObject().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.adb.kotlin.outputs.LakeAccountAccountPrivilegePrivilegeObject.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privilegeType = javaType.privilegeType().map({ args0 -> args0 }).orElse(null),
            privileges = javaType.privileges().map({ args0 -> args0 }),
        )
    }
}
