@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.alicloud.alb.kotlin.outputs.AScriptExtAttribute
import com.pulumi.alicloud.alb.kotlin.outputs.AScriptExtAttribute.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [AScript].
 */
@PulumiTagMarker
public class AScriptResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AScriptArgs = AScriptArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AScriptArgsBuilder.() -> Unit) {
        val builder = AScriptArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AScript {
        val builtJavaResource = com.pulumi.alicloud.alb.AScript(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AScript(builtJavaResource)
    }
}

/**
 * Provides a Alb Ascript resource.
 * For information about Alb Ascript and how to use it, see [What is AScript](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createascripts).
 * > **NOTE:** Available since v1.195.0.
 * ## Import
 * Alb AScript can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alb/aScript:AScript example <id>
 * ```
 */
public class AScript internal constructor(
    override val javaResource: com.pulumi.alicloud.alb.AScript,
) : KotlinCustomResource(javaResource, AScriptMapper) {
    /**
     * The name of AScript.
     */
    public val ascriptName: Output<String>
        get() = javaResource.ascriptName().applyValue({ args0 -> args0 })

    /**
     * Whether scripts are enabled.
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * Whether extension parameters are enabled.
     */
    public val extAttributeEnabled: Output<Boolean>
        get() = javaResource.extAttributeEnabled().applyValue({ args0 -> args0 })

    /**
     * Extended attribute list. See `ext_attributes` below for details.
     */
    public val extAttributes: Output<List<AScriptExtAttribute>>
        get() = javaResource.extAttributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * Listener ID of script attribution
     */
    public val listenerId: Output<String>
        get() = javaResource.listenerId().applyValue({ args0 -> args0 })

    /**
     * The ID of load balancer instance.
     */
    public val loadBalancerId: Output<String>
        get() = javaResource.loadBalancerId().applyValue({ args0 -> args0 })

    /**
     * Execution location of AScript.
     */
    public val position: Output<String>
        get() = javaResource.position().applyValue({ args0 -> args0 })

    /**
     * The content of AScript.
     */
    public val scriptContent: Output<String>
        get() = javaResource.scriptContent().applyValue({ args0 -> args0 })

    /**
     * The status of AScript.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object AScriptMapper : ResourceMapper<AScript> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.alb.AScript::class == javaResource::class

    override fun map(javaResource: Resource): AScript = AScript(
        javaResource as
            com.pulumi.alicloud.alb.AScript,
    )
}

/**
 * @see [AScript].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AScript].
 */
public suspend fun aScript(name: String, block: suspend AScriptResourceBuilder.() -> Unit): AScript {
    val builder = AScriptResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AScript].
 * @param name The _unique_ name of the resulting resource.
 */
public fun aScript(name: String): AScript {
    val builder = AScriptResourceBuilder()
    builder.name(name)
    return builder.build()
}
