@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.alicloud.alb.AScriptArgs.builder
import com.pulumi.alicloud.alb.kotlin.inputs.AScriptExtAttributeArgs
import com.pulumi.alicloud.alb.kotlin.inputs.AScriptExtAttributeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Alb Ascript resource.
 * For information about Alb Ascript and how to use it, see [What is AScript](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createascripts).
 * > **NOTE:** Available since v1.195.0.
 * ## Import
 * Alb AScript can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alb/aScript:AScript example <id>
 * ```
 * @property ascriptName The name of AScript.
 * @property enabled Whether scripts are enabled.
 * @property extAttributeEnabled Whether extension parameters are enabled.
 * @property extAttributes Extended attribute list. See `ext_attributes` below for details.
 * @property listenerId Listener ID of script attribution
 * @property position Execution location of AScript.
 * @property scriptContent The content of AScript.
 */
public data class AScriptArgs(
    public val ascriptName: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val extAttributeEnabled: Output<Boolean>? = null,
    public val extAttributes: Output<List<AScriptExtAttributeArgs>>? = null,
    public val listenerId: Output<String>? = null,
    public val position: Output<String>? = null,
    public val scriptContent: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.AScriptArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.AScriptArgs =
        com.pulumi.alicloud.alb.AScriptArgs.builder()
            .ascriptName(ascriptName?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .extAttributeEnabled(extAttributeEnabled?.applyValue({ args0 -> args0 }))
            .extAttributes(
                extAttributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .listenerId(listenerId?.applyValue({ args0 -> args0 }))
            .position(position?.applyValue({ args0 -> args0 }))
            .scriptContent(scriptContent?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AScriptArgs].
 */
@PulumiTagMarker
public class AScriptArgsBuilder internal constructor() {
    private var ascriptName: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var extAttributeEnabled: Output<Boolean>? = null

    private var extAttributes: Output<List<AScriptExtAttributeArgs>>? = null

    private var listenerId: Output<String>? = null

    private var position: Output<String>? = null

    private var scriptContent: Output<String>? = null

    /**
     * @param value The name of AScript.
     */
    @JvmName("totrqnddwfsdoqrp")
    public suspend fun ascriptName(`value`: Output<String>) {
        this.ascriptName = value
    }

    /**
     * @param value Whether scripts are enabled.
     */
    @JvmName("juiatrrgxkcsljil")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Whether extension parameters are enabled.
     */
    @JvmName("uqxymvfimmkkrylk")
    public suspend fun extAttributeEnabled(`value`: Output<Boolean>) {
        this.extAttributeEnabled = value
    }

    /**
     * @param value Extended attribute list. See `ext_attributes` below for details.
     */
    @JvmName("sfaujconjwbiqgmt")
    public suspend fun extAttributes(`value`: Output<List<AScriptExtAttributeArgs>>) {
        this.extAttributes = value
    }

    @JvmName("qspmfhyjauydiknw")
    public suspend fun extAttributes(vararg values: Output<AScriptExtAttributeArgs>) {
        this.extAttributes = Output.all(values.asList())
    }

    /**
     * @param values Extended attribute list. See `ext_attributes` below for details.
     */
    @JvmName("gghuxskpgssjhmmi")
    public suspend fun extAttributes(values: List<Output<AScriptExtAttributeArgs>>) {
        this.extAttributes = Output.all(values)
    }

    /**
     * @param value Listener ID of script attribution
     */
    @JvmName("ysvkebqjwpwrnoqn")
    public suspend fun listenerId(`value`: Output<String>) {
        this.listenerId = value
    }

    /**
     * @param value Execution location of AScript.
     */
    @JvmName("ogopmmqcwetwpaqn")
    public suspend fun position(`value`: Output<String>) {
        this.position = value
    }

    /**
     * @param value The content of AScript.
     */
    @JvmName("qrbhpbqvivgdkmpd")
    public suspend fun scriptContent(`value`: Output<String>) {
        this.scriptContent = value
    }

    /**
     * @param value The name of AScript.
     */
    @JvmName("fusgywtcpasqhfeo")
    public suspend fun ascriptName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ascriptName = mapped
    }

    /**
     * @param value Whether scripts are enabled.
     */
    @JvmName("cqkiqtlgoihhqlin")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Whether extension parameters are enabled.
     */
    @JvmName("chgiiymxlcewcnfn")
    public suspend fun extAttributeEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extAttributeEnabled = mapped
    }

    /**
     * @param value Extended attribute list. See `ext_attributes` below for details.
     */
    @JvmName("cdpyctjujhxibwyf")
    public suspend fun extAttributes(`value`: List<AScriptExtAttributeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extAttributes = mapped
    }

    /**
     * @param argument Extended attribute list. See `ext_attributes` below for details.
     */
    @JvmName("qmltyrxcudcnbfgs")
    public suspend fun extAttributes(argument: List<suspend AScriptExtAttributeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AScriptExtAttributeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.extAttributes = mapped
    }

    /**
     * @param argument Extended attribute list. See `ext_attributes` below for details.
     */
    @JvmName("itdhpcpxdvsoxwyp")
    public suspend fun extAttributes(vararg argument: suspend AScriptExtAttributeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AScriptExtAttributeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.extAttributes = mapped
    }

    /**
     * @param argument Extended attribute list. See `ext_attributes` below for details.
     */
    @JvmName("cryepaydnlvuaeav")
    public suspend fun extAttributes(argument: suspend AScriptExtAttributeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AScriptExtAttributeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.extAttributes = mapped
    }

    /**
     * @param values Extended attribute list. See `ext_attributes` below for details.
     */
    @JvmName("ysemubevcxkvyufa")
    public suspend fun extAttributes(vararg values: AScriptExtAttributeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extAttributes = mapped
    }

    /**
     * @param value Listener ID of script attribution
     */
    @JvmName("prourxssliwrexog")
    public suspend fun listenerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerId = mapped
    }

    /**
     * @param value Execution location of AScript.
     */
    @JvmName("sdxspuetwyrxclvx")
    public suspend fun position(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.position = mapped
    }

    /**
     * @param value The content of AScript.
     */
    @JvmName("wjvdvjkkhiperxxo")
    public suspend fun scriptContent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptContent = mapped
    }

    internal fun build(): AScriptArgs = AScriptArgs(
        ascriptName = ascriptName,
        enabled = enabled,
        extAttributeEnabled = extAttributeEnabled,
        extAttributes = extAttributes,
        listenerId = listenerId,
        position = position,
        scriptContent = scriptContent,
    )
}
