@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.alicloud.alb.kotlin.outputs.AclAclEntry
import com.pulumi.alicloud.alb.kotlin.outputs.AclAclEntry.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Acl].
 */
@PulumiTagMarker
public class AclResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AclArgs = AclArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AclArgsBuilder.() -> Unit) {
        val builder = AclArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Acl {
        val builtJavaResource = com.pulumi.alicloud.alb.Acl(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Acl(builtJavaResource)
    }
}

/**
 * Provides a Application Load Balancer (ALB) Acl resource.
 * For information about ALB Acl and how to use it, see [What is Acl](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createacl).
 * > **NOTE:** Available since v1.133.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultAcl = new alicloud.alb.Acl("default", {
 *     aclName: "tf_example",
 *     resourceGroupId: _default.then(_default => _default.groups?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_acl = alicloud.alb.Acl("default",
 *     acl_name="tf_example",
 *     resource_group_id=default.groups[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultAcl = new AliCloud.Alb.Acl("default", new()
 *     {
 *         AclName = "tf_example",
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/alb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = alb.NewAcl(ctx, "default", &alb.AclArgs{
 * 			AclName:         pulumi.String("tf_example"),
 * 			ResourceGroupId: pulumi.String(_default.Groups[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.alb.Acl;
 * import com.pulumi.alicloud.alb.AclArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultAcl = new Acl("defaultAcl", AclArgs.builder()
 *             .aclName("tf_example")
 *             .resourceGroupId(default_.groups()[0].id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultAcl:
 *     type: alicloud:alb:Acl
 *     name: default
 *     properties:
 *       aclName: tf_example
 *       resourceGroupId: ${default.groups[0].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ALB Acl can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alb/acl:Acl example <id>
 * ```
 */
public class Acl internal constructor(
    override val javaResource: com.pulumi.alicloud.alb.Acl,
) : KotlinCustomResource(javaResource, AclMapper) {
    /**
     * The list of the ACL entries. You can add up to `20` entries in each call.  See `acl_entries` below for details.
     * **NOTE:** "Field 'acl_entries' has been deprecated from provider version 1.166.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_acl_entry_attachment'.",
     */
    @Deprecated(
        message = """
  Field 'acl_entries' has been deprecated from provider version 1.166.0 and it will be removed in
      the future version. Please use the new resource 'alicloud_alb_acl_entry_attachment'.
  """,
    )
    public val aclEntries: Output<List<AclAclEntry>>
        get() = javaResource.aclEntries().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The name of the ACL. The name must be `2` to `128` characters in length, and can contain letters, digits, hyphens (-) and underscores (_). It must start with a letter.
     */
    public val aclName: Output<String>
        get() = javaResource.aclName().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to precheck the API request.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The state of the ACL. Valid values:`Provisioning`, `Available` and `Configuring`. `Provisioning`: The ACL is being created. `Available`: The ACL is available. `Configuring`: The ACL is being configured.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object AclMapper : ResourceMapper<Acl> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.alb.Acl::class == javaResource::class

    override fun map(javaResource: Resource): Acl = Acl(javaResource as com.pulumi.alicloud.alb.Acl)
}

/**
 * @see [Acl].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Acl].
 */
public suspend fun acl(name: String, block: suspend AclResourceBuilder.() -> Unit): Acl {
    val builder = AclResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Acl].
 * @param name The _unique_ name of the resulting resource.
 */
public fun acl(name: String): Acl {
    val builder = AclResourceBuilder()
    builder.name(name)
    return builder.build()
}
