@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.alicloud.alb.AclArgs.builder
import com.pulumi.alicloud.alb.kotlin.inputs.AclAclEntryArgs
import com.pulumi.alicloud.alb.kotlin.inputs.AclAclEntryArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Application Load Balancer (ALB) Acl resource.
 * For information about ALB Acl and how to use it, see [What is Acl](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createacl).
 * > **NOTE:** Available since v1.133.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultAcl = new alicloud.alb.Acl("default", {
 *     aclName: "tf_example",
 *     resourceGroupId: _default.then(_default => _default.groups?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_acl = alicloud.alb.Acl("default",
 *     acl_name="tf_example",
 *     resource_group_id=default.groups[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultAcl = new AliCloud.Alb.Acl("default", new()
 *     {
 *         AclName = "tf_example",
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/alb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = alb.NewAcl(ctx, "default", &alb.AclArgs{
 * 			AclName:         pulumi.String("tf_example"),
 * 			ResourceGroupId: pulumi.String(_default.Groups[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.alb.Acl;
 * import com.pulumi.alicloud.alb.AclArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultAcl = new Acl("defaultAcl", AclArgs.builder()
 *             .aclName("tf_example")
 *             .resourceGroupId(default_.groups()[0].id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultAcl:
 *     type: alicloud:alb:Acl
 *     name: default
 *     properties:
 *       aclName: tf_example
 *       resourceGroupId: ${default.groups[0].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ALB Acl can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alb/acl:Acl example <id>
 * ```
 * @property aclEntries The list of the ACL entries. You can add up to `20` entries in each call.  See `acl_entries` below for details.
 * **NOTE:** "Field 'acl_entries' has been deprecated from provider version 1.166.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_acl_entry_attachment'.",
 * @property aclName The name of the ACL. The name must be `2` to `128` characters in length, and can contain letters, digits, hyphens (-) and underscores (_). It must start with a letter.
 * @property dryRun Specifies whether to precheck the API request.
 * @property resourceGroupId The ID of the resource group.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class AclArgs(
    @Deprecated(
        message = """
  Field 'acl_entries' has been deprecated from provider version 1.166.0 and it will be removed in
      the future version. Please use the new resource 'alicloud_alb_acl_entry_attachment'.
  """,
    )
    public val aclEntries: Output<List<AclAclEntryArgs>>? = null,
    public val aclName: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.AclArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.AclArgs = com.pulumi.alicloud.alb.AclArgs.builder()
        .aclEntries(
            aclEntries?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .aclName(aclName?.applyValue({ args0 -> args0 }))
        .dryRun(dryRun?.applyValue({ args0 -> args0 }))
        .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [AclArgs].
 */
@PulumiTagMarker
public class AclArgsBuilder internal constructor() {
    private var aclEntries: Output<List<AclAclEntryArgs>>? = null

    private var aclName: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The list of the ACL entries. You can add up to `20` entries in each call.  See `acl_entries` below for details.
     * **NOTE:** "Field 'acl_entries' has been deprecated from provider version 1.166.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_acl_entry_attachment'.",
     */
    @Deprecated(
        message = """
  Field 'acl_entries' has been deprecated from provider version 1.166.0 and it will be removed in
      the future version. Please use the new resource 'alicloud_alb_acl_entry_attachment'.
  """,
    )
    @JvmName("xduaonuoosniivji")
    public suspend fun aclEntries(`value`: Output<List<AclAclEntryArgs>>) {
        this.aclEntries = value
    }

    @JvmName("wgekvuifcguhnojb")
    public suspend fun aclEntries(vararg values: Output<AclAclEntryArgs>) {
        this.aclEntries = Output.all(values.asList())
    }

    /**
     * @param values The list of the ACL entries. You can add up to `20` entries in each call.  See `acl_entries` below for details.
     * **NOTE:** "Field 'acl_entries' has been deprecated from provider version 1.166.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_acl_entry_attachment'.",
     */
    @Deprecated(
        message = """
  Field 'acl_entries' has been deprecated from provider version 1.166.0 and it will be removed in
      the future version. Please use the new resource 'alicloud_alb_acl_entry_attachment'.
  """,
    )
    @JvmName("mtkxagqffdiynvks")
    public suspend fun aclEntries(values: List<Output<AclAclEntryArgs>>) {
        this.aclEntries = Output.all(values)
    }

    /**
     * @param value The name of the ACL. The name must be `2` to `128` characters in length, and can contain letters, digits, hyphens (-) and underscores (_). It must start with a letter.
     */
    @JvmName("dsxdtssfovgxtpkt")
    public suspend fun aclName(`value`: Output<String>) {
        this.aclName = value
    }

    /**
     * @param value Specifies whether to precheck the API request.
     */
    @JvmName("akggbmtvevshoraf")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("otlgafstjyavixaf")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("pdlrkwjdcdxanvmj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The list of the ACL entries. You can add up to `20` entries in each call.  See `acl_entries` below for details.
     * **NOTE:** "Field 'acl_entries' has been deprecated from provider version 1.166.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_acl_entry_attachment'.",
     */
    @Deprecated(
        message = """
  Field 'acl_entries' has been deprecated from provider version 1.166.0 and it will be removed in
      the future version. Please use the new resource 'alicloud_alb_acl_entry_attachment'.
  """,
    )
    @JvmName("xvhiunxvtisegskx")
    public suspend fun aclEntries(`value`: List<AclAclEntryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclEntries = mapped
    }

    /**
     * @param argument The list of the ACL entries. You can add up to `20` entries in each call.  See `acl_entries` below for details.
     * **NOTE:** "Field 'acl_entries' has been deprecated from provider version 1.166.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_acl_entry_attachment'.",
     */
    @Deprecated(
        message = """
  Field 'acl_entries' has been deprecated from provider version 1.166.0 and it will be removed in
      the future version. Please use the new resource 'alicloud_alb_acl_entry_attachment'.
  """,
    )
    @JvmName("ckdqsnrbaowiwaao")
    public suspend fun aclEntries(argument: List<suspend AclAclEntryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { AclAclEntryArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.aclEntries = mapped
    }

    /**
     * @param argument The list of the ACL entries. You can add up to `20` entries in each call.  See `acl_entries` below for details.
     * **NOTE:** "Field 'acl_entries' has been deprecated from provider version 1.166.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_acl_entry_attachment'.",
     */
    @Deprecated(
        message = """
  Field 'acl_entries' has been deprecated from provider version 1.166.0 and it will be removed in
      the future version. Please use the new resource 'alicloud_alb_acl_entry_attachment'.
  """,
    )
    @JvmName("djghrfgpnsjregye")
    public suspend fun aclEntries(vararg argument: suspend AclAclEntryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { AclAclEntryArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.aclEntries = mapped
    }

    /**
     * @param argument The list of the ACL entries. You can add up to `20` entries in each call.  See `acl_entries` below for details.
     * **NOTE:** "Field 'acl_entries' has been deprecated from provider version 1.166.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_acl_entry_attachment'.",
     */
    @Deprecated(
        message = """
  Field 'acl_entries' has been deprecated from provider version 1.166.0 and it will be removed in
      the future version. Please use the new resource 'alicloud_alb_acl_entry_attachment'.
  """,
    )
    @JvmName("xfjogsuxfdbmrspe")
    public suspend fun aclEntries(argument: suspend AclAclEntryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AclAclEntryArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.aclEntries = mapped
    }

    /**
     * @param values The list of the ACL entries. You can add up to `20` entries in each call.  See `acl_entries` below for details.
     * **NOTE:** "Field 'acl_entries' has been deprecated from provider version 1.166.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_acl_entry_attachment'.",
     */
    @Deprecated(
        message = """
  Field 'acl_entries' has been deprecated from provider version 1.166.0 and it will be removed in
      the future version. Please use the new resource 'alicloud_alb_acl_entry_attachment'.
  """,
    )
    @JvmName("ffcvvptteijvkynf")
    public suspend fun aclEntries(vararg values: AclAclEntryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aclEntries = mapped
    }

    /**
     * @param value The name of the ACL. The name must be `2` to `128` characters in length, and can contain letters, digits, hyphens (-) and underscores (_). It must start with a letter.
     */
    @JvmName("maukrwpkjtfftvih")
    public suspend fun aclName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclName = mapped
    }

    /**
     * @param value Specifies whether to precheck the API request.
     */
    @JvmName("lyphpraojnfnsefw")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("vwaglfvoattjiewy")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("nvhhaiixqlxbphck")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("brtqrfjqtpextvuv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AclArgs = AclArgs(
        aclEntries = aclEntries,
        aclName = aclName,
        dryRun = dryRun,
        resourceGroupId = resourceGroupId,
        tags = tags,
    )
}
