@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.alicloud.alb.AlbFunctions.getAclsPlain
import com.pulumi.alicloud.alb.AlbFunctions.getAscriptsPlain
import com.pulumi.alicloud.alb.AlbFunctions.getHealthCheckTemplatesPlain
import com.pulumi.alicloud.alb.AlbFunctions.getListenersPlain
import com.pulumi.alicloud.alb.AlbFunctions.getLoadBalancersPlain
import com.pulumi.alicloud.alb.AlbFunctions.getRulesPlain
import com.pulumi.alicloud.alb.AlbFunctions.getSecurityPoliciesPlain
import com.pulumi.alicloud.alb.AlbFunctions.getServerGroupsPlain
import com.pulumi.alicloud.alb.AlbFunctions.getSystemSecurityPoliciesPlain
import com.pulumi.alicloud.alb.AlbFunctions.getZonesPlain
import com.pulumi.alicloud.alb.kotlin.inputs.GetAclsPlainArgs
import com.pulumi.alicloud.alb.kotlin.inputs.GetAclsPlainArgsBuilder
import com.pulumi.alicloud.alb.kotlin.inputs.GetAscriptsPlainArgs
import com.pulumi.alicloud.alb.kotlin.inputs.GetAscriptsPlainArgsBuilder
import com.pulumi.alicloud.alb.kotlin.inputs.GetHealthCheckTemplatesPlainArgs
import com.pulumi.alicloud.alb.kotlin.inputs.GetHealthCheckTemplatesPlainArgsBuilder
import com.pulumi.alicloud.alb.kotlin.inputs.GetListenersPlainArgs
import com.pulumi.alicloud.alb.kotlin.inputs.GetListenersPlainArgsBuilder
import com.pulumi.alicloud.alb.kotlin.inputs.GetLoadBalancersPlainArgs
import com.pulumi.alicloud.alb.kotlin.inputs.GetLoadBalancersPlainArgsBuilder
import com.pulumi.alicloud.alb.kotlin.inputs.GetRulesPlainArgs
import com.pulumi.alicloud.alb.kotlin.inputs.GetRulesPlainArgsBuilder
import com.pulumi.alicloud.alb.kotlin.inputs.GetSecurityPoliciesPlainArgs
import com.pulumi.alicloud.alb.kotlin.inputs.GetSecurityPoliciesPlainArgsBuilder
import com.pulumi.alicloud.alb.kotlin.inputs.GetServerGroupsPlainArgs
import com.pulumi.alicloud.alb.kotlin.inputs.GetServerGroupsPlainArgsBuilder
import com.pulumi.alicloud.alb.kotlin.inputs.GetSystemSecurityPoliciesPlainArgs
import com.pulumi.alicloud.alb.kotlin.inputs.GetSystemSecurityPoliciesPlainArgsBuilder
import com.pulumi.alicloud.alb.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.alb.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.alb.kotlin.outputs.GetAclsResult
import com.pulumi.alicloud.alb.kotlin.outputs.GetAscriptsResult
import com.pulumi.alicloud.alb.kotlin.outputs.GetHealthCheckTemplatesResult
import com.pulumi.alicloud.alb.kotlin.outputs.GetListenersResult
import com.pulumi.alicloud.alb.kotlin.outputs.GetLoadBalancersResult
import com.pulumi.alicloud.alb.kotlin.outputs.GetRulesResult
import com.pulumi.alicloud.alb.kotlin.outputs.GetSecurityPoliciesResult
import com.pulumi.alicloud.alb.kotlin.outputs.GetServerGroupsResult
import com.pulumi.alicloud.alb.kotlin.outputs.GetSystemSecurityPoliciesResult
import com.pulumi.alicloud.alb.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.alb.kotlin.outputs.GetAclsResult.Companion.toKotlin as getAclsResultToKotlin
import com.pulumi.alicloud.alb.kotlin.outputs.GetAscriptsResult.Companion.toKotlin as getAscriptsResultToKotlin
import com.pulumi.alicloud.alb.kotlin.outputs.GetHealthCheckTemplatesResult.Companion.toKotlin as getHealthCheckTemplatesResultToKotlin
import com.pulumi.alicloud.alb.kotlin.outputs.GetListenersResult.Companion.toKotlin as getListenersResultToKotlin
import com.pulumi.alicloud.alb.kotlin.outputs.GetLoadBalancersResult.Companion.toKotlin as getLoadBalancersResultToKotlin
import com.pulumi.alicloud.alb.kotlin.outputs.GetRulesResult.Companion.toKotlin as getRulesResultToKotlin
import com.pulumi.alicloud.alb.kotlin.outputs.GetSecurityPoliciesResult.Companion.toKotlin as getSecurityPoliciesResultToKotlin
import com.pulumi.alicloud.alb.kotlin.outputs.GetServerGroupsResult.Companion.toKotlin as getServerGroupsResultToKotlin
import com.pulumi.alicloud.alb.kotlin.outputs.GetSystemSecurityPoliciesResult.Companion.toKotlin as getSystemSecurityPoliciesResultToKotlin
import com.pulumi.alicloud.alb.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object AlbFunctions {
    /**
     * This data source provides the Application Load Balancer (ALB) Acls of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.133.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.alb.getAcls({});
     * export const albAclId1 = ids.then(ids => ids.acls?.[0]?.id);
     * const nameRegex = alicloud.alb.getAcls({
     *     nameRegex: "^my-Acl",
     * });
     * export const albAclId2 = nameRegex.then(nameRegex => nameRegex.acls?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.alb.get_acls()
     * pulumi.export("albAclId1", ids.acls[0].id)
     * name_regex = alicloud.alb.get_acls(name_regex="^my-Acl")
     * pulumi.export("albAclId2", name_regex.acls[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Alb.GetAcls.Invoke();
     *     var nameRegex = AliCloud.Alb.GetAcls.Invoke(new()
     *     {
     *         NameRegex = "^my-Acl",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["albAclId1"] = ids&#46;Apply(getAclsResult => getAclsResult&#46;Acls[0]?.Id),
     *         ["albAclId2"] = nameRegex&#46;Apply(getAclsResult => getAclsResult&#46;Acls[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/alb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := alb.GetAcls(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("albAclId1", ids.Acls[0].Id)
     * 		nameRegex, err := alb.GetAcls(ctx, &alb.GetAclsArgs{
     * 			NameRegex: pulumi.StringRef("^my-Acl"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("albAclId2", nameRegex.Acls[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.alb.AlbFunctions;
     * import com.pulumi.alicloud.alb.inputs.GetAclsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = AlbFunctions.getAcls();
     *         ctx.export("albAclId1", ids.applyValue(getAclsResult -> getAclsResult.acls()[0].id()));
     *         final var nameRegex = AlbFunctions.getAcls(GetAclsArgs.builder()
     *             .nameRegex("^my-Acl")
     *             .build());
     *         ctx.export("albAclId2", nameRegex.applyValue(getAclsResult -> getAclsResult.acls()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:alb:getAcls
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:alb:getAcls
     *       Arguments:
     *         nameRegex: ^my-Acl
     * outputs:
     *   albAclId1: ${ids.acls[0].id}
     *   albAclId2: ${nameRegex.acls[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAcls.
     * @return A collection of values returned by getAcls.
     */
    public suspend fun getAcls(argument: GetAclsPlainArgs): GetAclsResult =
        getAclsResultToKotlin(getAclsPlain(argument.toJava()).await())

    /**
     * @see [getAcls].
     * @param aclIds The acl ids.
     * @param aclName The ACL Name.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Acl IDs.
     * @param nameRegex A regex string to filter results by Acl name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId Resource Group to Which the Number.
     * @param status The state of the ACL. Valid values:`Provisioning`,`Available`and`Configuring`.  `Provisioning`: The ACL is being created. `Available`: The ACL is available. `Configuring`: The ACL is being configured.
     * @return A collection of values returned by getAcls.
     */
    public suspend fun getAcls(
        aclIds: List<String>? = null,
        aclName: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        status: String? = null,
    ): GetAclsResult {
        val argument = GetAclsPlainArgs(
            aclIds = aclIds,
            aclName = aclName,
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            status = status,
        )
        return getAclsResultToKotlin(getAclsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAcls].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;alb&#46;kotlin&#46;inputs&#46;GetAclsPlainArgs].
     * @return A collection of values returned by getAcls.
     */
    public suspend fun getAcls(argument: suspend GetAclsPlainArgsBuilder.() -> Unit): GetAclsResult {
        val builder = GetAclsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAclsResultToKotlin(getAclsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Alb Ascript available to the user.
     * > **NOTE:** Available in 1.195.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.alb.getAscripts({
     *     ids: [defaultAlicloudAlbAscript&#46;id],
     *     nameRegex: defaultAlicloudAlbAscript.name,
     *     ascriptName: "test",
     *     listenerId: listenerId,
     * });
     * export const alicloudAlbAscriptExampleId = _default.then(_default => _default.ascripts?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.alb.get_ascripts(ids=[default_alicloud_alb_ascript["id"]],
     *     name_regex=default_alicloud_alb_ascript["name"],
     *     ascript_name="test",
     *     listener_id=listener_id)
     * pulumi.export("alicloudAlbAscriptExampleId", default.ascripts[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Alb.GetAscripts.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultAlicloudAlbAscript.Id,
     *         },
     *         NameRegex = defaultAlicloudAlbAscript.Name,
     *         AscriptName = "test",
     *         ListenerId = listenerId,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudAlbAscriptExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getAscriptsResult => getAscriptsResult&#46;Ascripts[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/alb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := alb.GetAscripts(ctx, &alb.GetAscriptsArgs{
     * Ids: interface{}{
     * defaultAlicloudAlbAscript.Id,
     * },
     * NameRegex: pulumi.StringRef(defaultAlicloudAlbAscript.Name),
     * AscriptName: pulumi.StringRef("test"),
     * ListenerId: pulumi.StringRef(listenerId),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("alicloudAlbAscriptExampleId", _default.Ascripts[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.alb.AlbFunctions;
     * import com.pulumi.alicloud.alb.inputs.GetAscriptsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = AlbFunctions.getAscripts(GetAscriptsArgs.builder()
     *             .ids(defaultAlicloudAlbAscript.id())
     *             .nameRegex(defaultAlicloudAlbAscript.name())
     *             .ascriptName("test")
     *             .listenerId(listenerId)
     *             .build());
     *         ctx.export("alicloudAlbAscriptExampleId", default_.ascripts()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:alb:getAscripts
     *       Arguments:
     *         ids:
     *           - ${defaultAlicloudAlbAscript.id}
     *         nameRegex: ${defaultAlicloudAlbAscript.name}
     *         ascriptName: test
     *         listenerId: ${listenerId}
     * outputs:
     *   alicloudAlbAscriptExampleId: ${default.ascripts[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAscripts.
     * @return A collection of values returned by getAscripts.
     */
    public suspend fun getAscripts(argument: GetAscriptsPlainArgs): GetAscriptsResult =
        getAscriptsResultToKotlin(getAscriptsPlain(argument.toJava()).await())

    /**
     * @see [getAscripts].
     * @param ascriptName Script name.
     * @param enableDetails
     * @param ids A list of AScript IDs.
     * @param listenerId Listener ID of script attribution
     * @param nameRegex A regex string to filter results by Group Metric Rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getAscripts.
     */
    public suspend fun getAscripts(
        ascriptName: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        listenerId: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetAscriptsResult {
        val argument = GetAscriptsPlainArgs(
            ascriptName = ascriptName,
            enableDetails = enableDetails,
            ids = ids,
            listenerId = listenerId,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getAscriptsResultToKotlin(getAscriptsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAscripts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;alb&#46;kotlin&#46;inputs&#46;GetAscriptsPlainArgs].
     * @return A collection of values returned by getAscripts.
     */
    public suspend fun getAscripts(argument: suspend GetAscriptsPlainArgsBuilder.() -> Unit): GetAscriptsResult {
        val builder = GetAscriptsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAscriptsResultToKotlin(getAscriptsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Alb Health Check Templates of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.134.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.alb.getHealthCheckTemplates({
     *     ids: ["example_id"],
     * });
     * export const albHealthCheckTemplateId1 = ids.then(ids => ids.templates?.[0]?.id);
     * const nameRegex = alicloud.alb.getHealthCheckTemplates({
     *     nameRegex: "^my-HealthCheckTemplate",
     * });
     * export const albHealthCheckTemplateId2 = nameRegex.then(nameRegex => nameRegex.templates?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.alb.get_health_check_templates(ids=["example_id"])
     * pulumi.export("albHealthCheckTemplateId1", ids.templates[0].id)
     * name_regex = alicloud.alb.get_health_check_templates(name_regex="^my-HealthCheckTemplate")
     * pulumi.export("albHealthCheckTemplateId2", name_regex.templates[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Alb.GetHealthCheckTemplates.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Alb.GetHealthCheckTemplates.Invoke(new()
     *     {
     *         NameRegex = "^my-HealthCheckTemplate",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["albHealthCheckTemplateId1"] = ids&#46;Apply(getHealthCheckTemplatesResult => getHealthCheckTemplatesResult&#46;Templates[0]?.Id),
     *         ["albHealthCheckTemplateId2"] = nameRegex&#46;Apply(getHealthCheckTemplatesResult => getHealthCheckTemplatesResult&#46;Templates[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/alb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := alb.GetHealthCheckTemplates(ctx, &alb.GetHealthCheckTemplatesArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("albHealthCheckTemplateId1", ids.Templates[0].Id)
     * 		nameRegex, err := alb.GetHealthCheckTemplates(ctx, &alb.GetHealthCheckTemplatesArgs{
     * 			NameRegex: pulumi.StringRef("^my-HealthCheckTemplate"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("albHealthCheckTemplateId2", nameRegex.Templates[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.alb.AlbFunctions;
     * import com.pulumi.alicloud.alb.inputs.GetHealthCheckTemplatesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = AlbFunctions.getHealthCheckTemplates(GetHealthCheckTemplatesArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("albHealthCheckTemplateId1", ids.applyValue(getHealthCheckTemplatesResult -> getHealthCheckTemplatesResult.templates()[0].id()));
     *         final var nameRegex = AlbFunctions.getHealthCheckTemplates(GetHealthCheckTemplatesArgs.builder()
     *             .nameRegex("^my-HealthCheckTemplate")
     *             .build());
     *         ctx.export("albHealthCheckTemplateId2", nameRegex.applyValue(getHealthCheckTemplatesResult -> getHealthCheckTemplatesResult.templates()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:alb:getHealthCheckTemplates
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:alb:getHealthCheckTemplates
     *       Arguments:
     *         nameRegex: ^my-HealthCheckTemplate
     * outputs:
     *   albHealthCheckTemplateId1: ${ids.templates[0].id}
     *   albHealthCheckTemplateId2: ${nameRegex.templates[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHealthCheckTemplates.
     * @return A collection of values returned by getHealthCheckTemplates.
     */
    public suspend fun getHealthCheckTemplates(argument: GetHealthCheckTemplatesPlainArgs): GetHealthCheckTemplatesResult =
        getHealthCheckTemplatesResultToKotlin(getHealthCheckTemplatesPlain(argument.toJava()).await())

    /**
     * @see [getHealthCheckTemplates].
     * @param healthCheckTemplateIds The health check template ids.
     * @param healthCheckTemplateName The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
     * @param ids A list of Health Check Template IDs.
     * @param nameRegex A regex string to filter results by Health Check Template name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getHealthCheckTemplates.
     */
    public suspend fun getHealthCheckTemplates(
        healthCheckTemplateIds: List<String>? = null,
        healthCheckTemplateName: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetHealthCheckTemplatesResult {
        val argument = GetHealthCheckTemplatesPlainArgs(
            healthCheckTemplateIds = healthCheckTemplateIds,
            healthCheckTemplateName = healthCheckTemplateName,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getHealthCheckTemplatesResultToKotlin(getHealthCheckTemplatesPlain(argument.toJava()).await())
    }

    /**
     * @see [getHealthCheckTemplates].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;alb&#46;kotlin&#46;inputs&#46;GetHealthCheckTemplatesPlainArgs].
     * @return A collection of values returned by getHealthCheckTemplates.
     */
    public suspend fun getHealthCheckTemplates(argument: suspend GetHealthCheckTemplatesPlainArgsBuilder.() -> Unit): GetHealthCheckTemplatesResult {
        val builder = GetHealthCheckTemplatesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHealthCheckTemplatesResultToKotlin(getHealthCheckTemplatesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Application Load Balancer (ALB) Listeners of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.133.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.alb.getListeners({
     *     ids: ["example_id"],
     * });
     * export const albListenerId1 = ids.then(ids => ids.listeners?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.alb.get_listeners(ids=["example_id"])
     * pulumi.export("albListenerId1", ids.listeners[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Alb.GetListeners.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["albListenerId1"] = ids&#46;Apply(getListenersResult => getListenersResult&#46;Listeners[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/alb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := alb.GetListeners(ctx, &alb.GetListenersArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("albListenerId1", ids.Listeners[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.alb.AlbFunctions;
     * import com.pulumi.alicloud.alb.inputs.GetListenersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = AlbFunctions.getListeners(GetListenersArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("albListenerId1", ids.applyValue(getListenersResult -> getListenersResult.listeners()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:alb:getListeners
     *       Arguments:
     *         ids:
     *           - example_id
     * outputs:
     *   albListenerId1: ${ids.listeners[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getListeners.
     * @return A collection of values returned by getListeners.
     */
    public suspend fun getListeners(argument: GetListenersPlainArgs): GetListenersResult =
        getListenersResultToKotlin(getListenersPlain(argument.toJava()).await())

    /**
     * @see [getListeners].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Listener IDs.
     * @param listenerIds The listener ids.
     * @param listenerProtocol Snooping Protocols. Valid Values: `HTTP`, `HTTPS` Or `QUIC`.
     * @param loadBalancerIds The load balancer ids.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The state of the listener. Valid Values: `Running` Or `Stopped`. `Running`: The listener is running. `Stopped`: The listener is stopped.
     * @return A collection of values returned by getListeners.
     */
    public suspend fun getListeners(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        listenerIds: List<String>? = null,
        listenerProtocol: String? = null,
        loadBalancerIds: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetListenersResult {
        val argument = GetListenersPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            listenerIds = listenerIds,
            listenerProtocol = listenerProtocol,
            loadBalancerIds = loadBalancerIds,
            outputFile = outputFile,
            status = status,
        )
        return getListenersResultToKotlin(getListenersPlain(argument.toJava()).await())
    }

    /**
     * @see [getListeners].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;alb&#46;kotlin&#46;inputs&#46;GetListenersPlainArgs].
     * @return A collection of values returned by getListeners.
     */
    public suspend fun getListeners(argument: suspend GetListenersPlainArgsBuilder.() -> Unit): GetListenersResult {
        val builder = GetListenersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getListenersResultToKotlin(getListenersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Alb Load Balancers of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.132.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.alb.getLoadBalancers({});
     * export const albLoadBalancerId1 = ids.then(ids => ids.balancers?.[0]?.id);
     * const nameRegex = alicloud.alb.getLoadBalancers({
     *     nameRegex: "^my-LoadBalancer",
     * });
     * export const albLoadBalancerId2 = nameRegex.then(nameRegex => nameRegex.balancers?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.alb.get_load_balancers()
     * pulumi.export("albLoadBalancerId1", ids.balancers[0].id)
     * name_regex = alicloud.alb.get_load_balancers(name_regex="^my-LoadBalancer")
     * pulumi.export("albLoadBalancerId2", name_regex.balancers[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Alb.GetLoadBalancers.Invoke();
     *     var nameRegex = AliCloud.Alb.GetLoadBalancers.Invoke(new()
     *     {
     *         NameRegex = "^my-LoadBalancer",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["albLoadBalancerId1"] = ids&#46;Apply(getLoadBalancersResult => getLoadBalancersResult&#46;Balancers[0]?.Id),
     *         ["albLoadBalancerId2"] = nameRegex&#46;Apply(getLoadBalancersResult => getLoadBalancersResult&#46;Balancers[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/alb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := alb.GetLoadBalancers(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("albLoadBalancerId1", ids.Balancers[0].Id)
     * 		nameRegex, err := alb.GetLoadBalancers(ctx, &alb.GetLoadBalancersArgs{
     * 			NameRegex: pulumi.StringRef("^my-LoadBalancer"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("albLoadBalancerId2", nameRegex.Balancers[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.alb.AlbFunctions;
     * import com.pulumi.alicloud.alb.inputs.GetLoadBalancersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = AlbFunctions.getLoadBalancers();
     *         ctx.export("albLoadBalancerId1", ids.applyValue(getLoadBalancersResult -> getLoadBalancersResult.balancers()[0].id()));
     *         final var nameRegex = AlbFunctions.getLoadBalancers(GetLoadBalancersArgs.builder()
     *             .nameRegex("^my-LoadBalancer")
     *             .build());
     *         ctx.export("albLoadBalancerId2", nameRegex.applyValue(getLoadBalancersResult -> getLoadBalancersResult.balancers()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:alb:getLoadBalancers
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:alb:getLoadBalancers
     *       Arguments:
     *         nameRegex: ^my-LoadBalancer
     * outputs:
     *   albLoadBalancerId1: ${ids.balancers[0].id}
     *   albLoadBalancerId2: ${nameRegex.balancers[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLoadBalancers.
     * @return A collection of values returned by getLoadBalancers.
     */
    public suspend fun getLoadBalancers(argument: GetLoadBalancersPlainArgs): GetLoadBalancersResult =
        getLoadBalancersResultToKotlin(getLoadBalancersPlain(argument.toJava()).await())

    /**
     * @see [getLoadBalancers].
     * @param addressType The type of IP address that the ALB instance uses to provide services. Valid
     * values: `Intranet`, `Internet`.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Load Balancer IDs.
     * @param loadBalancerBusinessStatus Load Balancing of the Service Status. Valid Values: `Abnormal`and `Normal`.
     * @param loadBalancerBussinessStatus Field 'load_balancer_bussiness_status' has been deprecated from provider version 1.142.0. Use 'load_balancer_business_status' replaces it.
     * @param loadBalancerIds The load balancer ids.
     * @param loadBalancerName The name of the resource.
     * @param nameRegex A regex string to filter results by Load Balancer name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The ID of the resource group.
     * @param status The load balancer status. Valid values: `Active`, `Configuring`, `CreateFailed`, `Inactive` and `Provisioning`.
     * @param tags
     * @param vpcId The ID of the virtual private cloud (VPC) where the ALB instance is deployed.
     * @param vpcIds The vpc ids.
     * @param zoneId The zone ID of the resource.
     * @return A collection of values returned by getLoadBalancers.
     */
    public suspend fun getLoadBalancers(
        addressType: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        loadBalancerBusinessStatus: String? = null,
        loadBalancerBussinessStatus: String? = null,
        loadBalancerIds: List<String>? = null,
        loadBalancerName: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
        vpcIds: List<String>? = null,
        zoneId: String? = null,
    ): GetLoadBalancersResult {
        val argument = GetLoadBalancersPlainArgs(
            addressType = addressType,
            enableDetails = enableDetails,
            ids = ids,
            loadBalancerBusinessStatus = loadBalancerBusinessStatus,
            loadBalancerBussinessStatus = loadBalancerBussinessStatus,
            loadBalancerIds = loadBalancerIds,
            loadBalancerName = loadBalancerName,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            status = status,
            tags = tags,
            vpcId = vpcId,
            vpcIds = vpcIds,
            zoneId = zoneId,
        )
        return getLoadBalancersResultToKotlin(getLoadBalancersPlain(argument.toJava()).await())
    }

    /**
     * @see [getLoadBalancers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;alb&#46;kotlin&#46;inputs&#46;GetLoadBalancersPlainArgs].
     * @return A collection of values returned by getLoadBalancers.
     */
    public suspend fun getLoadBalancers(argument: suspend GetLoadBalancersPlainArgsBuilder.() -> Unit): GetLoadBalancersResult {
        val builder = GetLoadBalancersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLoadBalancersResultToKotlin(getLoadBalancersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Alb Rules of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.133.0.
     * @param argument A collection of arguments for invoking getRules.
     * @return A collection of values returned by getRules.
     */
    public suspend fun getRules(argument: GetRulesPlainArgs): GetRulesResult =
        getRulesResultToKotlin(getRulesPlain(argument.toJava()).await())

    /**
     * @see [getRules].
     * @param ids A list of Rule IDs.
     * @param listenerIds The listener ids.
     * @param loadBalancerIds The load balancer ids.
     * @param nameRegex A regex string to filter results by Rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param ruleIds The rule ids.
     * @param status The status of the forwarding rule. Valid values: `Provisioning`, `Configuring`, `Available`.
     * @return A collection of values returned by getRules.
     */
    public suspend fun getRules(
        ids: List<String>? = null,
        listenerIds: List<String>? = null,
        loadBalancerIds: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        ruleIds: List<String>? = null,
        status: String? = null,
    ): GetRulesResult {
        val argument = GetRulesPlainArgs(
            ids = ids,
            listenerIds = listenerIds,
            loadBalancerIds = loadBalancerIds,
            nameRegex = nameRegex,
            outputFile = outputFile,
            ruleIds = ruleIds,
            status = status,
        )
        return getRulesResultToKotlin(getRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;alb&#46;kotlin&#46;inputs&#46;GetRulesPlainArgs].
     * @return A collection of values returned by getRules.
     */
    public suspend fun getRules(argument: suspend GetRulesPlainArgsBuilder.() -> Unit): GetRulesResult {
        val builder = GetRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRulesResultToKotlin(getRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Alb Security Policies of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.130.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.alb.getSecurityPolicies({});
     * export const albSecurityPolicyId1 = ids.then(ids => ids.policies?.[0]?.id);
     * const nameRegex = alicloud.alb.getSecurityPolicies({
     *     nameRegex: "^my-SecurityPolicy",
     * });
     * export const albSecurityPolicyId2 = nameRegex.then(nameRegex => nameRegex.policies?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.alb.get_security_policies()
     * pulumi.export("albSecurityPolicyId1", ids.policies[0].id)
     * name_regex = alicloud.alb.get_security_policies(name_regex="^my-SecurityPolicy")
     * pulumi.export("albSecurityPolicyId2", name_regex.policies[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Alb.GetSecurityPolicies.Invoke();
     *     var nameRegex = AliCloud.Alb.GetSecurityPolicies.Invoke(new()
     *     {
     *         NameRegex = "^my-SecurityPolicy",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["albSecurityPolicyId1"] = ids&#46;Apply(getSecurityPoliciesResult => getSecurityPoliciesResult&#46;Policies[0]?.Id),
     *         ["albSecurityPolicyId2"] = nameRegex&#46;Apply(getSecurityPoliciesResult => getSecurityPoliciesResult&#46;Policies[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/alb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := alb.GetSecurityPolicies(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("albSecurityPolicyId1", ids.Policies[0].Id)
     * 		nameRegex, err := alb.GetSecurityPolicies(ctx, &alb.GetSecurityPoliciesArgs{
     * 			NameRegex: pulumi.StringRef("^my-SecurityPolicy"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("albSecurityPolicyId2", nameRegex.Policies[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.alb.AlbFunctions;
     * import com.pulumi.alicloud.alb.inputs.GetSecurityPoliciesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = AlbFunctions.getSecurityPolicies();
     *         ctx.export("albSecurityPolicyId1", ids.applyValue(getSecurityPoliciesResult -> getSecurityPoliciesResult.policies()[0].id()));
     *         final var nameRegex = AlbFunctions.getSecurityPolicies(GetSecurityPoliciesArgs.builder()
     *             .nameRegex("^my-SecurityPolicy")
     *             .build());
     *         ctx.export("albSecurityPolicyId2", nameRegex.applyValue(getSecurityPoliciesResult -> getSecurityPoliciesResult.policies()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:alb:getSecurityPolicies
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:alb:getSecurityPolicies
     *       Arguments:
     *         nameRegex: ^my-SecurityPolicy
     * outputs:
     *   albSecurityPolicyId1: ${ids.policies[0].id}
     *   albSecurityPolicyId2: ${nameRegex.policies[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSecurityPolicies.
     * @return A collection of values returned by getSecurityPolicies.
     */
    public suspend fun getSecurityPolicies(argument: GetSecurityPoliciesPlainArgs): GetSecurityPoliciesResult =
        getSecurityPoliciesResultToKotlin(getSecurityPoliciesPlain(argument.toJava()).await())

    /**
     * @see [getSecurityPolicies].
     * @param ids A list of Security Policy IDs.
     * @param nameRegex A regex string to filter results by Security Policy name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The ID of the resource group.
     * @param securityPolicyIds The security policy ids.
     * @param securityPolicyName The name of the resource.
     * @param status The status of the resource. Valid values : `Available`, `Configuring`.
     * @param tags
     * @return A collection of values returned by getSecurityPolicies.
     */
    public suspend fun getSecurityPolicies(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        securityPolicyIds: List<String>? = null,
        securityPolicyName: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
    ): GetSecurityPoliciesResult {
        val argument = GetSecurityPoliciesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            securityPolicyIds = securityPolicyIds,
            securityPolicyName = securityPolicyName,
            status = status,
            tags = tags,
        )
        return getSecurityPoliciesResultToKotlin(getSecurityPoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecurityPolicies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;alb&#46;kotlin&#46;inputs&#46;GetSecurityPoliciesPlainArgs].
     * @return A collection of values returned by getSecurityPolicies.
     */
    public suspend fun getSecurityPolicies(argument: suspend GetSecurityPoliciesPlainArgsBuilder.() -> Unit): GetSecurityPoliciesResult {
        val builder = GetSecurityPoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecurityPoliciesResultToKotlin(getSecurityPoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Alb Server Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.131.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.alb.getServerGroups({});
     * export const albServerGroupId1 = ids.then(ids => ids.groups?.[0]?.id);
     * const nameRegex = alicloud.alb.getServerGroups({
     *     nameRegex: "^my-ServerGroup",
     * });
     * export const albServerGroupId2 = nameRegex.then(nameRegex => nameRegex.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.alb.get_server_groups()
     * pulumi.export("albServerGroupId1", ids.groups[0].id)
     * name_regex = alicloud.alb.get_server_groups(name_regex="^my-ServerGroup")
     * pulumi.export("albServerGroupId2", name_regex.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Alb.GetServerGroups.Invoke();
     *     var nameRegex = AliCloud.Alb.GetServerGroups.Invoke(new()
     *     {
     *         NameRegex = "^my-ServerGroup",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["albServerGroupId1"] = ids&#46;Apply(getServerGroupsResult => getServerGroupsResult&#46;Groups[0]?.Id),
     *         ["albServerGroupId2"] = nameRegex&#46;Apply(getServerGroupsResult => getServerGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/alb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := alb.GetServerGroups(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("albServerGroupId1", ids.Groups[0].Id)
     * 		nameRegex, err := alb.GetServerGroups(ctx, &alb.GetServerGroupsArgs{
     * 			NameRegex: pulumi.StringRef("^my-ServerGroup"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("albServerGroupId2", nameRegex.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.alb.AlbFunctions;
     * import com.pulumi.alicloud.alb.inputs.GetServerGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = AlbFunctions.getServerGroups();
     *         ctx.export("albServerGroupId1", ids.applyValue(getServerGroupsResult -> getServerGroupsResult.groups()[0].id()));
     *         final var nameRegex = AlbFunctions.getServerGroups(GetServerGroupsArgs.builder()
     *             .nameRegex("^my-ServerGroup")
     *             .build());
     *         ctx.export("albServerGroupId2", nameRegex.applyValue(getServerGroupsResult -> getServerGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:alb:getServerGroups
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:alb:getServerGroups
     *       Arguments:
     *         nameRegex: ^my-ServerGroup
     * outputs:
     *   albServerGroupId1: ${ids.groups[0].id}
     *   albServerGroupId2: ${nameRegex.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServerGroups.
     * @return A collection of values returned by getServerGroups.
     */
    public suspend fun getServerGroups(argument: GetServerGroupsPlainArgs): GetServerGroupsResult =
        getServerGroupsResultToKotlin(getServerGroupsPlain(argument.toJava()).await())

    /**
     * @see [getServerGroups].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Server Group IDs.
     * @param nameRegex A regex string to filter results by Server Group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The ID of the resource group.
     * @param serverGroupIds The server group ids.
     * @param serverGroupName The name of the resource.
     * @param status The status of the resource.
     * @param tags A map of tags assigned to the group.
     * @param vpcId The ID of the VPC that you want to access.
     * @return A collection of values returned by getServerGroups.
     */
    public suspend fun getServerGroups(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        serverGroupIds: List<String>? = null,
        serverGroupName: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetServerGroupsResult {
        val argument = GetServerGroupsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            serverGroupIds = serverGroupIds,
            serverGroupName = serverGroupName,
            status = status,
            tags = tags,
            vpcId = vpcId,
        )
        return getServerGroupsResultToKotlin(getServerGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;alb&#46;kotlin&#46;inputs&#46;GetServerGroupsPlainArgs].
     * @return A collection of values returned by getServerGroups.
     */
    public suspend fun getServerGroups(argument: suspend GetServerGroupsPlainArgsBuilder.() -> Unit): GetServerGroupsResult {
        val builder = GetServerGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerGroupsResultToKotlin(getServerGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the ALB System Security Policies of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.183.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const defaults = alicloud.alb.getSystemSecurityPolicies({
     *     ids: ["tls_cipher_policy_1_0"],
     * });
     * export const albSystemSecurityPolicyId1 = defaults.then(defaults => defaults.policies?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * defaults = alicloud.alb.get_system_security_policies(ids=["tls_cipher_policy_1_0"])
     * pulumi.export("albSystemSecurityPolicyId1", defaults.policies[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var defaults = AliCloud.Alb.GetSystemSecurityPolicies.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "tls_cipher_policy_1_0",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["albSystemSecurityPolicyId1"] = defaults&#46;Apply(getSystemSecurityPoliciesResult => getSystemSecurityPoliciesResult&#46;Policies[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/alb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		defaults, err := alb.GetSystemSecurityPolicies(ctx, &alb.GetSystemSecurityPoliciesArgs{
     * 			Ids: []string{
     * 				"tls_cipher_policy_1_0",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("albSystemSecurityPolicyId1", defaults.Policies[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.alb.AlbFunctions;
     * import com.pulumi.alicloud.alb.inputs.GetSystemSecurityPoliciesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var defaults = AlbFunctions.getSystemSecurityPolicies(GetSystemSecurityPoliciesArgs.builder()
     *             .ids("tls_cipher_policy_1_0")
     *             .build());
     *         ctx.export("albSystemSecurityPolicyId1", defaults.applyValue(getSystemSecurityPoliciesResult -> getSystemSecurityPoliciesResult.policies()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   defaults:
     *     fn::invoke:
     *       Function: alicloud:alb:getSystemSecurityPolicies
     *       Arguments:
     *         ids:
     *           - tls_cipher_policy_1_0
     * outputs:
     *   albSystemSecurityPolicyId1: ${defaults.policies[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSystemSecurityPolicies.
     * @return A collection of values returned by getSystemSecurityPolicies.
     */
    public suspend fun getSystemSecurityPolicies(argument: GetSystemSecurityPoliciesPlainArgs): GetSystemSecurityPoliciesResult =
        getSystemSecurityPoliciesResultToKotlin(getSystemSecurityPoliciesPlain(argument.toJava()).await())

    /**
     * @see [getSystemSecurityPolicies].
     * @param ids A list of System Security Policy IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param tags
     * @return A collection of values returned by getSystemSecurityPolicies.
     */
    public suspend fun getSystemSecurityPolicies(
        ids: List<String>? = null,
        outputFile: String? = null,
        tags: Map<String, String>? = null,
    ): GetSystemSecurityPoliciesResult {
        val argument = GetSystemSecurityPoliciesPlainArgs(
            ids = ids,
            outputFile = outputFile,
            tags = tags,
        )
        return getSystemSecurityPoliciesResultToKotlin(getSystemSecurityPoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [getSystemSecurityPolicies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;alb&#46;kotlin&#46;inputs&#46;GetSystemSecurityPoliciesPlainArgs].
     * @return A collection of values returned by getSystemSecurityPolicies.
     */
    public suspend fun getSystemSecurityPolicies(argument: suspend GetSystemSecurityPoliciesPlainArgsBuilder.() -> Unit): GetSystemSecurityPoliciesResult {
        val builder = GetSystemSecurityPoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSystemSecurityPoliciesResultToKotlin(getSystemSecurityPoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the available zones with the Application Load Balancer (ALB) Instance of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.132.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.alb.getZones({});
     * export const firstAlbZonesId = example.then(example => example.zones?.[0]?.zoneId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.alb.get_zones()
     * pulumi.export("firstAlbZonesId", example.zones[0].zone_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Alb.GetZones.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstAlbZonesId"] = example&#46;Apply(getZonesResult => getZonesResult&#46;Zones[0]?.ZoneId),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/alb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := alb.GetZones(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstAlbZonesId", example.Zones[0].ZoneId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.alb.AlbFunctions;
     * import com.pulumi.alicloud.alb.inputs.GetZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AlbFunctions.getZones();
     *         ctx.export("firstAlbZonesId", example.applyValue(getZonesResult -> getZonesResult.zones()[0].zoneId()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:alb:getZones
     *       Arguments: {}
     * outputs:
     *   firstAlbZonesId: ${example.zones[0].zoneId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(outputFile: String? = null): GetZonesResult {
        val argument = GetZonesPlainArgs(
            outputFile = outputFile,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;alb&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
