@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [HealthCheckTemplate].
 */
@PulumiTagMarker
public class HealthCheckTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HealthCheckTemplateArgs = HealthCheckTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HealthCheckTemplateArgsBuilder.() -> Unit) {
        val builder = HealthCheckTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HealthCheckTemplate {
        val builtJavaResource = com.pulumi.alicloud.alb.HealthCheckTemplate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return HealthCheckTemplate(builtJavaResource)
    }
}

/**
 * Provides a Application Load Balancer (ALB) Health Check Template resource.
 * For information about Application Load Balancer (ALB) Health Check Template and how to use it, see [What is Health Check Template](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createhealthchecktemplate).
 * > **NOTE:** Available since v1.134.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.alb.HealthCheckTemplate("example", {healthCheckTemplateName: "example_name"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.alb.HealthCheckTemplate("example", health_check_template_name="example_name")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Alb.HealthCheckTemplate("example", new()
 *     {
 *         HealthCheckTemplateName = "example_name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/alb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := alb.NewHealthCheckTemplate(ctx, "example", &alb.HealthCheckTemplateArgs{
 * 			HealthCheckTemplateName: pulumi.String("example_name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.alb.HealthCheckTemplate;
 * import com.pulumi.alicloud.alb.HealthCheckTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HealthCheckTemplate("example", HealthCheckTemplateArgs.builder()
 *             .healthCheckTemplateName("example_name")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:alb:HealthCheckTemplate
 *     properties:
 *       healthCheckTemplateName: example_name
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Application Load Balancer (ALB) Health Check Template can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alb/healthCheckTemplate:HealthCheckTemplate example <id>
 * ```
 */
public class HealthCheckTemplate internal constructor(
    override val javaResource: com.pulumi.alicloud.alb.HealthCheckTemplate,
) : KotlinCustomResource(javaResource, HealthCheckTemplateMapper) {
    /**
     * Whether to precheck the API request.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The HTTP status code that indicates a successful health check. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
     */
    public val healthCheckCodes: Output<List<String>>
        get() = javaResource.healthCheckCodes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The number of the port that is used for health checks.  Valid values: `0` to `65535`.  Default value: `0`. This default value indicates that the backend server is used for health checks.
     */
    public val healthCheckConnectPort: Output<Int>
        get() = javaResource.healthCheckConnectPort().applyValue({ args0 -> args0 })

    /**
     * The domain name that is used for health checks. Default value:  `$SERVER_IP`. The domain name must be 1 to 80 characters in length.  **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
     */
    public val healthCheckHost: Output<String>
        get() = javaResource.healthCheckHost().applyValue({ args0 -> args0 })

    /**
     * The version of the HTTP protocol.  Valid values: `HTTP1.0` and `HTTP1.1`.  Default value: `HTTP1.1`. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
     */
    public val healthCheckHttpVersion: Output<String>
        get() = javaResource.healthCheckHttpVersion().applyValue({ args0 -> args0 })

    /**
     * The time interval between two consecutive health checks.  Valid values: `1` to `50`. Unit: seconds.  Default value: `2`.
     */
    public val healthCheckInterval: Output<Int>
        get() = javaResource.healthCheckInterval().applyValue({ args0 -> args0 })

    /**
     * The health check method.  Valid values: GET and HEAD.  Default value: HEAD. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
     */
    public val healthCheckMethod: Output<String>
        get() = javaResource.healthCheckMethod().applyValue({ args0 -> args0 })

    /**
     * The URL that is used for health checks.  The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: _ ; ~ ! ( )* [ ] @ $ ^ : ' , +. The URL must start with a forward slash (/). **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
     */
    public val healthCheckPath: Output<String>
        get() = javaResource.healthCheckPath().applyValue({ args0 -> args0 })

    /**
     * The protocol that is used for health checks.  Valid values: `HTTP` and `TCP`.  Default value: `HTTP`.
     */
    public val healthCheckProtocol: Output<String>
        get() = javaResource.healthCheckProtocol().applyValue({ args0 -> args0 })

    /**
     * The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
     */
    public val healthCheckTemplateName: Output<String>
        get() = javaResource.healthCheckTemplateName().applyValue({ args0 -> args0 })

    /**
     * The timeout period of a health check response. If the backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the health check fails.  Valid values: `1` to `300`. Unit: seconds.  Default value: `5`.
     */
    public val healthCheckTimeout: Output<Int>
        get() = javaResource.healthCheckTimeout().applyValue({ args0 -> args0 })

    /**
     * The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy (from fail to success).  Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
     */
    public val healthyThreshold: Output<Int>
        get() = javaResource.healthyThreshold().applyValue({ args0 -> args0 })

    /**
     * The number of times that an healthy backend server must consecutively fail health checks before it is declared unhealthy (from success to fail). Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
     */
    public val unhealthyThreshold: Output<Int>
        get() = javaResource.unhealthyThreshold().applyValue({ args0 -> args0 })
}

public object HealthCheckTemplateMapper : ResourceMapper<HealthCheckTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.alb.HealthCheckTemplate::class == javaResource::class

    override fun map(javaResource: Resource): HealthCheckTemplate = HealthCheckTemplate(
        javaResource
            as com.pulumi.alicloud.alb.HealthCheckTemplate,
    )
}

/**
 * @see [HealthCheckTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HealthCheckTemplate].
 */
public suspend fun healthCheckTemplate(
    name: String,
    block: suspend HealthCheckTemplateResourceBuilder.() -> Unit,
): HealthCheckTemplate {
    val builder = HealthCheckTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HealthCheckTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun healthCheckTemplate(name: String): HealthCheckTemplate {
    val builder = HealthCheckTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
