@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.alicloud.alb.HealthCheckTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Application Load Balancer (ALB) Health Check Template resource.
 * For information about Application Load Balancer (ALB) Health Check Template and how to use it, see [What is Health Check Template](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createhealthchecktemplate).
 * > **NOTE:** Available since v1.134.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.alb.HealthCheckTemplate("example", {healthCheckTemplateName: "example_name"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.alb.HealthCheckTemplate("example", health_check_template_name="example_name")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Alb.HealthCheckTemplate("example", new()
 *     {
 *         HealthCheckTemplateName = "example_name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/alb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := alb.NewHealthCheckTemplate(ctx, "example", &alb.HealthCheckTemplateArgs{
 * 			HealthCheckTemplateName: pulumi.String("example_name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.alb.HealthCheckTemplate;
 * import com.pulumi.alicloud.alb.HealthCheckTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HealthCheckTemplate("example", HealthCheckTemplateArgs.builder()
 *             .healthCheckTemplateName("example_name")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:alb:HealthCheckTemplate
 *     properties:
 *       healthCheckTemplateName: example_name
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Application Load Balancer (ALB) Health Check Template can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alb/healthCheckTemplate:HealthCheckTemplate example <id>
 * ```
 * @property dryRun Whether to precheck the API request.
 * @property healthCheckCodes The HTTP status code that indicates a successful health check. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
 * @property healthCheckConnectPort The number of the port that is used for health checks.  Valid values: `0` to `65535`.  Default value: `0`. This default value indicates that the backend server is used for health checks.
 * @property healthCheckHost The domain name that is used for health checks. Default value:  `$SERVER_IP`. The domain name must be 1 to 80 characters in length.  **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
 * @property healthCheckHttpVersion The version of the HTTP protocol.  Valid values: `HTTP1.0` and `HTTP1.1`.  Default value: `HTTP1.1`. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
 * @property healthCheckInterval The time interval between two consecutive health checks.  Valid values: `1` to `50`. Unit: seconds.  Default value: `2`.
 * @property healthCheckMethod The health check method.  Valid values: GET and HEAD.  Default value: HEAD. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
 * @property healthCheckPath The URL that is used for health checks.  The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: _ ; ~ ! ( )* [ ] @ $ ^ : ' , +. The URL must start with a forward slash (/). **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
 * @property healthCheckProtocol The protocol that is used for health checks.  Valid values: `HTTP` and `TCP`.  Default value: `HTTP`.
 * @property healthCheckTemplateName The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
 * @property healthCheckTimeout The timeout period of a health check response. If the backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the health check fails.  Valid values: `1` to `300`. Unit: seconds.  Default value: `5`.
 * @property healthyThreshold The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy (from fail to success).  Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
 * @property unhealthyThreshold The number of times that an healthy backend server must consecutively fail health checks before it is declared unhealthy (from success to fail). Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
 */
public data class HealthCheckTemplateArgs(
    public val dryRun: Output<Boolean>? = null,
    public val healthCheckCodes: Output<List<String>>? = null,
    public val healthCheckConnectPort: Output<Int>? = null,
    public val healthCheckHost: Output<String>? = null,
    public val healthCheckHttpVersion: Output<String>? = null,
    public val healthCheckInterval: Output<Int>? = null,
    public val healthCheckMethod: Output<String>? = null,
    public val healthCheckPath: Output<String>? = null,
    public val healthCheckProtocol: Output<String>? = null,
    public val healthCheckTemplateName: Output<String>? = null,
    public val healthCheckTimeout: Output<Int>? = null,
    public val healthyThreshold: Output<Int>? = null,
    public val unhealthyThreshold: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.HealthCheckTemplateArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.HealthCheckTemplateArgs =
        com.pulumi.alicloud.alb.HealthCheckTemplateArgs.builder()
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .healthCheckCodes(healthCheckCodes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .healthCheckConnectPort(healthCheckConnectPort?.applyValue({ args0 -> args0 }))
            .healthCheckHost(healthCheckHost?.applyValue({ args0 -> args0 }))
            .healthCheckHttpVersion(healthCheckHttpVersion?.applyValue({ args0 -> args0 }))
            .healthCheckInterval(healthCheckInterval?.applyValue({ args0 -> args0 }))
            .healthCheckMethod(healthCheckMethod?.applyValue({ args0 -> args0 }))
            .healthCheckPath(healthCheckPath?.applyValue({ args0 -> args0 }))
            .healthCheckProtocol(healthCheckProtocol?.applyValue({ args0 -> args0 }))
            .healthCheckTemplateName(healthCheckTemplateName?.applyValue({ args0 -> args0 }))
            .healthCheckTimeout(healthCheckTimeout?.applyValue({ args0 -> args0 }))
            .healthyThreshold(healthyThreshold?.applyValue({ args0 -> args0 }))
            .unhealthyThreshold(unhealthyThreshold?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HealthCheckTemplateArgs].
 */
@PulumiTagMarker
public class HealthCheckTemplateArgsBuilder internal constructor() {
    private var dryRun: Output<Boolean>? = null

    private var healthCheckCodes: Output<List<String>>? = null

    private var healthCheckConnectPort: Output<Int>? = null

    private var healthCheckHost: Output<String>? = null

    private var healthCheckHttpVersion: Output<String>? = null

    private var healthCheckInterval: Output<Int>? = null

    private var healthCheckMethod: Output<String>? = null

    private var healthCheckPath: Output<String>? = null

    private var healthCheckProtocol: Output<String>? = null

    private var healthCheckTemplateName: Output<String>? = null

    private var healthCheckTimeout: Output<Int>? = null

    private var healthyThreshold: Output<Int>? = null

    private var unhealthyThreshold: Output<Int>? = null

    /**
     * @param value Whether to precheck the API request.
     */
    @JvmName("vvswqcsiumsafola")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The HTTP status code that indicates a successful health check. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
     */
    @JvmName("ppxfqpuubnbrsqpq")
    public suspend fun healthCheckCodes(`value`: Output<List<String>>) {
        this.healthCheckCodes = value
    }

    @JvmName("vukcsjdalcaagfaj")
    public suspend fun healthCheckCodes(vararg values: Output<String>) {
        this.healthCheckCodes = Output.all(values.asList())
    }

    /**
     * @param values The HTTP status code that indicates a successful health check. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
     */
    @JvmName("adypfhganqfhealk")
    public suspend fun healthCheckCodes(values: List<Output<String>>) {
        this.healthCheckCodes = Output.all(values)
    }

    /**
     * @param value The number of the port that is used for health checks.  Valid values: `0` to `65535`.  Default value: `0`. This default value indicates that the backend server is used for health checks.
     */
    @JvmName("eaanldgmcetcaexm")
    public suspend fun healthCheckConnectPort(`value`: Output<Int>) {
        this.healthCheckConnectPort = value
    }

    /**
     * @param value The domain name that is used for health checks. Default value:  `$SERVER_IP`. The domain name must be 1 to 80 characters in length.  **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
     */
    @JvmName("meojxtgnhommawyv")
    public suspend fun healthCheckHost(`value`: Output<String>) {
        this.healthCheckHost = value
    }

    /**
     * @param value The version of the HTTP protocol.  Valid values: `HTTP1.0` and `HTTP1.1`.  Default value: `HTTP1.1`. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
     */
    @JvmName("rbqntahobuyivklx")
    public suspend fun healthCheckHttpVersion(`value`: Output<String>) {
        this.healthCheckHttpVersion = value
    }

    /**
     * @param value The time interval between two consecutive health checks.  Valid values: `1` to `50`. Unit: seconds.  Default value: `2`.
     */
    @JvmName("ecmcihiunjokrlon")
    public suspend fun healthCheckInterval(`value`: Output<Int>) {
        this.healthCheckInterval = value
    }

    /**
     * @param value The health check method.  Valid values: GET and HEAD.  Default value: HEAD. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
     */
    @JvmName("tnsgbcxpeypqusrn")
    public suspend fun healthCheckMethod(`value`: Output<String>) {
        this.healthCheckMethod = value
    }

    /**
     * @param value The URL that is used for health checks.  The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: _ ; ~ ! ( )* [ ] @ $ ^ : ' , +. The URL must start with a forward slash (/). **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
     */
    @JvmName("gndpcuncktwtpefd")
    public suspend fun healthCheckPath(`value`: Output<String>) {
        this.healthCheckPath = value
    }

    /**
     * @param value The protocol that is used for health checks.  Valid values: `HTTP` and `TCP`.  Default value: `HTTP`.
     */
    @JvmName("tbsdxqoeawqdyofr")
    public suspend fun healthCheckProtocol(`value`: Output<String>) {
        this.healthCheckProtocol = value
    }

    /**
     * @param value The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
     */
    @JvmName("qtmvsqxjsqbkuxru")
    public suspend fun healthCheckTemplateName(`value`: Output<String>) {
        this.healthCheckTemplateName = value
    }

    /**
     * @param value The timeout period of a health check response. If the backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the health check fails.  Valid values: `1` to `300`. Unit: seconds.  Default value: `5`.
     */
    @JvmName("rjabvdryipahixhm")
    public suspend fun healthCheckTimeout(`value`: Output<Int>) {
        this.healthCheckTimeout = value
    }

    /**
     * @param value The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy (from fail to success).  Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
     */
    @JvmName("wtblinskvoqiuxks")
    public suspend fun healthyThreshold(`value`: Output<Int>) {
        this.healthyThreshold = value
    }

    /**
     * @param value The number of times that an healthy backend server must consecutively fail health checks before it is declared unhealthy (from success to fail). Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
     */
    @JvmName("wihoqrdxtwvwedvq")
    public suspend fun unhealthyThreshold(`value`: Output<Int>) {
        this.unhealthyThreshold = value
    }

    /**
     * @param value Whether to precheck the API request.
     */
    @JvmName("qrfwybqdpdnuuswk")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The HTTP status code that indicates a successful health check. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
     */
    @JvmName("klvucmnvrfgnoqhd")
    public suspend fun healthCheckCodes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckCodes = mapped
    }

    /**
     * @param values The HTTP status code that indicates a successful health check. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
     */
    @JvmName("gewobcyhneflvdyp")
    public suspend fun healthCheckCodes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthCheckCodes = mapped
    }

    /**
     * @param value The number of the port that is used for health checks.  Valid values: `0` to `65535`.  Default value: `0`. This default value indicates that the backend server is used for health checks.
     */
    @JvmName("jraiiryiaseqvabq")
    public suspend fun healthCheckConnectPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckConnectPort = mapped
    }

    /**
     * @param value The domain name that is used for health checks. Default value:  `$SERVER_IP`. The domain name must be 1 to 80 characters in length.  **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
     */
    @JvmName("pxujscrvwvkytfmn")
    public suspend fun healthCheckHost(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckHost = mapped
    }

    /**
     * @param value The version of the HTTP protocol.  Valid values: `HTTP1.0` and `HTTP1.1`.  Default value: `HTTP1.1`. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
     */
    @JvmName("kcipbiuiwmyjjxhl")
    public suspend fun healthCheckHttpVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckHttpVersion = mapped
    }

    /**
     * @param value The time interval between two consecutive health checks.  Valid values: `1` to `50`. Unit: seconds.  Default value: `2`.
     */
    @JvmName("nyewhaesaiskfipb")
    public suspend fun healthCheckInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckInterval = mapped
    }

    /**
     * @param value The health check method.  Valid values: GET and HEAD.  Default value: HEAD. **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
     */
    @JvmName("edxjjmayadmbmsog")
    public suspend fun healthCheckMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckMethod = mapped
    }

    /**
     * @param value The URL that is used for health checks.  The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: _ ; ~ ! ( )* [ ] @ $ ^ : ' , +. The URL must start with a forward slash (/). **NOTE:** The attribute `HealthCheckProtocol` is valid when the attribute is  `HTTP` .
     */
    @JvmName("hrbnmlrqalrnlvyy")
    public suspend fun healthCheckPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckPath = mapped
    }

    /**
     * @param value The protocol that is used for health checks.  Valid values: `HTTP` and `TCP`.  Default value: `HTTP`.
     */
    @JvmName("glsvqyjvdikinrgu")
    public suspend fun healthCheckProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckProtocol = mapped
    }

    /**
     * @param value The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
     */
    @JvmName("jiihglhbkarlbruj")
    public suspend fun healthCheckTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckTemplateName = mapped
    }

    /**
     * @param value The timeout period of a health check response. If the backend Elastic Compute Service (ECS) instance does not send an expected response within the specified period of time, the health check fails.  Valid values: `1` to `300`. Unit: seconds.  Default value: `5`.
     */
    @JvmName("uwqplhbdwdxalvbu")
    public suspend fun healthCheckTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckTimeout = mapped
    }

    /**
     * @param value The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy (from fail to success).  Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
     */
    @JvmName("gvmdaeuskarxyxfj")
    public suspend fun healthyThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthyThreshold = mapped
    }

    /**
     * @param value The number of times that an healthy backend server must consecutively fail health checks before it is declared unhealthy (from success to fail). Valid values: `2` to `10`.  Default value: `3`. Unit: seconds.
     */
    @JvmName("egpbdfuqilberkpv")
    public suspend fun unhealthyThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unhealthyThreshold = mapped
    }

    internal fun build(): HealthCheckTemplateArgs = HealthCheckTemplateArgs(
        dryRun = dryRun,
        healthCheckCodes = healthCheckCodes,
        healthCheckConnectPort = healthCheckConnectPort,
        healthCheckHost = healthCheckHost,
        healthCheckHttpVersion = healthCheckHttpVersion,
        healthCheckInterval = healthCheckInterval,
        healthCheckMethod = healthCheckMethod,
        healthCheckPath = healthCheckPath,
        healthCheckProtocol = healthCheckProtocol,
        healthCheckTemplateName = healthCheckTemplateName,
        healthCheckTimeout = healthCheckTimeout,
        healthyThreshold = healthyThreshold,
        unhealthyThreshold = unhealthyThreshold,
    )
}
