@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.alicloud.alb.kotlin.outputs.ListenerAccessLogTracingConfig
import com.pulumi.alicloud.alb.kotlin.outputs.ListenerAclConfig
import com.pulumi.alicloud.alb.kotlin.outputs.ListenerCertificates
import com.pulumi.alicloud.alb.kotlin.outputs.ListenerDefaultAction
import com.pulumi.alicloud.alb.kotlin.outputs.ListenerQuicConfig
import com.pulumi.alicloud.alb.kotlin.outputs.ListenerXForwardedForConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.alb.kotlin.outputs.ListenerAccessLogTracingConfig.Companion.toKotlin as listenerAccessLogTracingConfigToKotlin
import com.pulumi.alicloud.alb.kotlin.outputs.ListenerAclConfig.Companion.toKotlin as listenerAclConfigToKotlin
import com.pulumi.alicloud.alb.kotlin.outputs.ListenerCertificates.Companion.toKotlin as listenerCertificatesToKotlin
import com.pulumi.alicloud.alb.kotlin.outputs.ListenerDefaultAction.Companion.toKotlin as listenerDefaultActionToKotlin
import com.pulumi.alicloud.alb.kotlin.outputs.ListenerQuicConfig.Companion.toKotlin as listenerQuicConfigToKotlin
import com.pulumi.alicloud.alb.kotlin.outputs.ListenerXForwardedForConfig.Companion.toKotlin as listenerXForwardedForConfigToKotlin

/**
 * Builder for [Listener].
 */
@PulumiTagMarker
public class ListenerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ListenerArgs = ListenerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ListenerArgsBuilder.() -> Unit) {
        val builder = ListenerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Listener {
        val builtJavaResource = com.pulumi.alicloud.alb.Listener(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Listener(builtJavaResource)
    }
}

/**
 * Provides a Application Load Balancer (ALB) Listener resource.
 * For information about Application Load Balancer (ALB) Listener and how to use it, see [What is Listener](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createlistener).
 * > **NOTE:** Available since v1.133.0.
 * ## Import
 * Application Load Balancer (ALB) Listener can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alb/listener:Listener example <id>
 * ```
 */
public class Listener internal constructor(
    override val javaResource: com.pulumi.alicloud.alb.Listener,
) : KotlinCustomResource(javaResource, ListenerMapper) {
    /**
     * Indicates whether the access log has a custom header field. Valid values: true and false. Default value: false.
     * > **NOTE:** Only Instances outside the Security Group to Access the Log Switch **accesslogenabled** Open, in Order to Set This Parameter to the **True**.
     */
    public val accessLogRecordCustomizedHeadersEnabled: Output<Boolean>
        get() = javaResource.accessLogRecordCustomizedHeadersEnabled().applyValue({ args0 -> args0 })

    /**
     * Xtrace Configuration Information. See `access_log_tracing_config` below for details.
     */
    public val accessLogTracingConfig: Output<ListenerAccessLogTracingConfig>?
        get() = javaResource.accessLogTracingConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> listenerAccessLogTracingConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The configurations of the access control lists (ACLs). See `acl_config` below for details. **NOTE:** Field `acl_config` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alicloud.alb.ListenerAclAttachment`.,
     */
    @Deprecated(
        message = """
  Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.
  """,
    )
    public val aclConfig: Output<ListenerAclConfig>
        get() = javaResource.aclConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                listenerAclConfigToKotlin(args0)
            })
        })

    /**
     * The default certificate of the Listener. See `certificates` below for details. **NOTE:** When `listener_protocol` is `HTTPS`, The default certificate must be set one。
     */
    public val certificates: Output<ListenerCertificates>?
        get() = javaResource.certificates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    listenerCertificatesToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The Default Rule Action List. See `default_actions` below for details.
     */
    public val defaultActions: Output<List<ListenerDefaultAction>>?
        get() = javaResource.defaultActions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        listenerDefaultActionToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The dry run.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether to Enable Gzip Compression, as a Specific File Type on a Compression. Valid values: `false`, `true`. Default Value: `true`. .
     */
    public val gzipEnabled: Output<Boolean>
        get() = javaResource.gzipEnabled().applyValue({ args0 -> args0 })

    /**
     * Whether to Enable HTTP/2 Features. Valid Values: `True` Or `False`. Default Value: `True`.
     * > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
     */
    public val http2Enabled: Output<Boolean>
        get() = javaResource.http2Enabled().applyValue({ args0 -> args0 })

    /**
     * Specify the Connection Idle Timeout Value: `1` to `60`. Unit: Seconds.
     */
    public val idleTimeout: Output<Int>
        get() = javaResource.idleTimeout().applyValue({ args0 -> args0 })

    /**
     * The description of the listener. The description must be 2 to 256 characters in length. The name can contain only the characters in the following string: `/^([^\x00-\xff]|[\w&#46;,;/@-]){2,256}$/`.
     */
    public val listenerDescription: Output<String>?
        get() = javaResource.listenerDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ALB Instance Front-End, and Those of the Ports Used. Value: `1` to `65535`.
     */
    public val listenerPort: Output<Int>
        get() = javaResource.listenerPort().applyValue({ args0 -> args0 })

    /**
     * Snooping Protocols. Valid Values: `HTTP`, `HTTPS` Or `QUIC`.
     */
    public val listenerProtocol: Output<String>
        get() = javaResource.listenerProtocol().applyValue({ args0 -> args0 })

    /**
     * The ALB Instance Id.
     */
    public val loadBalancerId: Output<String>
        get() = javaResource.loadBalancerId().applyValue({ args0 -> args0 })

    /**
     * Configuration Associated with the QuIC Listening. See `quic_config` below for details.
     */
    public val quicConfig: Output<ListenerQuicConfig>
        get() = javaResource.quicConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                listenerQuicConfigToKotlin(args0)
            })
        })

    /**
     * The Specified Request Timeout Time. Value: `1` to `180`. Unit: Seconds. Default Value: `60`. If the Timeout Time Within the Back-End Server Has Not Answered the ALB Will Give up Waiting, the Client Returns the HTTP 504 Error Code.
     */
    public val requestTimeout: Output<Int>
        get() = javaResource.requestTimeout().applyValue({ args0 -> args0 })

    /**
     * Security Policy.
     * > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
     */
    public val securityPolicyId: Output<String>
        get() = javaResource.securityPolicyId().applyValue({ args0 -> args0 })

    /**
     * The state of the listener. Valid Values: `Running` Or `Stopped`. Valid values: `Running`: The listener is running. `Stopped`: The listener is stopped.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The `x_forward_for` Related Attribute Configuration. See `x_forwarded_for_config` below for details. **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
     */
    public val xForwardedForConfig: Output<ListenerXForwardedForConfig>
        get() = javaResource.xForwardedForConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                listenerXForwardedForConfigToKotlin(args0)
            })
        })
}

public object ListenerMapper : ResourceMapper<Listener> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.alb.Listener::class == javaResource::class

    override fun map(javaResource: Resource): Listener = Listener(
        javaResource as
            com.pulumi.alicloud.alb.Listener,
    )
}

/**
 * @see [Listener].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Listener].
 */
public suspend fun listener(name: String, block: suspend ListenerResourceBuilder.() -> Unit): Listener {
    val builder = ListenerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Listener].
 * @param name The _unique_ name of the resulting resource.
 */
public fun listener(name: String): Listener {
    val builder = ListenerResourceBuilder()
    builder.name(name)
    return builder.build()
}
