@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ListenerAclAttachment].
 */
@PulumiTagMarker
public class ListenerAclAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ListenerAclAttachmentArgs = ListenerAclAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ListenerAclAttachmentArgsBuilder.() -> Unit) {
        val builder = ListenerAclAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ListenerAclAttachment {
        val builtJavaResource = com.pulumi.alicloud.alb.ListenerAclAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ListenerAclAttachment(builtJavaResource)
    }
}

/**
 * Provides a ALB Listener Acl Attachment resource. Associating ACL to listening.
 * For information about ALB Listener Acl Attachment and how to use it, see [What is Listener Acl Attachment](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-associateaclswithlistener).
 * > **NOTE:** Available since v1.163.0.
 * > **NOTE:** You can associate at most three ACLs with a listener.
 * > **NOTE:** You can only configure either a whitelist or a blacklist for listener, not at the same time.
 * ## Import
 * ALB Listener Acl Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alb/listenerAclAttachment:ListenerAclAttachment example <listener_id>:<acl_id>
 * ```
 */
public class ListenerAclAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.alb.ListenerAclAttachment,
) : KotlinCustomResource(javaResource, ListenerAclAttachmentMapper) {
    /**
     * The ID list of the access policy group bound by the listener.
     */
    public val aclId: Output<String>
        get() = javaResource.aclId().applyValue({ args0 -> args0 })

    /**
     * Access control type:
     * - **White**: only requests from IP addresses or address segments in the selected access control list are forwarded. The whitelist applies to scenarios where only specific IP addresses are allowed to access. There are certain business risks in setting up a whitelist. Once the whitelist is set, only the IP addresses in the whitelist can access the load balancer listener. If whitelist access is enabled but no IP addresses are added to the access policy group, the server load balancer listener forwards all requests.
     * - **Black**: All requests from IP addresses or address segments in the selected access control list are not forwarded. Blacklists are applicable to scenarios where only certain IP addresses are restricted. If blacklist access is enabled and no IP is added to the access policy group, the server load balancer listener forwards all requests.
     */
    public val aclType: Output<String>
        get() = javaResource.aclType().applyValue({ args0 -> args0 })

    /**
     * Listener instance ID.
     */
    public val listenerId: Output<String>
        get() = javaResource.listenerId().applyValue({ args0 -> args0 })

    /**
     * Listener Status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object ListenerAclAttachmentMapper : ResourceMapper<ListenerAclAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.alb.ListenerAclAttachment::class == javaResource::class

    override fun map(javaResource: Resource): ListenerAclAttachment =
        ListenerAclAttachment(javaResource as com.pulumi.alicloud.alb.ListenerAclAttachment)
}

/**
 * @see [ListenerAclAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ListenerAclAttachment].
 */
public suspend fun listenerAclAttachment(
    name: String,
    block: suspend ListenerAclAttachmentResourceBuilder.() -> Unit,
): ListenerAclAttachment {
    val builder = ListenerAclAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ListenerAclAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun listenerAclAttachment(name: String): ListenerAclAttachment {
    val builder = ListenerAclAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
