@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.alicloud.alb.ListenerAclAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ALB Listener Acl Attachment resource. Associating ACL to listening.
 * For information about ALB Listener Acl Attachment and how to use it, see [What is Listener Acl Attachment](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-associateaclswithlistener).
 * > **NOTE:** Available since v1.163.0.
 * > **NOTE:** You can associate at most three ACLs with a listener.
 * > **NOTE:** You can only configure either a whitelist or a blacklist for listener, not at the same time.
 * ## Import
 * ALB Listener Acl Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alb/listenerAclAttachment:ListenerAclAttachment example <listener_id>:<acl_id>
 * ```
 * @property aclId The ID list of the access policy group bound by the listener.
 * @property aclType Access control type:
 * - **White**: only requests from IP addresses or address segments in the selected access control list are forwarded. The whitelist applies to scenarios where only specific IP addresses are allowed to access. There are certain business risks in setting up a whitelist. Once the whitelist is set, only the IP addresses in the whitelist can access the load balancer listener. If whitelist access is enabled but no IP addresses are added to the access policy group, the server load balancer listener forwards all requests.
 * - **Black**: All requests from IP addresses or address segments in the selected access control list are not forwarded. Blacklists are applicable to scenarios where only certain IP addresses are restricted. If blacklist access is enabled and no IP is added to the access policy group, the server load balancer listener forwards all requests.
 * @property listenerId Listener instance ID.
 */
public data class ListenerAclAttachmentArgs(
    public val aclId: Output<String>? = null,
    public val aclType: Output<String>? = null,
    public val listenerId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.ListenerAclAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.ListenerAclAttachmentArgs =
        com.pulumi.alicloud.alb.ListenerAclAttachmentArgs.builder()
            .aclId(aclId?.applyValue({ args0 -> args0 }))
            .aclType(aclType?.applyValue({ args0 -> args0 }))
            .listenerId(listenerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerAclAttachmentArgs].
 */
@PulumiTagMarker
public class ListenerAclAttachmentArgsBuilder internal constructor() {
    private var aclId: Output<String>? = null

    private var aclType: Output<String>? = null

    private var listenerId: Output<String>? = null

    /**
     * @param value The ID list of the access policy group bound by the listener.
     */
    @JvmName("argtvkyeghcdyhwo")
    public suspend fun aclId(`value`: Output<String>) {
        this.aclId = value
    }

    /**
     * @param value Access control type:
     * - **White**: only requests from IP addresses or address segments in the selected access control list are forwarded. The whitelist applies to scenarios where only specific IP addresses are allowed to access. There are certain business risks in setting up a whitelist. Once the whitelist is set, only the IP addresses in the whitelist can access the load balancer listener. If whitelist access is enabled but no IP addresses are added to the access policy group, the server load balancer listener forwards all requests.
     * - **Black**: All requests from IP addresses or address segments in the selected access control list are not forwarded. Blacklists are applicable to scenarios where only certain IP addresses are restricted. If blacklist access is enabled and no IP is added to the access policy group, the server load balancer listener forwards all requests.
     */
    @JvmName("xrraoasararkampa")
    public suspend fun aclType(`value`: Output<String>) {
        this.aclType = value
    }

    /**
     * @param value Listener instance ID.
     */
    @JvmName("qtuhjdioblkssgcq")
    public suspend fun listenerId(`value`: Output<String>) {
        this.listenerId = value
    }

    /**
     * @param value The ID list of the access policy group bound by the listener.
     */
    @JvmName("aktoqqooxfgmtxpy")
    public suspend fun aclId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclId = mapped
    }

    /**
     * @param value Access control type:
     * - **White**: only requests from IP addresses or address segments in the selected access control list are forwarded. The whitelist applies to scenarios where only specific IP addresses are allowed to access. There are certain business risks in setting up a whitelist. Once the whitelist is set, only the IP addresses in the whitelist can access the load balancer listener. If whitelist access is enabled but no IP addresses are added to the access policy group, the server load balancer listener forwards all requests.
     * - **Black**: All requests from IP addresses or address segments in the selected access control list are not forwarded. Blacklists are applicable to scenarios where only certain IP addresses are restricted. If blacklist access is enabled and no IP is added to the access policy group, the server load balancer listener forwards all requests.
     */
    @JvmName("vfapttrxgwnnpkiq")
    public suspend fun aclType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclType = mapped
    }

    /**
     * @param value Listener instance ID.
     */
    @JvmName("fufyqtcsviuwmmet")
    public suspend fun listenerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerId = mapped
    }

    internal fun build(): ListenerAclAttachmentArgs = ListenerAclAttachmentArgs(
        aclId = aclId,
        aclType = aclType,
        listenerId = listenerId,
    )
}
