@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ListenerAdditionalCertificateAttachment].
 */
@PulumiTagMarker
public class ListenerAdditionalCertificateAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ListenerAdditionalCertificateAttachmentArgs =
        ListenerAdditionalCertificateAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ListenerAdditionalCertificateAttachmentArgsBuilder.() -> Unit) {
        val builder = ListenerAdditionalCertificateAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ListenerAdditionalCertificateAttachment {
        val builtJavaResource =
            com.pulumi.alicloud.alb.ListenerAdditionalCertificateAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ListenerAdditionalCertificateAttachment(builtJavaResource)
    }
}

/**
 * Provides a Application Load Balancer (ALB) Listener Additional Certificate Attachment resource.
 * For information about Application Load Balancer (ALB) Listener Additional Certificate Attachment and how to use it, see [What is Listener Additional Certificate Attachment](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-associateadditionalcertificateswithlistener).
 * > **NOTE:** Available since v1.161.0.
 * ## Import
 * Application Load Balancer (ALB) Listener Additional Certificate Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alb/listenerAdditionalCertificateAttachment:ListenerAdditionalCertificateAttachment example <listener_id>:<certificate_id>
 * ```
 */
public class ListenerAdditionalCertificateAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.alb.ListenerAdditionalCertificateAttachment,
) : KotlinCustomResource(javaResource, ListenerAdditionalCertificateAttachmentMapper) {
    /**
     * The Certificate ID.
     */
    public val certificateId: Output<String>
        get() = javaResource.certificateId().applyValue({ args0 -> args0 })

    /**
     * The type of the certificate.
     */
    public val certificateType: Output<String>
        get() = javaResource.certificateType().applyValue({ args0 -> args0 })

    /**
     * The ID of the ALB listener.
     */
    public val listenerId: Output<String>
        get() = javaResource.listenerId().applyValue({ args0 -> args0 })

    /**
     * The status of the certificate.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object ListenerAdditionalCertificateAttachmentMapper :
    ResourceMapper<ListenerAdditionalCertificateAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.alb.ListenerAdditionalCertificateAttachment::class == javaResource::class

    override fun map(javaResource: Resource): ListenerAdditionalCertificateAttachment =
        ListenerAdditionalCertificateAttachment(
            javaResource as
                com.pulumi.alicloud.alb.ListenerAdditionalCertificateAttachment,
        )
}

/**
 * @see [ListenerAdditionalCertificateAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ListenerAdditionalCertificateAttachment].
 */
public suspend fun listenerAdditionalCertificateAttachment(
    name: String,
    block: suspend ListenerAdditionalCertificateAttachmentResourceBuilder.() -> Unit,
): ListenerAdditionalCertificateAttachment {
    val builder = ListenerAdditionalCertificateAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ListenerAdditionalCertificateAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun listenerAdditionalCertificateAttachment(name: String): ListenerAdditionalCertificateAttachment {
    val builder = ListenerAdditionalCertificateAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
