@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.alicloud.alb.ListenerAdditionalCertificateAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Application Load Balancer (ALB) Listener Additional Certificate Attachment resource.
 * For information about Application Load Balancer (ALB) Listener Additional Certificate Attachment and how to use it, see [What is Listener Additional Certificate Attachment](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-associateadditionalcertificateswithlistener).
 * > **NOTE:** Available since v1.161.0.
 * ## Import
 * Application Load Balancer (ALB) Listener Additional Certificate Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alb/listenerAdditionalCertificateAttachment:ListenerAdditionalCertificateAttachment example <listener_id>:<certificate_id>
 * ```
 * @property certificateId The Certificate ID.
 * @property listenerId The ID of the ALB listener.
 */
public data class ListenerAdditionalCertificateAttachmentArgs(
    public val certificateId: Output<String>? = null,
    public val listenerId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.ListenerAdditionalCertificateAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.ListenerAdditionalCertificateAttachmentArgs =
        com.pulumi.alicloud.alb.ListenerAdditionalCertificateAttachmentArgs.builder()
            .certificateId(certificateId?.applyValue({ args0 -> args0 }))
            .listenerId(listenerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerAdditionalCertificateAttachmentArgs].
 */
@PulumiTagMarker
public class ListenerAdditionalCertificateAttachmentArgsBuilder internal constructor() {
    private var certificateId: Output<String>? = null

    private var listenerId: Output<String>? = null

    /**
     * @param value The Certificate ID.
     */
    @JvmName("kxaivoqmonmpssvl")
    public suspend fun certificateId(`value`: Output<String>) {
        this.certificateId = value
    }

    /**
     * @param value The ID of the ALB listener.
     */
    @JvmName("fqfmdyymcnaloiss")
    public suspend fun listenerId(`value`: Output<String>) {
        this.listenerId = value
    }

    /**
     * @param value The Certificate ID.
     */
    @JvmName("ommxahmhnvelyqnw")
    public suspend fun certificateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateId = mapped
    }

    /**
     * @param value The ID of the ALB listener.
     */
    @JvmName("rsqufcollugavkij")
    public suspend fun listenerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerId = mapped
    }

    internal fun build(): ListenerAdditionalCertificateAttachmentArgs =
        ListenerAdditionalCertificateAttachmentArgs(
            certificateId = certificateId,
            listenerId = listenerId,
        )
}
