@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.alicloud.alb.ListenerArgs.builder
import com.pulumi.alicloud.alb.kotlin.inputs.ListenerAccessLogTracingConfigArgs
import com.pulumi.alicloud.alb.kotlin.inputs.ListenerAccessLogTracingConfigArgsBuilder
import com.pulumi.alicloud.alb.kotlin.inputs.ListenerAclConfigArgs
import com.pulumi.alicloud.alb.kotlin.inputs.ListenerAclConfigArgsBuilder
import com.pulumi.alicloud.alb.kotlin.inputs.ListenerCertificatesArgs
import com.pulumi.alicloud.alb.kotlin.inputs.ListenerCertificatesArgsBuilder
import com.pulumi.alicloud.alb.kotlin.inputs.ListenerDefaultActionArgs
import com.pulumi.alicloud.alb.kotlin.inputs.ListenerDefaultActionArgsBuilder
import com.pulumi.alicloud.alb.kotlin.inputs.ListenerQuicConfigArgs
import com.pulumi.alicloud.alb.kotlin.inputs.ListenerQuicConfigArgsBuilder
import com.pulumi.alicloud.alb.kotlin.inputs.ListenerXForwardedForConfigArgs
import com.pulumi.alicloud.alb.kotlin.inputs.ListenerXForwardedForConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Application Load Balancer (ALB) Listener resource.
 * For information about Application Load Balancer (ALB) Listener and how to use it, see [What is Listener](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createlistener).
 * > **NOTE:** Available since v1.133.0.
 * ## Import
 * Application Load Balancer (ALB) Listener can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alb/listener:Listener example <id>
 * ```
 * @property accessLogRecordCustomizedHeadersEnabled Indicates whether the access log has a custom header field. Valid values: true and false. Default value: false.
 * > **NOTE:** Only Instances outside the Security Group to Access the Log Switch **accesslogenabled** Open, in Order to Set This Parameter to the **True**.
 * @property accessLogTracingConfig Xtrace Configuration Information. See `access_log_tracing_config` below for details.
 * @property aclConfig The configurations of the access control lists (ACLs). See `acl_config` below for details. **NOTE:** Field `acl_config` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alicloud.alb.ListenerAclAttachment`.,
 * @property certificates The default certificate of the Listener. See `certificates` below for details. **NOTE:** When `listener_protocol` is `HTTPS`, The default certificate must be set one。
 * @property defaultActions The Default Rule Action List. See `default_actions` below for details.
 * @property dryRun The dry run.
 * @property gzipEnabled Whether to Enable Gzip Compression, as a Specific File Type on a Compression. Valid values: `false`, `true`. Default Value: `true`. .
 * @property http2Enabled Whether to Enable HTTP/2 Features. Valid Values: `True` Or `False`. Default Value: `True`.
 * > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
 * @property idleTimeout Specify the Connection Idle Timeout Value: `1` to `60`. Unit: Seconds.
 * @property listenerDescription The description of the listener. The description must be 2 to 256 characters in length. The name can contain only the characters in the following string: `/^([^\x00-\xff]|[\w&#46;,;/@-]){2,256}$/`.
 * @property listenerPort The ALB Instance Front-End, and Those of the Ports Used. Value: `1` to `65535`.
 * @property listenerProtocol Snooping Protocols. Valid Values: `HTTP`, `HTTPS` Or `QUIC`.
 * @property loadBalancerId The ALB Instance Id.
 * @property quicConfig Configuration Associated with the QuIC Listening. See `quic_config` below for details.
 * @property requestTimeout The Specified Request Timeout Time. Value: `1` to `180`. Unit: Seconds. Default Value: `60`. If the Timeout Time Within the Back-End Server Has Not Answered the ALB Will Give up Waiting, the Client Returns the HTTP 504 Error Code.
 * @property securityPolicyId Security Policy.
 * > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
 * @property status The state of the listener. Valid Values: `Running` Or `Stopped`. Valid values: `Running`: The listener is running. `Stopped`: The listener is stopped.
 * @property tags A mapping of tags to assign to the resource.
 * @property xForwardedForConfig The `x_forward_for` Related Attribute Configuration. See `x_forwarded_for_config` below for details. **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
 */
public data class ListenerArgs(
    public val accessLogRecordCustomizedHeadersEnabled: Output<Boolean>? = null,
    public val accessLogTracingConfig: Output<ListenerAccessLogTracingConfigArgs>? = null,
    @Deprecated(
        message = """
  Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.
  """,
    )
    public val aclConfig: Output<ListenerAclConfigArgs>? = null,
    public val certificates: Output<ListenerCertificatesArgs>? = null,
    public val defaultActions: Output<List<ListenerDefaultActionArgs>>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val gzipEnabled: Output<Boolean>? = null,
    public val http2Enabled: Output<Boolean>? = null,
    public val idleTimeout: Output<Int>? = null,
    public val listenerDescription: Output<String>? = null,
    public val listenerPort: Output<Int>? = null,
    public val listenerProtocol: Output<String>? = null,
    public val loadBalancerId: Output<String>? = null,
    public val quicConfig: Output<ListenerQuicConfigArgs>? = null,
    public val requestTimeout: Output<Int>? = null,
    public val securityPolicyId: Output<String>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val xForwardedForConfig: Output<ListenerXForwardedForConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.ListenerArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.ListenerArgs =
        com.pulumi.alicloud.alb.ListenerArgs.builder()
            .accessLogRecordCustomizedHeadersEnabled(
                accessLogRecordCustomizedHeadersEnabled?.applyValue({ args0 ->
                    args0
                }),
            )
            .accessLogTracingConfig(
                accessLogTracingConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .aclConfig(aclConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .certificates(certificates?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .defaultActions(
                defaultActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .gzipEnabled(gzipEnabled?.applyValue({ args0 -> args0 }))
            .http2Enabled(http2Enabled?.applyValue({ args0 -> args0 }))
            .idleTimeout(idleTimeout?.applyValue({ args0 -> args0 }))
            .listenerDescription(listenerDescription?.applyValue({ args0 -> args0 }))
            .listenerPort(listenerPort?.applyValue({ args0 -> args0 }))
            .listenerProtocol(listenerProtocol?.applyValue({ args0 -> args0 }))
            .loadBalancerId(loadBalancerId?.applyValue({ args0 -> args0 }))
            .quicConfig(quicConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .requestTimeout(requestTimeout?.applyValue({ args0 -> args0 }))
            .securityPolicyId(securityPolicyId?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .xForwardedForConfig(
                xForwardedForConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ListenerArgs].
 */
@PulumiTagMarker
public class ListenerArgsBuilder internal constructor() {
    private var accessLogRecordCustomizedHeadersEnabled: Output<Boolean>? = null

    private var accessLogTracingConfig: Output<ListenerAccessLogTracingConfigArgs>? = null

    private var aclConfig: Output<ListenerAclConfigArgs>? = null

    private var certificates: Output<ListenerCertificatesArgs>? = null

    private var defaultActions: Output<List<ListenerDefaultActionArgs>>? = null

    private var dryRun: Output<Boolean>? = null

    private var gzipEnabled: Output<Boolean>? = null

    private var http2Enabled: Output<Boolean>? = null

    private var idleTimeout: Output<Int>? = null

    private var listenerDescription: Output<String>? = null

    private var listenerPort: Output<Int>? = null

    private var listenerProtocol: Output<String>? = null

    private var loadBalancerId: Output<String>? = null

    private var quicConfig: Output<ListenerQuicConfigArgs>? = null

    private var requestTimeout: Output<Int>? = null

    private var securityPolicyId: Output<String>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var xForwardedForConfig: Output<ListenerXForwardedForConfigArgs>? = null

    /**
     * @param value Indicates whether the access log has a custom header field. Valid values: true and false. Default value: false.
     * > **NOTE:** Only Instances outside the Security Group to Access the Log Switch **accesslogenabled** Open, in Order to Set This Parameter to the **True**.
     */
    @JvmName("efbqdmrhrnuldtwx")
    public suspend fun accessLogRecordCustomizedHeadersEnabled(`value`: Output<Boolean>) {
        this.accessLogRecordCustomizedHeadersEnabled = value
    }

    /**
     * @param value Xtrace Configuration Information. See `access_log_tracing_config` below for details.
     */
    @JvmName("wdlrdiuddchecuyf")
    public suspend fun accessLogTracingConfig(`value`: Output<ListenerAccessLogTracingConfigArgs>) {
        this.accessLogTracingConfig = value
    }

    /**
     * @param value The configurations of the access control lists (ACLs). See `acl_config` below for details. **NOTE:** Field `acl_config` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alicloud.alb.ListenerAclAttachment`.,
     */
    @Deprecated(
        message = """
  Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.
  """,
    )
    @JvmName("xgviidujrrvafsrp")
    public suspend fun aclConfig(`value`: Output<ListenerAclConfigArgs>) {
        this.aclConfig = value
    }

    /**
     * @param value The default certificate of the Listener. See `certificates` below for details. **NOTE:** When `listener_protocol` is `HTTPS`, The default certificate must be set one。
     */
    @JvmName("clstsajrkxjsbofb")
    public suspend fun certificates(`value`: Output<ListenerCertificatesArgs>) {
        this.certificates = value
    }

    /**
     * @param value The Default Rule Action List. See `default_actions` below for details.
     */
    @JvmName("uqswvqoilqawilbj")
    public suspend fun defaultActions(`value`: Output<List<ListenerDefaultActionArgs>>) {
        this.defaultActions = value
    }

    @JvmName("yuopyibenpaotjul")
    public suspend fun defaultActions(vararg values: Output<ListenerDefaultActionArgs>) {
        this.defaultActions = Output.all(values.asList())
    }

    /**
     * @param values The Default Rule Action List. See `default_actions` below for details.
     */
    @JvmName("gnoealvuygvhjjjf")
    public suspend fun defaultActions(values: List<Output<ListenerDefaultActionArgs>>) {
        this.defaultActions = Output.all(values)
    }

    /**
     * @param value The dry run.
     */
    @JvmName("peyhocrxhuuqiscp")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value Whether to Enable Gzip Compression, as a Specific File Type on a Compression. Valid values: `false`, `true`. Default Value: `true`. .
     */
    @JvmName("bonlagwgcsblvnfa")
    public suspend fun gzipEnabled(`value`: Output<Boolean>) {
        this.gzipEnabled = value
    }

    /**
     * @param value Whether to Enable HTTP/2 Features. Valid Values: `True` Or `False`. Default Value: `True`.
     * > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
     */
    @JvmName("nkuigsuxoiujcolb")
    public suspend fun http2Enabled(`value`: Output<Boolean>) {
        this.http2Enabled = value
    }

    /**
     * @param value Specify the Connection Idle Timeout Value: `1` to `60`. Unit: Seconds.
     */
    @JvmName("mtvenymhjikdtgis")
    public suspend fun idleTimeout(`value`: Output<Int>) {
        this.idleTimeout = value
    }

    /**
     * @param value The description of the listener. The description must be 2 to 256 characters in length. The name can contain only the characters in the following string: `/^([^\x00-\xff]|[\w&#46;,;/@-]){2,256}$/`.
     */
    @JvmName("xuouicrsssxelyrw")
    public suspend fun listenerDescription(`value`: Output<String>) {
        this.listenerDescription = value
    }

    /**
     * @param value The ALB Instance Front-End, and Those of the Ports Used. Value: `1` to `65535`.
     */
    @JvmName("auxjeiufijhwxixb")
    public suspend fun listenerPort(`value`: Output<Int>) {
        this.listenerPort = value
    }

    /**
     * @param value Snooping Protocols. Valid Values: `HTTP`, `HTTPS` Or `QUIC`.
     */
    @JvmName("jprqbhuepuvpufcg")
    public suspend fun listenerProtocol(`value`: Output<String>) {
        this.listenerProtocol = value
    }

    /**
     * @param value The ALB Instance Id.
     */
    @JvmName("mywkmaihgmhadfps")
    public suspend fun loadBalancerId(`value`: Output<String>) {
        this.loadBalancerId = value
    }

    /**
     * @param value Configuration Associated with the QuIC Listening. See `quic_config` below for details.
     */
    @JvmName("pavoogbyljpmjamp")
    public suspend fun quicConfig(`value`: Output<ListenerQuicConfigArgs>) {
        this.quicConfig = value
    }

    /**
     * @param value The Specified Request Timeout Time. Value: `1` to `180`. Unit: Seconds. Default Value: `60`. If the Timeout Time Within the Back-End Server Has Not Answered the ALB Will Give up Waiting, the Client Returns the HTTP 504 Error Code.
     */
    @JvmName("efcjemsvfumshnjf")
    public suspend fun requestTimeout(`value`: Output<Int>) {
        this.requestTimeout = value
    }

    /**
     * @param value Security Policy.
     * > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
     */
    @JvmName("owemdohdjotoosqv")
    public suspend fun securityPolicyId(`value`: Output<String>) {
        this.securityPolicyId = value
    }

    /**
     * @param value The state of the listener. Valid Values: `Running` Or `Stopped`. Valid values: `Running`: The listener is running. `Stopped`: The listener is stopped.
     */
    @JvmName("amblbwtjidhgoxrr")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("uynmqxgnvpeysjix")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The `x_forward_for` Related Attribute Configuration. See `x_forwarded_for_config` below for details. **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
     */
    @JvmName("pyfesknhvkvwafry")
    public suspend fun xForwardedForConfig(`value`: Output<ListenerXForwardedForConfigArgs>) {
        this.xForwardedForConfig = value
    }

    /**
     * @param value Indicates whether the access log has a custom header field. Valid values: true and false. Default value: false.
     * > **NOTE:** Only Instances outside the Security Group to Access the Log Switch **accesslogenabled** Open, in Order to Set This Parameter to the **True**.
     */
    @JvmName("tvwcoaqdxqnyypxt")
    public suspend fun accessLogRecordCustomizedHeadersEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLogRecordCustomizedHeadersEnabled = mapped
    }

    /**
     * @param value Xtrace Configuration Information. See `access_log_tracing_config` below for details.
     */
    @JvmName("xlbdlwkcguxptssf")
    public suspend fun accessLogTracingConfig(`value`: ListenerAccessLogTracingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLogTracingConfig = mapped
    }

    /**
     * @param argument Xtrace Configuration Information. See `access_log_tracing_config` below for details.
     */
    @JvmName("pnhpoqlfxndwfgut")
    public suspend fun accessLogTracingConfig(argument: suspend ListenerAccessLogTracingConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerAccessLogTracingConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessLogTracingConfig = mapped
    }

    /**
     * @param value The configurations of the access control lists (ACLs). See `acl_config` below for details. **NOTE:** Field `acl_config` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alicloud.alb.ListenerAclAttachment`.,
     */
    @Deprecated(
        message = """
  Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.
  """,
    )
    @JvmName("fcbxhlisuvtgrsmh")
    public suspend fun aclConfig(`value`: ListenerAclConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclConfig = mapped
    }

    /**
     * @param argument The configurations of the access control lists (ACLs). See `acl_config` below for details. **NOTE:** Field `acl_config` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alicloud.alb.ListenerAclAttachment`.,
     */
    @Deprecated(
        message = """
  Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the
      future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.
  """,
    )
    @JvmName("hrfhuptbatipduol")
    public suspend fun aclConfig(argument: suspend ListenerAclConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerAclConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.aclConfig = mapped
    }

    /**
     * @param value The default certificate of the Listener. See `certificates` below for details. **NOTE:** When `listener_protocol` is `HTTPS`, The default certificate must be set one。
     */
    @JvmName("txigubbdvbtvhjmn")
    public suspend fun certificates(`value`: ListenerCertificatesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param argument The default certificate of the Listener. See `certificates` below for details. **NOTE:** When `listener_protocol` is `HTTPS`, The default certificate must be set one。
     */
    @JvmName("iibctmxyuenvpttl")
    public suspend fun certificates(argument: suspend ListenerCertificatesArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerCertificatesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.certificates = mapped
    }

    /**
     * @param value The Default Rule Action List. See `default_actions` below for details.
     */
    @JvmName("oulyjelkrnskyneb")
    public suspend fun defaultActions(`value`: List<ListenerDefaultActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultActions = mapped
    }

    /**
     * @param argument The Default Rule Action List. See `default_actions` below for details.
     */
    @JvmName("ppajudkguacnxwwc")
    public suspend fun defaultActions(argument: List<suspend ListenerDefaultActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ListenerDefaultActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.defaultActions = mapped
    }

    /**
     * @param argument The Default Rule Action List. See `default_actions` below for details.
     */
    @JvmName("lexiglrvhfukkwnt")
    public suspend fun defaultActions(vararg argument: suspend ListenerDefaultActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ListenerDefaultActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.defaultActions = mapped
    }

    /**
     * @param argument The Default Rule Action List. See `default_actions` below for details.
     */
    @JvmName("pyorvkulkqahbfcb")
    public suspend fun defaultActions(argument: suspend ListenerDefaultActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ListenerDefaultActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.defaultActions = mapped
    }

    /**
     * @param values The Default Rule Action List. See `default_actions` below for details.
     */
    @JvmName("bvdsustaqjnmhntw")
    public suspend fun defaultActions(vararg values: ListenerDefaultActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultActions = mapped
    }

    /**
     * @param value The dry run.
     */
    @JvmName("kdsiybfroamdoeaq")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value Whether to Enable Gzip Compression, as a Specific File Type on a Compression. Valid values: `false`, `true`. Default Value: `true`. .
     */
    @JvmName("unvouthluajrflme")
    public suspend fun gzipEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gzipEnabled = mapped
    }

    /**
     * @param value Whether to Enable HTTP/2 Features. Valid Values: `True` Or `False`. Default Value: `True`.
     * > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
     */
    @JvmName("jecmyonnvxhycflq")
    public suspend fun http2Enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.http2Enabled = mapped
    }

    /**
     * @param value Specify the Connection Idle Timeout Value: `1` to `60`. Unit: Seconds.
     */
    @JvmName("ufeeyftecqleljji")
    public suspend fun idleTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeout = mapped
    }

    /**
     * @param value The description of the listener. The description must be 2 to 256 characters in length. The name can contain only the characters in the following string: `/^([^\x00-\xff]|[\w&#46;,;/@-]){2,256}$/`.
     */
    @JvmName("gnfphvsasatxtoon")
    public suspend fun listenerDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerDescription = mapped
    }

    /**
     * @param value The ALB Instance Front-End, and Those of the Ports Used. Value: `1` to `65535`.
     */
    @JvmName("xfassjxqfgbsmphs")
    public suspend fun listenerPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerPort = mapped
    }

    /**
     * @param value Snooping Protocols. Valid Values: `HTTP`, `HTTPS` Or `QUIC`.
     */
    @JvmName("kosqfpunmvxjehll")
    public suspend fun listenerProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerProtocol = mapped
    }

    /**
     * @param value The ALB Instance Id.
     */
    @JvmName("tsrjccwsswxitirf")
    public suspend fun loadBalancerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerId = mapped
    }

    /**
     * @param value Configuration Associated with the QuIC Listening. See `quic_config` below for details.
     */
    @JvmName("kumgytieugtalnmn")
    public suspend fun quicConfig(`value`: ListenerQuicConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quicConfig = mapped
    }

    /**
     * @param argument Configuration Associated with the QuIC Listening. See `quic_config` below for details.
     */
    @JvmName("xycuoiedwthaddad")
    public suspend fun quicConfig(argument: suspend ListenerQuicConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerQuicConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.quicConfig = mapped
    }

    /**
     * @param value The Specified Request Timeout Time. Value: `1` to `180`. Unit: Seconds. Default Value: `60`. If the Timeout Time Within the Back-End Server Has Not Answered the ALB Will Give up Waiting, the Client Returns the HTTP 504 Error Code.
     */
    @JvmName("ljihawxbefbmsbnb")
    public suspend fun requestTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestTimeout = mapped
    }

    /**
     * @param value Security Policy.
     * > **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
     */
    @JvmName("bhxlqxqglvjxqgki")
    public suspend fun securityPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityPolicyId = mapped
    }

    /**
     * @param value The state of the listener. Valid Values: `Running` Or `Stopped`. Valid values: `Running`: The listener is running. `Stopped`: The listener is stopped.
     */
    @JvmName("kitvgbkalxtiiwtm")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("pigtufdidynhqfln")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("pookvwrpqayfdrlt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The `x_forward_for` Related Attribute Configuration. See `x_forwarded_for_config` below for details. **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
     */
    @JvmName("gndpqcytgroxhxye")
    public suspend fun xForwardedForConfig(`value`: ListenerXForwardedForConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xForwardedForConfig = mapped
    }

    /**
     * @param argument The `x_forward_for` Related Attribute Configuration. See `x_forwarded_for_config` below for details. **NOTE:** The attribute is valid when the attribute `listener_protocol` is `HTTPS`.
     */
    @JvmName("tbhmpawujwpowcyv")
    public suspend fun xForwardedForConfig(argument: suspend ListenerXForwardedForConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerXForwardedForConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.xForwardedForConfig = mapped
    }

    internal fun build(): ListenerArgs = ListenerArgs(
        accessLogRecordCustomizedHeadersEnabled = accessLogRecordCustomizedHeadersEnabled,
        accessLogTracingConfig = accessLogTracingConfig,
        aclConfig = aclConfig,
        certificates = certificates,
        defaultActions = defaultActions,
        dryRun = dryRun,
        gzipEnabled = gzipEnabled,
        http2Enabled = http2Enabled,
        idleTimeout = idleTimeout,
        listenerDescription = listenerDescription,
        listenerPort = listenerPort,
        listenerProtocol = listenerProtocol,
        loadBalancerId = loadBalancerId,
        quicConfig = quicConfig,
        requestTimeout = requestTimeout,
        securityPolicyId = securityPolicyId,
        status = status,
        tags = tags,
        xForwardedForConfig = xForwardedForConfig,
    )
}
