@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.alicloud.alb.kotlin.outputs.LoadBalancerAccessLogConfig
import com.pulumi.alicloud.alb.kotlin.outputs.LoadBalancerLoadBalancerBillingConfig
import com.pulumi.alicloud.alb.kotlin.outputs.LoadBalancerModificationProtectionConfig
import com.pulumi.alicloud.alb.kotlin.outputs.LoadBalancerZoneMapping
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.alb.kotlin.outputs.LoadBalancerAccessLogConfig.Companion.toKotlin as loadBalancerAccessLogConfigToKotlin
import com.pulumi.alicloud.alb.kotlin.outputs.LoadBalancerLoadBalancerBillingConfig.Companion.toKotlin as loadBalancerLoadBalancerBillingConfigToKotlin
import com.pulumi.alicloud.alb.kotlin.outputs.LoadBalancerModificationProtectionConfig.Companion.toKotlin as loadBalancerModificationProtectionConfigToKotlin
import com.pulumi.alicloud.alb.kotlin.outputs.LoadBalancerZoneMapping.Companion.toKotlin as loadBalancerZoneMappingToKotlin

/**
 * Builder for [LoadBalancer].
 */
@PulumiTagMarker
public class LoadBalancerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoadBalancerArgs = LoadBalancerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoadBalancerArgsBuilder.() -> Unit) {
        val builder = LoadBalancerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LoadBalancer {
        val builtJavaResource = com.pulumi.alicloud.alb.LoadBalancer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LoadBalancer(builtJavaResource)
    }
}

/**
 * Provides a ALB Load Balancer resource.
 * For information about ALB Load Balancer and how to use it, see [What is Load Balancer](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createloadbalancer).
 * > **NOTE:** Available since v1.132.0.
 * ## Import
 * Alb Load Balancer can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alb/loadBalancer:LoadBalancer example <id>
 * ```
 */
public class LoadBalancer internal constructor(
    override val javaResource: com.pulumi.alicloud.alb.LoadBalancer,
) : KotlinCustomResource(javaResource, LoadBalancerMapper) {
    /**
     * The configuration of the access log. See `access_log_config` below.
     */
    public val accessLogConfig: Output<LoadBalancerAccessLogConfig>?
        get() = javaResource.accessLogConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> loadBalancerAccessLogConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The mode in which IP addresses are allocated. Valid values: `Fixed`, `Dynamic`.
     */
    public val addressAllocatedMode: Output<String>?
        get() = javaResource.addressAllocatedMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The protocol version. Valid values: `IPv4`, `DualStack`.
     */
    public val addressIpVersion: Output<String>
        get() = javaResource.addressIpVersion().applyValue({ args0 -> args0 })

    /**
     * The type of the address of the ALB instance. Valid values: `Internet`, `Intranet`.
     */
    public val addressType: Output<String>
        get() = javaResource.addressType().applyValue({ args0 -> args0 })

    /**
     * The ID of the Internet Shared Bandwidth instance that is associated with the Internet-facing ALB instance.
     */
    public val bandwidthPackageId: Output<String>?
        get() = javaResource.bandwidthPackageId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time when the resource was created.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable deletion protection. Default value: `false`. Valid values:
     */
    public val deletionProtectionEnabled: Output<Boolean>?
        get() = javaResource.deletionProtectionEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * (Available since v1.158.0) The domain name of the ALB instance.
     */
    public val dnsName: Output<String>
        get() = javaResource.dnsName().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to perform a dry run. Default value: `false`. Valid values: `true`, `false`.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The address type of the Ipv6 address. Valid values: `Internet`, `Intranet`.
     */
    public val ipv6AddressType: Output<String>
        get() = javaResource.ipv6AddressType().applyValue({ args0 -> args0 })

    /**
     * The billing method of the ALB instance. See `load_balancer_billing_config` below.
     */
    public val loadBalancerBillingConfig: Output<LoadBalancerLoadBalancerBillingConfig>
        get() = javaResource.loadBalancerBillingConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                loadBalancerLoadBalancerBillingConfigToKotlin(args0)
            })
        })

    /**
     * The edition of the ALB instance. The features and billing rules vary based on the edition of the ALB instance. Valid values: `Basic`, `Standard`, `StandardWithWaf`.
     */
    public val loadBalancerEdition: Output<String>
        get() = javaResource.loadBalancerEdition().applyValue({ args0 -> args0 })

    /**
     * The name of the ALB instance.
     */
    public val loadBalancerName: Output<String>?
        get() = javaResource.loadBalancerName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The configuration of the read-only mode. See `modification_protection_config` below.
     */
    public val modificationProtectionConfig: Output<LoadBalancerModificationProtectionConfig>
        get() = javaResource.modificationProtectionConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                loadBalancerModificationProtectionConfigToKotlin(args0)
            })
        })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The status of the Load Balancer.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The ID of the VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The list of zones and vSwitch mappings. You must specify at least two zones. See `zone_mappings` below.
     */
    public val zoneMappings: Output<List<LoadBalancerZoneMapping>>
        get() = javaResource.zoneMappings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    loadBalancerZoneMappingToKotlin(args0)
                })
            })
        })
}

public object LoadBalancerMapper : ResourceMapper<LoadBalancer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.alb.LoadBalancer::class == javaResource::class

    override fun map(javaResource: Resource): LoadBalancer = LoadBalancer(
        javaResource as
            com.pulumi.alicloud.alb.LoadBalancer,
    )
}

/**
 * @see [LoadBalancer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LoadBalancer].
 */
public suspend fun loadBalancer(
    name: String,
    block: suspend LoadBalancerResourceBuilder.() -> Unit,
): LoadBalancer {
    val builder = LoadBalancerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LoadBalancer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun loadBalancer(name: String): LoadBalancer {
    val builder = LoadBalancerResourceBuilder()
    builder.name(name)
    return builder.build()
}
