@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.alicloud.alb.LoadBalancerArgs.builder
import com.pulumi.alicloud.alb.kotlin.inputs.LoadBalancerAccessLogConfigArgs
import com.pulumi.alicloud.alb.kotlin.inputs.LoadBalancerAccessLogConfigArgsBuilder
import com.pulumi.alicloud.alb.kotlin.inputs.LoadBalancerLoadBalancerBillingConfigArgs
import com.pulumi.alicloud.alb.kotlin.inputs.LoadBalancerLoadBalancerBillingConfigArgsBuilder
import com.pulumi.alicloud.alb.kotlin.inputs.LoadBalancerModificationProtectionConfigArgs
import com.pulumi.alicloud.alb.kotlin.inputs.LoadBalancerModificationProtectionConfigArgsBuilder
import com.pulumi.alicloud.alb.kotlin.inputs.LoadBalancerZoneMappingArgs
import com.pulumi.alicloud.alb.kotlin.inputs.LoadBalancerZoneMappingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ALB Load Balancer resource.
 * For information about ALB Load Balancer and how to use it, see [What is Load Balancer](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createloadbalancer).
 * > **NOTE:** Available since v1.132.0.
 * ## Import
 * Alb Load Balancer can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alb/loadBalancer:LoadBalancer example <id>
 * ```
 * @property accessLogConfig The configuration of the access log. See `access_log_config` below.
 * @property addressAllocatedMode The mode in which IP addresses are allocated. Valid values: `Fixed`, `Dynamic`.
 * @property addressIpVersion The protocol version. Valid values: `IPv4`, `DualStack`.
 * @property addressType The type of the address of the ALB instance. Valid values: `Internet`, `Intranet`.
 * @property bandwidthPackageId The ID of the Internet Shared Bandwidth instance that is associated with the Internet-facing ALB instance.
 * @property deletionProtectionEnabled Specifies whether to enable deletion protection. Default value: `false`. Valid values:
 * @property dryRun Specifies whether to perform a dry run. Default value: `false`. Valid values: `true`, `false`.
 * @property ipv6AddressType The address type of the Ipv6 address. Valid values: `Internet`, `Intranet`.
 * @property loadBalancerBillingConfig The billing method of the ALB instance. See `load_balancer_billing_config` below.
 * @property loadBalancerEdition The edition of the ALB instance. The features and billing rules vary based on the edition of the ALB instance. Valid values: `Basic`, `Standard`, `StandardWithWaf`.
 * @property loadBalancerName The name of the ALB instance.
 * @property modificationProtectionConfig The configuration of the read-only mode. See `modification_protection_config` below.
 * @property resourceGroupId The ID of the resource group.
 * @property tags A mapping of tags to assign to the resource.
 * @property vpcId The ID of the VPC.
 * @property zoneMappings The list of zones and vSwitch mappings. You must specify at least two zones. See `zone_mappings` below.
 */
public data class LoadBalancerArgs(
    public val accessLogConfig: Output<LoadBalancerAccessLogConfigArgs>? = null,
    public val addressAllocatedMode: Output<String>? = null,
    public val addressIpVersion: Output<String>? = null,
    public val addressType: Output<String>? = null,
    public val bandwidthPackageId: Output<String>? = null,
    public val deletionProtectionEnabled: Output<Boolean>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val ipv6AddressType: Output<String>? = null,
    public val loadBalancerBillingConfig: Output<LoadBalancerLoadBalancerBillingConfigArgs>? = null,
    public val loadBalancerEdition: Output<String>? = null,
    public val loadBalancerName: Output<String>? = null,
    public val modificationProtectionConfig: Output<LoadBalancerModificationProtectionConfigArgs>? =
        null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
    public val zoneMappings: Output<List<LoadBalancerZoneMappingArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.LoadBalancerArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.LoadBalancerArgs =
        com.pulumi.alicloud.alb.LoadBalancerArgs.builder()
            .accessLogConfig(accessLogConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .addressAllocatedMode(addressAllocatedMode?.applyValue({ args0 -> args0 }))
            .addressIpVersion(addressIpVersion?.applyValue({ args0 -> args0 }))
            .addressType(addressType?.applyValue({ args0 -> args0 }))
            .bandwidthPackageId(bandwidthPackageId?.applyValue({ args0 -> args0 }))
            .deletionProtectionEnabled(deletionProtectionEnabled?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .ipv6AddressType(ipv6AddressType?.applyValue({ args0 -> args0 }))
            .loadBalancerBillingConfig(
                loadBalancerBillingConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .loadBalancerEdition(loadBalancerEdition?.applyValue({ args0 -> args0 }))
            .loadBalancerName(loadBalancerName?.applyValue({ args0 -> args0 }))
            .modificationProtectionConfig(
                modificationProtectionConfig?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .zoneMappings(
                zoneMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [LoadBalancerArgs].
 */
@PulumiTagMarker
public class LoadBalancerArgsBuilder internal constructor() {
    private var accessLogConfig: Output<LoadBalancerAccessLogConfigArgs>? = null

    private var addressAllocatedMode: Output<String>? = null

    private var addressIpVersion: Output<String>? = null

    private var addressType: Output<String>? = null

    private var bandwidthPackageId: Output<String>? = null

    private var deletionProtectionEnabled: Output<Boolean>? = null

    private var dryRun: Output<Boolean>? = null

    private var ipv6AddressType: Output<String>? = null

    private var loadBalancerBillingConfig: Output<LoadBalancerLoadBalancerBillingConfigArgs>? = null

    private var loadBalancerEdition: Output<String>? = null

    private var loadBalancerName: Output<String>? = null

    private var modificationProtectionConfig: Output<LoadBalancerModificationProtectionConfigArgs>? =
        null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    private var zoneMappings: Output<List<LoadBalancerZoneMappingArgs>>? = null

    /**
     * @param value The configuration of the access log. See `access_log_config` below.
     */
    @JvmName("lrpirthcssgnnvxe")
    public suspend fun accessLogConfig(`value`: Output<LoadBalancerAccessLogConfigArgs>) {
        this.accessLogConfig = value
    }

    /**
     * @param value The mode in which IP addresses are allocated. Valid values: `Fixed`, `Dynamic`.
     */
    @JvmName("pyftiksmxrpoctph")
    public suspend fun addressAllocatedMode(`value`: Output<String>) {
        this.addressAllocatedMode = value
    }

    /**
     * @param value The protocol version. Valid values: `IPv4`, `DualStack`.
     */
    @JvmName("pfhrcmoiaixgbktn")
    public suspend fun addressIpVersion(`value`: Output<String>) {
        this.addressIpVersion = value
    }

    /**
     * @param value The type of the address of the ALB instance. Valid values: `Internet`, `Intranet`.
     */
    @JvmName("ckbxhxirjcmwftpk")
    public suspend fun addressType(`value`: Output<String>) {
        this.addressType = value
    }

    /**
     * @param value The ID of the Internet Shared Bandwidth instance that is associated with the Internet-facing ALB instance.
     */
    @JvmName("rkjiitxjfkjakjcb")
    public suspend fun bandwidthPackageId(`value`: Output<String>) {
        this.bandwidthPackageId = value
    }

    /**
     * @param value Specifies whether to enable deletion protection. Default value: `false`. Valid values:
     */
    @JvmName("jljmtlfvfegabkkg")
    public suspend fun deletionProtectionEnabled(`value`: Output<Boolean>) {
        this.deletionProtectionEnabled = value
    }

    /**
     * @param value Specifies whether to perform a dry run. Default value: `false`. Valid values: `true`, `false`.
     */
    @JvmName("lhmaqvjtqrcwnxfo")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The address type of the Ipv6 address. Valid values: `Internet`, `Intranet`.
     */
    @JvmName("ljkublvrefwrydbv")
    public suspend fun ipv6AddressType(`value`: Output<String>) {
        this.ipv6AddressType = value
    }

    /**
     * @param value The billing method of the ALB instance. See `load_balancer_billing_config` below.
     */
    @JvmName("wlgparhapyrnplnk")
    public suspend fun loadBalancerBillingConfig(`value`: Output<LoadBalancerLoadBalancerBillingConfigArgs>) {
        this.loadBalancerBillingConfig = value
    }

    /**
     * @param value The edition of the ALB instance. The features and billing rules vary based on the edition of the ALB instance. Valid values: `Basic`, `Standard`, `StandardWithWaf`.
     */
    @JvmName("nmfnngwxcniufowd")
    public suspend fun loadBalancerEdition(`value`: Output<String>) {
        this.loadBalancerEdition = value
    }

    /**
     * @param value The name of the ALB instance.
     */
    @JvmName("xoxgmhmlldshrdrx")
    public suspend fun loadBalancerName(`value`: Output<String>) {
        this.loadBalancerName = value
    }

    /**
     * @param value The configuration of the read-only mode. See `modification_protection_config` below.
     */
    @JvmName("ucscyaorqifjtirp")
    public suspend fun modificationProtectionConfig(`value`: Output<LoadBalancerModificationProtectionConfigArgs>) {
        this.modificationProtectionConfig = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("qtwgqvpovbxiyfio")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("hajconputjflowdo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("dfdkrtdymomcavge")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The list of zones and vSwitch mappings. You must specify at least two zones. See `zone_mappings` below.
     */
    @JvmName("tvttrungfrostgty")
    public suspend fun zoneMappings(`value`: Output<List<LoadBalancerZoneMappingArgs>>) {
        this.zoneMappings = value
    }

    @JvmName("toheotqrmdvpyogy")
    public suspend fun zoneMappings(vararg values: Output<LoadBalancerZoneMappingArgs>) {
        this.zoneMappings = Output.all(values.asList())
    }

    /**
     * @param values The list of zones and vSwitch mappings. You must specify at least two zones. See `zone_mappings` below.
     */
    @JvmName("cujemoxjsmhnylyr")
    public suspend fun zoneMappings(values: List<Output<LoadBalancerZoneMappingArgs>>) {
        this.zoneMappings = Output.all(values)
    }

    /**
     * @param value The configuration of the access log. See `access_log_config` below.
     */
    @JvmName("rttfnfjxibpbohqj")
    public suspend fun accessLogConfig(`value`: LoadBalancerAccessLogConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLogConfig = mapped
    }

    /**
     * @param argument The configuration of the access log. See `access_log_config` below.
     */
    @JvmName("pkvwpwgnnvvntyld")
    public suspend fun accessLogConfig(argument: suspend LoadBalancerAccessLogConfigArgsBuilder.() -> Unit) {
        val toBeMapped = LoadBalancerAccessLogConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessLogConfig = mapped
    }

    /**
     * @param value The mode in which IP addresses are allocated. Valid values: `Fixed`, `Dynamic`.
     */
    @JvmName("aaubdubtvygaifpx")
    public suspend fun addressAllocatedMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressAllocatedMode = mapped
    }

    /**
     * @param value The protocol version. Valid values: `IPv4`, `DualStack`.
     */
    @JvmName("ulbkiibyfrdnmvkl")
    public suspend fun addressIpVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressIpVersion = mapped
    }

    /**
     * @param value The type of the address of the ALB instance. Valid values: `Internet`, `Intranet`.
     */
    @JvmName("gsuaakxgwmjhocmx")
    public suspend fun addressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressType = mapped
    }

    /**
     * @param value The ID of the Internet Shared Bandwidth instance that is associated with the Internet-facing ALB instance.
     */
    @JvmName("ohqolunuhlmiumqq")
    public suspend fun bandwidthPackageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidthPackageId = mapped
    }

    /**
     * @param value Specifies whether to enable deletion protection. Default value: `false`. Valid values:
     */
    @JvmName("fqtnaoaqtdsdcgmp")
    public suspend fun deletionProtectionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtectionEnabled = mapped
    }

    /**
     * @param value Specifies whether to perform a dry run. Default value: `false`. Valid values: `true`, `false`.
     */
    @JvmName("xfgekwuqxloaqhmq")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The address type of the Ipv6 address. Valid values: `Internet`, `Intranet`.
     */
    @JvmName("dxqgcrybrxvtbpbo")
    public suspend fun ipv6AddressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6AddressType = mapped
    }

    /**
     * @param value The billing method of the ALB instance. See `load_balancer_billing_config` below.
     */
    @JvmName("jitbiyyurwnhaufj")
    public suspend fun loadBalancerBillingConfig(`value`: LoadBalancerLoadBalancerBillingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerBillingConfig = mapped
    }

    /**
     * @param argument The billing method of the ALB instance. See `load_balancer_billing_config` below.
     */
    @JvmName("mdahfxulhjvgghrb")
    public suspend fun loadBalancerBillingConfig(argument: suspend LoadBalancerLoadBalancerBillingConfigArgsBuilder.() -> Unit) {
        val toBeMapped = LoadBalancerLoadBalancerBillingConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.loadBalancerBillingConfig = mapped
    }

    /**
     * @param value The edition of the ALB instance. The features and billing rules vary based on the edition of the ALB instance. Valid values: `Basic`, `Standard`, `StandardWithWaf`.
     */
    @JvmName("ediqaqvmaijdmupg")
    public suspend fun loadBalancerEdition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerEdition = mapped
    }

    /**
     * @param value The name of the ALB instance.
     */
    @JvmName("qqqxnkocnmchlrcg")
    public suspend fun loadBalancerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerName = mapped
    }

    /**
     * @param value The configuration of the read-only mode. See `modification_protection_config` below.
     */
    @JvmName("oasxmgjocqigksdi")
    public suspend fun modificationProtectionConfig(`value`: LoadBalancerModificationProtectionConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modificationProtectionConfig = mapped
    }

    /**
     * @param argument The configuration of the read-only mode. See `modification_protection_config` below.
     */
    @JvmName("yepeqlcvuuktuubr")
    public suspend fun modificationProtectionConfig(argument: suspend LoadBalancerModificationProtectionConfigArgsBuilder.() -> Unit) {
        val toBeMapped = LoadBalancerModificationProtectionConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.modificationProtectionConfig = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("nqtugojkccudxwxa")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("lwekrhiecajhavdo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("vqmpcumfcupxhhkl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("cdfwlbxhrpierjla")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The list of zones and vSwitch mappings. You must specify at least two zones. See `zone_mappings` below.
     */
    @JvmName("refsiilakcfcsdng")
    public suspend fun zoneMappings(`value`: List<LoadBalancerZoneMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneMappings = mapped
    }

    /**
     * @param argument The list of zones and vSwitch mappings. You must specify at least two zones. See `zone_mappings` below.
     */
    @JvmName("rlwfyynhvehpccdp")
    public suspend fun zoneMappings(argument: List<suspend LoadBalancerZoneMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LoadBalancerZoneMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.zoneMappings = mapped
    }

    /**
     * @param argument The list of zones and vSwitch mappings. You must specify at least two zones. See `zone_mappings` below.
     */
    @JvmName("fqfssngykpgtlpdg")
    public suspend fun zoneMappings(vararg argument: suspend LoadBalancerZoneMappingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LoadBalancerZoneMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.zoneMappings = mapped
    }

    /**
     * @param argument The list of zones and vSwitch mappings. You must specify at least two zones. See `zone_mappings` below.
     */
    @JvmName("qjlvqacbppclfsnv")
    public suspend fun zoneMappings(argument: suspend LoadBalancerZoneMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LoadBalancerZoneMappingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.zoneMappings = mapped
    }

    /**
     * @param values The list of zones and vSwitch mappings. You must specify at least two zones. See `zone_mappings` below.
     */
    @JvmName("tarxdjyvjmepbjnr")
    public suspend fun zoneMappings(vararg values: LoadBalancerZoneMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneMappings = mapped
    }

    internal fun build(): LoadBalancerArgs = LoadBalancerArgs(
        accessLogConfig = accessLogConfig,
        addressAllocatedMode = addressAllocatedMode,
        addressIpVersion = addressIpVersion,
        addressType = addressType,
        bandwidthPackageId = bandwidthPackageId,
        deletionProtectionEnabled = deletionProtectionEnabled,
        dryRun = dryRun,
        ipv6AddressType = ipv6AddressType,
        loadBalancerBillingConfig = loadBalancerBillingConfig,
        loadBalancerEdition = loadBalancerEdition,
        loadBalancerName = loadBalancerName,
        modificationProtectionConfig = modificationProtectionConfig,
        resourceGroupId = resourceGroupId,
        tags = tags,
        vpcId = vpcId,
        zoneMappings = zoneMappings,
    )
}
