@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LoadBalancerCommonBandwidthPackageAttachment].
 */
@PulumiTagMarker
public class LoadBalancerCommonBandwidthPackageAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoadBalancerCommonBandwidthPackageAttachmentArgs =
        LoadBalancerCommonBandwidthPackageAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoadBalancerCommonBandwidthPackageAttachmentArgsBuilder.() -> Unit) {
        val builder = LoadBalancerCommonBandwidthPackageAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LoadBalancerCommonBandwidthPackageAttachment {
        val builtJavaResource =
            com.pulumi.alicloud.alb.LoadBalancerCommonBandwidthPackageAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LoadBalancerCommonBandwidthPackageAttachment(builtJavaResource)
    }
}

/**
 * Provides a Alb Load Balancer Common Bandwidth Package Attachment resource.
 * For information about Alb Load Balancer Common Bandwidth Package Attachment and how to use it, see [What is Load Balancer Common Bandwidth Package Attachment](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-attachcommonbandwidthpackagetoloadbalancer).
 * > **NOTE:** Available since v1.200.0.
 * ## Import
 * Alb Load Balancer Common Bandwidth Package Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alb/loadBalancerCommonBandwidthPackageAttachment:LoadBalancerCommonBandwidthPackageAttachment example <load_balancer_id>:<bandwidth_package_id>
 * ```
 */
public class LoadBalancerCommonBandwidthPackageAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.alb.LoadBalancerCommonBandwidthPackageAttachment,
) : KotlinCustomResource(javaResource, LoadBalancerCommonBandwidthPackageAttachmentMapper) {
    /**
     * The ID of the bound shared bandwidth package.
     */
    public val bandwidthPackageId: Output<String>
        get() = javaResource.bandwidthPackageId().applyValue({ args0 -> args0 })

    /**
     * Whether to PreCheck this request only. Value:-**true**: sends a check request and does not bind the shared bandwidth package to the load balancing instance. Check items include whether required parameters, request format, and business restrictions have been filled in. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.-**false** (default): Sends a normal request, returns the HTTP 2xx status code after the check, and directly performs the operation.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the applied server load balancer instance.
     */
    public val loadBalancerId: Output<String>
        get() = javaResource.loadBalancerId().applyValue({ args0 -> args0 })

    /**
     * The status of the Application Load balancing instance. Value:-**Inactive**: Stopped, indicating that the instance listener will no longer forward traffic.-**Active**: running.-**Provisioning**: The project is being created.-**Configuring**: The configuration is being changed.-**CreateFailed**: The instance cannot be deleted without any charge.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object LoadBalancerCommonBandwidthPackageAttachmentMapper :
    ResourceMapper<LoadBalancerCommonBandwidthPackageAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.alb.LoadBalancerCommonBandwidthPackageAttachment::class == javaResource::class

    override fun map(javaResource: Resource): LoadBalancerCommonBandwidthPackageAttachment =
        LoadBalancerCommonBandwidthPackageAttachment(
            javaResource as
                com.pulumi.alicloud.alb.LoadBalancerCommonBandwidthPackageAttachment,
        )
}

/**
 * @see [LoadBalancerCommonBandwidthPackageAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LoadBalancerCommonBandwidthPackageAttachment].
 */
public suspend fun loadBalancerCommonBandwidthPackageAttachment(
    name: String,
    block: suspend LoadBalancerCommonBandwidthPackageAttachmentResourceBuilder.() -> Unit,
): LoadBalancerCommonBandwidthPackageAttachment {
    val builder = LoadBalancerCommonBandwidthPackageAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LoadBalancerCommonBandwidthPackageAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun loadBalancerCommonBandwidthPackageAttachment(name: String): LoadBalancerCommonBandwidthPackageAttachment {
    val builder = LoadBalancerCommonBandwidthPackageAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
