@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.alicloud.alb.LoadBalancerCommonBandwidthPackageAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Alb Load Balancer Common Bandwidth Package Attachment resource.
 * For information about Alb Load Balancer Common Bandwidth Package Attachment and how to use it, see [What is Load Balancer Common Bandwidth Package Attachment](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-attachcommonbandwidthpackagetoloadbalancer).
 * > **NOTE:** Available since v1.200.0.
 * ## Import
 * Alb Load Balancer Common Bandwidth Package Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alb/loadBalancerCommonBandwidthPackageAttachment:LoadBalancerCommonBandwidthPackageAttachment example <load_balancer_id>:<bandwidth_package_id>
 * ```
 * @property bandwidthPackageId The ID of the bound shared bandwidth package.
 * @property dryRun Whether to PreCheck this request only. Value:-**true**: sends a check request and does not bind the shared bandwidth package to the load balancing instance. Check items include whether required parameters, request format, and business restrictions have been filled in. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.-**false** (default): Sends a normal request, returns the HTTP 2xx status code after the check, and directly performs the operation.
 * @property loadBalancerId The ID of the applied server load balancer instance.
 */
public data class LoadBalancerCommonBandwidthPackageAttachmentArgs(
    public val bandwidthPackageId: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val loadBalancerId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.LoadBalancerCommonBandwidthPackageAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.LoadBalancerCommonBandwidthPackageAttachmentArgs =
        com.pulumi.alicloud.alb.LoadBalancerCommonBandwidthPackageAttachmentArgs.builder()
            .bandwidthPackageId(bandwidthPackageId?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .loadBalancerId(loadBalancerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerCommonBandwidthPackageAttachmentArgs].
 */
@PulumiTagMarker
public class LoadBalancerCommonBandwidthPackageAttachmentArgsBuilder internal constructor() {
    private var bandwidthPackageId: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var loadBalancerId: Output<String>? = null

    /**
     * @param value The ID of the bound shared bandwidth package.
     */
    @JvmName("bvhmqokedkatjtpp")
    public suspend fun bandwidthPackageId(`value`: Output<String>) {
        this.bandwidthPackageId = value
    }

    /**
     * @param value Whether to PreCheck this request only. Value:-**true**: sends a check request and does not bind the shared bandwidth package to the load balancing instance. Check items include whether required parameters, request format, and business restrictions have been filled in. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.-**false** (default): Sends a normal request, returns the HTTP 2xx status code after the check, and directly performs the operation.
     */
    @JvmName("mbrslwqfoowfsuyd")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The ID of the applied server load balancer instance.
     */
    @JvmName("jtepolfbdvpufrjb")
    public suspend fun loadBalancerId(`value`: Output<String>) {
        this.loadBalancerId = value
    }

    /**
     * @param value The ID of the bound shared bandwidth package.
     */
    @JvmName("oamqdqwhtosjhqlq")
    public suspend fun bandwidthPackageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidthPackageId = mapped
    }

    /**
     * @param value Whether to PreCheck this request only. Value:-**true**: sends a check request and does not bind the shared bandwidth package to the load balancing instance. Check items include whether required parameters, request format, and business restrictions have been filled in. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.-**false** (default): Sends a normal request, returns the HTTP 2xx status code after the check, and directly performs the operation.
     */
    @JvmName("tvskbobjbvpjrhfc")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The ID of the applied server load balancer instance.
     */
    @JvmName("jjhfesrwqaadpkep")
    public suspend fun loadBalancerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerId = mapped
    }

    internal fun build(): LoadBalancerCommonBandwidthPackageAttachmentArgs =
        LoadBalancerCommonBandwidthPackageAttachmentArgs(
            bandwidthPackageId = bandwidthPackageId,
            dryRun = dryRun,
            loadBalancerId = loadBalancerId,
        )
}
