@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleAction
import com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleCondition
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleAction.Companion.toKotlin as ruleRuleActionToKotlin
import com.pulumi.alicloud.alb.kotlin.outputs.RuleRuleCondition.Companion.toKotlin as ruleRuleConditionToKotlin

/**
 * Builder for [Rule].
 */
@PulumiTagMarker
public class RuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RuleArgs = RuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RuleArgsBuilder.() -> Unit) {
        val builder = RuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Rule {
        val builtJavaResource = com.pulumi.alicloud.alb.Rule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Rule(builtJavaResource)
    }
}

/**
 * Provides a Application Load Balancer (ALB) Rule resource.
 * For information about Application Load Balancer (ALB) Rule and how to use it, see [What is Rule](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createrule).
 * > **NOTE:** Available since v1.133.0.
 * > **NOTE:** This version only supports forwarding rules in the request direction.
 * ## Import
 * Application Load Balancer (ALB) Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alb/rule:Rule example <id>
 * ```
 */
public class Rule internal constructor(
    override val javaResource: com.pulumi.alicloud.alb.Rule,
) : KotlinCustomResource(javaResource, RuleMapper) {
    /**
     * The direction to which the forwarding rule is applied. Default value: `Request`. Valid values:
     * - `Request`: The forwarding rule is applied to the client requests received by ALB.
     * - `Response`: The forwarding rule is applied to the responses returned by backend servers.
     */
    public val direction: Output<String>
        get() = javaResource.direction().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to precheck this request.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the listener to which the forwarding rule belongs.
     */
    public val listenerId: Output<String>
        get() = javaResource.listenerId().applyValue({ args0 -> args0 })

    /**
     * The priority of the rule. Valid values: 1 to 10000. A smaller value indicates a higher priority. **Note*:* The priority of each rule within the same listener must be unique.
     */
    public val priority: Output<Int>
        get() = javaResource.priority().applyValue({ args0 -> args0 })

    /**
     * The actions of the forwarding rules. See `rule_actions` below.
     */
    public val ruleActions: Output<List<RuleRuleAction>>
        get() = javaResource.ruleActions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    ruleRuleActionToKotlin(args0)
                })
            })
        })

    /**
     * The conditions of the forwarding rule. See `rule_conditions` below.
     */
    public val ruleConditions: Output<List<RuleRuleCondition>>
        get() = javaResource.ruleConditions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> ruleRuleConditionToKotlin(args0) })
            })
        })

    /**
     * The name of the forwarding rule. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
     */
    public val ruleName: Output<String>
        get() = javaResource.ruleName().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object RuleMapper : ResourceMapper<Rule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.alb.Rule::class == javaResource::class

    override fun map(javaResource: Resource): Rule = Rule(
        javaResource as
            com.pulumi.alicloud.alb.Rule,
    )
}

/**
 * @see [Rule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Rule].
 */
public suspend fun rule(name: String, block: suspend RuleResourceBuilder.() -> Unit): Rule {
    val builder = RuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Rule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun rule(name: String): Rule {
    val builder = RuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
