@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.alicloud.alb.RuleArgs.builder
import com.pulumi.alicloud.alb.kotlin.inputs.RuleRuleActionArgs
import com.pulumi.alicloud.alb.kotlin.inputs.RuleRuleActionArgsBuilder
import com.pulumi.alicloud.alb.kotlin.inputs.RuleRuleConditionArgs
import com.pulumi.alicloud.alb.kotlin.inputs.RuleRuleConditionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Application Load Balancer (ALB) Rule resource.
 * For information about Application Load Balancer (ALB) Rule and how to use it, see [What is Rule](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createrule).
 * > **NOTE:** Available since v1.133.0.
 * > **NOTE:** This version only supports forwarding rules in the request direction.
 * ## Import
 * Application Load Balancer (ALB) Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alb/rule:Rule example <id>
 * ```
 * @property direction The direction to which the forwarding rule is applied. Default value: `Request`. Valid values:
 * - `Request`: The forwarding rule is applied to the client requests received by ALB.
 * - `Response`: The forwarding rule is applied to the responses returned by backend servers.
 * @property dryRun Specifies whether to precheck this request.
 * @property listenerId The ID of the listener to which the forwarding rule belongs.
 * @property priority The priority of the rule. Valid values: 1 to 10000. A smaller value indicates a higher priority. **Note*:* The priority of each rule within the same listener must be unique.
 * @property ruleActions The actions of the forwarding rules. See `rule_actions` below.
 * @property ruleConditions The conditions of the forwarding rule. See `rule_conditions` below.
 * @property ruleName The name of the forwarding rule. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
 */
public data class RuleArgs(
    public val direction: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val listenerId: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val ruleActions: Output<List<RuleRuleActionArgs>>? = null,
    public val ruleConditions: Output<List<RuleRuleConditionArgs>>? = null,
    public val ruleName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.RuleArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.RuleArgs =
        com.pulumi.alicloud.alb.RuleArgs.builder()
            .direction(direction?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .listenerId(listenerId?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .ruleActions(
                ruleActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ruleConditions(
                ruleConditions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ruleName(ruleName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleArgs].
 */
@PulumiTagMarker
public class RuleArgsBuilder internal constructor() {
    private var direction: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var listenerId: Output<String>? = null

    private var priority: Output<Int>? = null

    private var ruleActions: Output<List<RuleRuleActionArgs>>? = null

    private var ruleConditions: Output<List<RuleRuleConditionArgs>>? = null

    private var ruleName: Output<String>? = null

    /**
     * @param value The direction to which the forwarding rule is applied. Default value: `Request`. Valid values:
     * - `Request`: The forwarding rule is applied to the client requests received by ALB.
     * - `Response`: The forwarding rule is applied to the responses returned by backend servers.
     */
    @JvmName("lejfjgpwjqnuwfyk")
    public suspend fun direction(`value`: Output<String>) {
        this.direction = value
    }

    /**
     * @param value Specifies whether to precheck this request.
     */
    @JvmName("xbnxqqjolhomjuvg")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The ID of the listener to which the forwarding rule belongs.
     */
    @JvmName("vylxvvcjlnpdbduw")
    public suspend fun listenerId(`value`: Output<String>) {
        this.listenerId = value
    }

    /**
     * @param value The priority of the rule. Valid values: 1 to 10000. A smaller value indicates a higher priority. **Note*:* The priority of each rule within the same listener must be unique.
     */
    @JvmName("otgeamooekfpgene")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The actions of the forwarding rules. See `rule_actions` below.
     */
    @JvmName("stojotofovdcknvh")
    public suspend fun ruleActions(`value`: Output<List<RuleRuleActionArgs>>) {
        this.ruleActions = value
    }

    @JvmName("ryoisgipbihetbmv")
    public suspend fun ruleActions(vararg values: Output<RuleRuleActionArgs>) {
        this.ruleActions = Output.all(values.asList())
    }

    /**
     * @param values The actions of the forwarding rules. See `rule_actions` below.
     */
    @JvmName("wuncdlvwngfwupbe")
    public suspend fun ruleActions(values: List<Output<RuleRuleActionArgs>>) {
        this.ruleActions = Output.all(values)
    }

    /**
     * @param value The conditions of the forwarding rule. See `rule_conditions` below.
     */
    @JvmName("mvqtqbjtfekrgiym")
    public suspend fun ruleConditions(`value`: Output<List<RuleRuleConditionArgs>>) {
        this.ruleConditions = value
    }

    @JvmName("ibarkusxhksfxiry")
    public suspend fun ruleConditions(vararg values: Output<RuleRuleConditionArgs>) {
        this.ruleConditions = Output.all(values.asList())
    }

    /**
     * @param values The conditions of the forwarding rule. See `rule_conditions` below.
     */
    @JvmName("judxfnnqorthxaqi")
    public suspend fun ruleConditions(values: List<Output<RuleRuleConditionArgs>>) {
        this.ruleConditions = Output.all(values)
    }

    /**
     * @param value The name of the forwarding rule. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
     */
    @JvmName("mdqrrwxdnbiwxdqk")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value The direction to which the forwarding rule is applied. Default value: `Request`. Valid values:
     * - `Request`: The forwarding rule is applied to the client requests received by ALB.
     * - `Response`: The forwarding rule is applied to the responses returned by backend servers.
     */
    @JvmName("luckctvhtewpspsn")
    public suspend fun direction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Specifies whether to precheck this request.
     */
    @JvmName("vgkbrrpjpvqiyqgb")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The ID of the listener to which the forwarding rule belongs.
     */
    @JvmName("uylehijxwujxydnl")
    public suspend fun listenerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerId = mapped
    }

    /**
     * @param value The priority of the rule. Valid values: 1 to 10000. A smaller value indicates a higher priority. **Note*:* The priority of each rule within the same listener must be unique.
     */
    @JvmName("byibljwnsxanyfph")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The actions of the forwarding rules. See `rule_actions` below.
     */
    @JvmName("mymuxxewolmvxyoh")
    public suspend fun ruleActions(`value`: List<RuleRuleActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleActions = mapped
    }

    /**
     * @param argument The actions of the forwarding rules. See `rule_actions` below.
     */
    @JvmName("weduxtbqdsuvdqjg")
    public suspend fun ruleActions(argument: List<suspend RuleRuleActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleRuleActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleActions = mapped
    }

    /**
     * @param argument The actions of the forwarding rules. See `rule_actions` below.
     */
    @JvmName("tbxscxfianqbsjam")
    public suspend fun ruleActions(vararg argument: suspend RuleRuleActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleRuleActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleActions = mapped
    }

    /**
     * @param argument The actions of the forwarding rules. See `rule_actions` below.
     */
    @JvmName("tqjevrjrsnctxlqf")
    public suspend fun ruleActions(argument: suspend RuleRuleActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RuleRuleActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ruleActions = mapped
    }

    /**
     * @param values The actions of the forwarding rules. See `rule_actions` below.
     */
    @JvmName("jckylectfcnitikb")
    public suspend fun ruleActions(vararg values: RuleRuleActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleActions = mapped
    }

    /**
     * @param value The conditions of the forwarding rule. See `rule_conditions` below.
     */
    @JvmName("cjdyvqlmbfidcfab")
    public suspend fun ruleConditions(`value`: List<RuleRuleConditionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleConditions = mapped
    }

    /**
     * @param argument The conditions of the forwarding rule. See `rule_conditions` below.
     */
    @JvmName("nywyvtblekippiqi")
    public suspend fun ruleConditions(argument: List<suspend RuleRuleConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleRuleConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleConditions = mapped
    }

    /**
     * @param argument The conditions of the forwarding rule. See `rule_conditions` below.
     */
    @JvmName("xdaxyisihlnjcgdt")
    public suspend fun ruleConditions(vararg argument: suspend RuleRuleConditionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleRuleConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleConditions = mapped
    }

    /**
     * @param argument The conditions of the forwarding rule. See `rule_conditions` below.
     */
    @JvmName("ryemiutxcpjnmgro")
    public suspend fun ruleConditions(argument: suspend RuleRuleConditionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RuleRuleConditionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ruleConditions = mapped
    }

    /**
     * @param values The conditions of the forwarding rule. See `rule_conditions` below.
     */
    @JvmName("agxjcjdbpnfdpeyq")
    public suspend fun ruleConditions(vararg values: RuleRuleConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleConditions = mapped
    }

    /**
     * @param value The name of the forwarding rule. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
     */
    @JvmName("ldclkpuinlaohpah")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    internal fun build(): RuleArgs = RuleArgs(
        direction = direction,
        dryRun = dryRun,
        listenerId = listenerId,
        priority = priority,
        ruleActions = ruleActions,
        ruleConditions = ruleConditions,
        ruleName = ruleName,
    )
}
