@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [SecurityPolicy].
 */
@PulumiTagMarker
public class SecurityPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityPolicyArgs = SecurityPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityPolicyArgsBuilder.() -> Unit) {
        val builder = SecurityPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SecurityPolicy {
        val builtJavaResource = com.pulumi.alicloud.alb.SecurityPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecurityPolicy(builtJavaResource)
    }
}

/**
 * Provides a ALB Security Policy resource.
 * For information about ALB Security Policy and how to use it, see [What is Security Policy](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createsecuritypolicy).
 * > **NOTE:** Available since v1.130.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.alb.SecurityPolicy("default", {
 *     securityPolicyName: "tf_example",
 *     tlsVersions: ["TLSv1&#46;0"],
 *     ciphers: [
 *         "ECDHE-ECDSA-AES128-SHA",
 *         "AES256-SHA",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.alb.SecurityPolicy("default",
 *     security_policy_name="tf_example",
 *     tls_versions=["TLSv1&#46;0"],
 *     ciphers=[
 *         "ECDHE-ECDSA-AES128-SHA",
 *         "AES256-SHA",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Alb.SecurityPolicy("default", new()
 *     {
 *         SecurityPolicyName = "tf_example",
 *         TlsVersions = new[]
 *         {
 *             "TLSv1.0",
 *         },
 *         Ciphers = new[]
 *         {
 *             "ECDHE-ECDSA-AES128-SHA",
 *             "AES256-SHA",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/alb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := alb.NewSecurityPolicy(ctx, "default", &alb.SecurityPolicyArgs{
 * 			SecurityPolicyName: pulumi.String("tf_example"),
 * 			TlsVersions: pulumi.StringArray{
 * 				pulumi.String("TLSv1.0"),
 * 			},
 * 			Ciphers: pulumi.StringArray{
 * 				pulumi.String("ECDHE-ECDSA-AES128-SHA"),
 * 				pulumi.String("AES256-SHA"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.alb.SecurityPolicy;
 * import com.pulumi.alicloud.alb.SecurityPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new SecurityPolicy("default", SecurityPolicyArgs.builder()
 *             .securityPolicyName("tf_example")
 *             .tlsVersions("TLSv1.0")
 *             .ciphers(
 *                 "ECDHE-ECDSA-AES128-SHA",
 *                 "AES256-SHA")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:alb:SecurityPolicy
 *     properties:
 *       securityPolicyName: tf_example
 *       tlsVersions:
 *         - TLSv1.0
 *       ciphers:
 *         - ECDHE-ECDSA-AES128-SHA
 *         - AES256-SHA
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ALB Security Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alb/securityPolicy:SecurityPolicy example <id>
 * ```
 */
public class SecurityPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.alb.SecurityPolicy,
) : KotlinCustomResource(javaResource, SecurityPolicyMapper) {
    /**
     * The supported cipher suites, which are determined by the TLS protocol version.The specified cipher suites must be supported by at least one TLS protocol version that you select.
     */
    public val ciphers: Output<List<String>>
        get() = javaResource.ciphers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The dry run.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The name of the resource. The name must be 2 to 128 characters in length and must start with a letter. It can contain digits, periods (.), underscores (_), and hyphens (-).
     */
    public val securityPolicyName: Output<String>
        get() = javaResource.securityPolicyName().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The TLS protocol versions that are supported. Valid values: TLSv1.0, TLSv1.1, TLSv1.2 and TLSv1.3.
     */
    public val tlsVersions: Output<List<String>>
        get() = javaResource.tlsVersions().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object SecurityPolicyMapper : ResourceMapper<SecurityPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.alb.SecurityPolicy::class == javaResource::class

    override fun map(javaResource: Resource): SecurityPolicy = SecurityPolicy(
        javaResource as
            com.pulumi.alicloud.alb.SecurityPolicy,
    )
}

/**
 * @see [SecurityPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityPolicy].
 */
public suspend fun securityPolicy(
    name: String,
    block: suspend SecurityPolicyResourceBuilder.() -> Unit,
): SecurityPolicy {
    val builder = SecurityPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityPolicy(name: String): SecurityPolicy {
    val builder = SecurityPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
