@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.alicloud.alb.SecurityPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ALB Security Policy resource.
 * For information about ALB Security Policy and how to use it, see [What is Security Policy](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createsecuritypolicy).
 * > **NOTE:** Available since v1.130.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.alb.SecurityPolicy("default", {
 *     securityPolicyName: "tf_example",
 *     tlsVersions: ["TLSv1&#46;0"],
 *     ciphers: [
 *         "ECDHE-ECDSA-AES128-SHA",
 *         "AES256-SHA",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.alb.SecurityPolicy("default",
 *     security_policy_name="tf_example",
 *     tls_versions=["TLSv1&#46;0"],
 *     ciphers=[
 *         "ECDHE-ECDSA-AES128-SHA",
 *         "AES256-SHA",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Alb.SecurityPolicy("default", new()
 *     {
 *         SecurityPolicyName = "tf_example",
 *         TlsVersions = new[]
 *         {
 *             "TLSv1.0",
 *         },
 *         Ciphers = new[]
 *         {
 *             "ECDHE-ECDSA-AES128-SHA",
 *             "AES256-SHA",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/alb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := alb.NewSecurityPolicy(ctx, "default", &alb.SecurityPolicyArgs{
 * 			SecurityPolicyName: pulumi.String("tf_example"),
 * 			TlsVersions: pulumi.StringArray{
 * 				pulumi.String("TLSv1.0"),
 * 			},
 * 			Ciphers: pulumi.StringArray{
 * 				pulumi.String("ECDHE-ECDSA-AES128-SHA"),
 * 				pulumi.String("AES256-SHA"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.alb.SecurityPolicy;
 * import com.pulumi.alicloud.alb.SecurityPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new SecurityPolicy("default", SecurityPolicyArgs.builder()
 *             .securityPolicyName("tf_example")
 *             .tlsVersions("TLSv1.0")
 *             .ciphers(
 *                 "ECDHE-ECDSA-AES128-SHA",
 *                 "AES256-SHA")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:alb:SecurityPolicy
 *     properties:
 *       securityPolicyName: tf_example
 *       tlsVersions:
 *         - TLSv1.0
 *       ciphers:
 *         - ECDHE-ECDSA-AES128-SHA
 *         - AES256-SHA
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ALB Security Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alb/securityPolicy:SecurityPolicy example <id>
 * ```
 * @property ciphers The supported cipher suites, which are determined by the TLS protocol version.The specified cipher suites must be supported by at least one TLS protocol version that you select.
 * @property dryRun The dry run.
 * @property resourceGroupId The ID of the resource group.
 * @property securityPolicyName The name of the resource. The name must be 2 to 128 characters in length and must start with a letter. It can contain digits, periods (.), underscores (_), and hyphens (-).
 * @property tags A mapping of tags to assign to the resource.
 * @property tlsVersions The TLS protocol versions that are supported. Valid values: TLSv1.0, TLSv1.1, TLSv1.2 and TLSv1.3.
 */
public data class SecurityPolicyArgs(
    public val ciphers: Output<List<String>>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityPolicyName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tlsVersions: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.SecurityPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.SecurityPolicyArgs =
        com.pulumi.alicloud.alb.SecurityPolicyArgs.builder()
            .ciphers(ciphers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .securityPolicyName(securityPolicyName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tlsVersions(tlsVersions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SecurityPolicyArgs].
 */
@PulumiTagMarker
public class SecurityPolicyArgsBuilder internal constructor() {
    private var ciphers: Output<List<String>>? = null

    private var dryRun: Output<Boolean>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityPolicyName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tlsVersions: Output<List<String>>? = null

    /**
     * @param value The supported cipher suites, which are determined by the TLS protocol version.The specified cipher suites must be supported by at least one TLS protocol version that you select.
     */
    @JvmName("ygrbnphqpygfwcaa")
    public suspend fun ciphers(`value`: Output<List<String>>) {
        this.ciphers = value
    }

    @JvmName("urvcxdgrhdkjyjbc")
    public suspend fun ciphers(vararg values: Output<String>) {
        this.ciphers = Output.all(values.asList())
    }

    /**
     * @param values The supported cipher suites, which are determined by the TLS protocol version.The specified cipher suites must be supported by at least one TLS protocol version that you select.
     */
    @JvmName("egsgsnkryywrqsjm")
    public suspend fun ciphers(values: List<Output<String>>) {
        this.ciphers = Output.all(values)
    }

    /**
     * @param value The dry run.
     */
    @JvmName("gjonipinpepekoog")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("hnyukjwrjpqpcclp")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The name of the resource. The name must be 2 to 128 characters in length and must start with a letter. It can contain digits, periods (.), underscores (_), and hyphens (-).
     */
    @JvmName("qwqufhrylvcyecib")
    public suspend fun securityPolicyName(`value`: Output<String>) {
        this.securityPolicyName = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("cknejqmpcnhhkfyr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The TLS protocol versions that are supported. Valid values: TLSv1.0, TLSv1.1, TLSv1.2 and TLSv1.3.
     */
    @JvmName("xkfuomoourjfubsw")
    public suspend fun tlsVersions(`value`: Output<List<String>>) {
        this.tlsVersions = value
    }

    @JvmName("idjwomxedimtgypg")
    public suspend fun tlsVersions(vararg values: Output<String>) {
        this.tlsVersions = Output.all(values.asList())
    }

    /**
     * @param values The TLS protocol versions that are supported. Valid values: TLSv1.0, TLSv1.1, TLSv1.2 and TLSv1.3.
     */
    @JvmName("glepewltxvpfmvdh")
    public suspend fun tlsVersions(values: List<Output<String>>) {
        this.tlsVersions = Output.all(values)
    }

    /**
     * @param value The supported cipher suites, which are determined by the TLS protocol version.The specified cipher suites must be supported by at least one TLS protocol version that you select.
     */
    @JvmName("indjwngthfelcsda")
    public suspend fun ciphers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ciphers = mapped
    }

    /**
     * @param values The supported cipher suites, which are determined by the TLS protocol version.The specified cipher suites must be supported by at least one TLS protocol version that you select.
     */
    @JvmName("esxhhucsinluywdk")
    public suspend fun ciphers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ciphers = mapped
    }

    /**
     * @param value The dry run.
     */
    @JvmName("fxjuqnflyekmtgjn")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("htmbspfcmblwieal")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The name of the resource. The name must be 2 to 128 characters in length and must start with a letter. It can contain digits, periods (.), underscores (_), and hyphens (-).
     */
    @JvmName("ahlmrabfqpnnbrss")
    public suspend fun securityPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityPolicyName = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("yrsfkgyfkrslkvup")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("pjueuksirkyaxwtv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The TLS protocol versions that are supported. Valid values: TLSv1.0, TLSv1.1, TLSv1.2 and TLSv1.3.
     */
    @JvmName("omsxjtrvtgqbwhki")
    public suspend fun tlsVersions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsVersions = mapped
    }

    /**
     * @param values The TLS protocol versions that are supported. Valid values: TLSv1.0, TLSv1.1, TLSv1.2 and TLSv1.3.
     */
    @JvmName("enlbfbheoacuskbc")
    public suspend fun tlsVersions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tlsVersions = mapped
    }

    internal fun build(): SecurityPolicyArgs = SecurityPolicyArgs(
        ciphers = ciphers,
        dryRun = dryRun,
        resourceGroupId = resourceGroupId,
        securityPolicyName = securityPolicyName,
        tags = tags,
        tlsVersions = tlsVersions,
    )
}
