@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin

import com.pulumi.alicloud.alb.ServerGroupArgs.builder
import com.pulumi.alicloud.alb.kotlin.inputs.ServerGroupHealthCheckConfigArgs
import com.pulumi.alicloud.alb.kotlin.inputs.ServerGroupHealthCheckConfigArgsBuilder
import com.pulumi.alicloud.alb.kotlin.inputs.ServerGroupServerArgs
import com.pulumi.alicloud.alb.kotlin.inputs.ServerGroupServerArgsBuilder
import com.pulumi.alicloud.alb.kotlin.inputs.ServerGroupStickySessionConfigArgs
import com.pulumi.alicloud.alb.kotlin.inputs.ServerGroupStickySessionConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an ALB Server Group resource.
 * For information about ALB Server Group and how to use it, see [What is Server Group](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createservergroup).
 * > **NOTE:** Available since v1.131.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const example = alicloud.resourcemanager.getResourceGroups({});
 * const exampleGetZones = alicloud.getZones({
 *     availableResourceCreation: "Instance",
 * });
 * const exampleGetInstanceTypes = exampleGetZones.then(exampleGetZones => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: exampleGetZones.zones?.[0]?.id,
 *     cpuCoreCount: 1,
 *     memorySize: 2,
 * }));
 * const exampleGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     owners: "system",
 * });
 * const exampleNetwork = new alicloud.vpc.Network("example", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const exampleSwitch = new alicloud.vpc.Switch("example", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/16",
 *     vpcId: exampleNetwork.id,
 *     zoneId: exampleGetZones.then(exampleGetZones => exampleGetZones.zones?.[0]?.id),
 * });
 * const exampleSecurityGroup = new alicloud.ecs.SecurityGroup("example", {
 *     name: name,
 *     description: name,
 *     vpcId: exampleNetwork.id,
 * });
 * const exampleInstance = new alicloud.ecs.Instance("example", {
 *     availabilityZone: exampleGetZones.then(exampleGetZones => exampleGetZones.zones?.[0]?.id),
 *     instanceName: name,
 *     imageId: exampleGetImages.then(exampleGetImages => exampleGetImages.images?.[0]?.id),
 *     instanceType: exampleGetInstanceTypes.then(exampleGetInstanceTypes => exampleGetInstanceTypes.instanceTypes?.[0]?.id),
 *     securityGroups: [exampleSecurityGroup&#46;id],
 *     vswitchId: exampleSwitch.id,
 * });
 * const exampleServerGroup = new alicloud.alb.ServerGroup("example", {
 *     protocol: "HTTP",
 *     vpcId: exampleNetwork.id,
 *     serverGroupName: name,
 *     resourceGroupId: example.then(example => example.groups?.[0]?.id),
 *     stickySessionConfig: {
 *         stickySessionEnabled: true,
 *         cookie: "tf-example",
 *         stickySessionType: "Server",
 *     },
 *     healthCheckConfig: {
 *         healthCheckConnectPort: 46325,
 *         healthCheckEnabled: true,
 *         healthCheckHost: "tf-example.com",
 *         healthCheckCodes: [
 *             "http_2xx",
 *             "http_3xx",
 *             "http_4xx",
 *         ],
 *         healthCheckHttpVersion: "HTTP1.1",
 *         healthCheckInterval: 2,
 *         healthCheckMethod: "HEAD",
 *         healthCheckPath: "/tf-example",
 *         healthCheckProtocol: "HTTP",
 *         healthCheckTimeout: 5,
 *         healthyThreshold: 3,
 *         unhealthyThreshold: 3,
 *     },
 *     servers: [{
 *         description: name,
 *         port: 80,
 *         serverId: exampleInstance.id,
 *         serverIp: exampleInstance.privateIp,
 *         serverType: "Ecs",
 *         weight: 10,
 *     }],
 *     tags: {
 *         Created: "TF",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * example = alicloud.resourcemanager.get_resource_groups()
 * example_get_zones = alicloud.get_zones(available_resource_creation="Instance")
 * example_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=example_get_zones.zones[0].id,
 *     cpu_core_count=1,
 *     memory_size=2)
 * example_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     owners="system")
 * example_network = alicloud.vpc.Network("example",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * example_switch = alicloud.vpc.Switch("example",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/16",
 *     vpc_id=example_network.id,
 *     zone_id=example_get_zones.zones[0].id)
 * example_security_group = alicloud.ecs.SecurityGroup("example",
 *     name=name,
 *     description=name,
 *     vpc_id=example_network.id)
 * example_instance = alicloud.ecs.Instance("example",
 *     availability_zone=example_get_zones.zones[0].id,
 *     instance_name=name,
 *     image_id=example_get_images.images[0].id,
 *     instance_type=example_get_instance_types.instance_types[0].id,
 *     security_groups=[example_security_group&#46;id],
 *     vswitch_id=example_switch.id)
 * example_server_group = alicloud.alb.ServerGroup("example",
 *     protocol="HTTP",
 *     vpc_id=example_network.id,
 *     server_group_name=name,
 *     resource_group_id=example.groups[0].id,
 *     sticky_session_config={
 *         "sticky_session_enabled": True,
 *         "cookie": "tf-example",
 *         "sticky_session_type": "Server",
 *     },
 *     health_check_config={
 *         "health_check_connect_port": 46325,
 *         "health_check_enabled": True,
 *         "health_check_host": "tf-example.com",
 *         "health_check_codes": [
 *             "http_2xx",
 *             "http_3xx",
 *             "http_4xx",
 *         ],
 *         "health_check_http_version": "HTTP1.1",
 *         "health_check_interval": 2,
 *         "health_check_method": "HEAD",
 *         "health_check_path": "/tf-example",
 *         "health_check_protocol": "HTTP",
 *         "health_check_timeout": 5,
 *         "healthy_threshold": 3,
 *         "unhealthy_threshold": 3,
 *     },
 *     servers=[{
 *         "description": name,
 *         "port": 80,
 *         "server_id": example_instance.id,
 *         "server_ip": example_instance.private_ip,
 *         "server_type": "Ecs",
 *         "weight": 10,
 *     }],
 *     tags={
 *         "Created": "TF",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var example = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var exampleGetZones = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "Instance",
 *     });
 *     var exampleGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = exampleGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         CpuCoreCount = 1,
 *         MemorySize = 2,
 *     });
 *     var exampleGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         Owners = "system",
 *     });
 *     var exampleNetwork = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var exampleSwitch = new AliCloud.Vpc.Switch("example", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/16",
 *         VpcId = exampleNetwork.Id,
 *         ZoneId = exampleGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var exampleSecurityGroup = new AliCloud.Ecs.SecurityGroup("example", new()
 *     {
 *         Name = name,
 *         Description = name,
 *         VpcId = exampleNetwork.Id,
 *     });
 *     var exampleInstance = new AliCloud.Ecs.Instance("example", new()
 *     {
 *         AvailabilityZone = exampleGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         InstanceName = name,
 *         ImageId = exampleGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         InstanceType = exampleGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         SecurityGroups = new[]
 *         {
 *             exampleSecurityGroup.Id,
 *         },
 *         VswitchId = exampleSwitch.Id,
 *     });
 *     var exampleServerGroup = new AliCloud.Alb.ServerGroup("example", new()
 *     {
 *         Protocol = "HTTP",
 *         VpcId = exampleNetwork.Id,
 *         ServerGroupName = name,
 *         ResourceGroupId = example.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id),
 *         StickySessionConfig = new AliCloud.Alb.Inputs.ServerGroupStickySessionConfigArgs
 *         {
 *             StickySessionEnabled = true,
 *             Cookie = "tf-example",
 *             StickySessionType = "Server",
 *         },
 *         HealthCheckConfig = new AliCloud.Alb.Inputs.ServerGroupHealthCheckConfigArgs
 *         {
 *             HealthCheckConnectPort = 46325,
 *             HealthCheckEnabled = true,
 *             HealthCheckHost = "tf-example.com",
 *             HealthCheckCodes = new[]
 *             {
 *                 "http_2xx",
 *                 "http_3xx",
 *                 "http_4xx",
 *             },
 *             HealthCheckHttpVersion = "HTTP1.1",
 *             HealthCheckInterval = 2,
 *             HealthCheckMethod = "HEAD",
 *             HealthCheckPath = "/tf-example",
 *             HealthCheckProtocol = "HTTP",
 *             HealthCheckTimeout = 5,
 *             HealthyThreshold = 3,
 *             UnhealthyThreshold = 3,
 *         },
 *         Servers = new[]
 *         {
 *             new AliCloud.Alb.Inputs.ServerGroupServerArgs
 *             {
 *                 Description = name,
 *                 Port = 80,
 *                 ServerId = exampleInstance.Id,
 *                 ServerIp = exampleInstance.PrivateIp,
 *                 ServerType = "Ecs",
 *                 Weight = 10,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/alb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGetZones, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("Instance"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone: pulumi.StringRef(exampleGetZones.Zones[0].Id),
 * 			CpuCoreCount:     pulumi.IntRef(1),
 * 			MemorySize:       pulumi.Float64Ref(2),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex: pulumi.StringRef("^ubuntu_18.*64"),
 * 			Owners:    pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleNetwork, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSwitch, err := vpc.NewSwitch(ctx, "example", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/16"),
 * 			VpcId:       exampleNetwork.ID(),
 * 			ZoneId:      pulumi.String(exampleGetZones.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSecurityGroup, err := ecs.NewSecurityGroup(ctx, "example", &ecs.SecurityGroupArgs{
 * 			Name:        pulumi.String(name),
 * 			Description: pulumi.String(name),
 * 			VpcId:       exampleNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleInstance, err := ecs.NewInstance(ctx, "example", &ecs.InstanceArgs{
 * 			AvailabilityZone: pulumi.String(exampleGetZones.Zones[0].Id),
 * 			InstanceName:     pulumi.String(name),
 * 			ImageId:          pulumi.String(exampleGetImages.Images[0].Id),
 * 			InstanceType:     pulumi.String(exampleGetInstanceTypes.InstanceTypes[0].Id),
 * 			SecurityGroups: pulumi.StringArray{
 * 				exampleSecurityGroup.ID(),
 * 			},
 * 			VswitchId: exampleSwitch.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = alb.NewServerGroup(ctx, "example", &alb.ServerGroupArgs{
 * 			Protocol:        pulumi.String("HTTP"),
 * 			VpcId:           exampleNetwork.ID(),
 * 			ServerGroupName: pulumi.String(name),
 * 			ResourceGroupId: pulumi.String(example.Groups[0].Id),
 * 			StickySessionConfig: &alb.ServerGroupStickySessionConfigArgs{
 * 				StickySessionEnabled: pulumi.Bool(true),
 * 				Cookie:               pulumi.String("tf-example"),
 * 				StickySessionType:    pulumi.String("Server"),
 * 			},
 * 			HealthCheckConfig: &alb.ServerGroupHealthCheckConfigArgs{
 * 				HealthCheckConnectPort: pulumi.Int(46325),
 * 				HealthCheckEnabled:     pulumi.Bool(true),
 * 				HealthCheckHost:        pulumi.String("tf-example.com"),
 * 				HealthCheckCodes: pulumi.StringArray{
 * 					pulumi.String("http_2xx"),
 * 					pulumi.String("http_3xx"),
 * 					pulumi.String("http_4xx"),
 * 				},
 * 				HealthCheckHttpVersion: pulumi.String("HTTP1.1"),
 * 				HealthCheckInterval:    pulumi.Int(2),
 * 				HealthCheckMethod:      pulumi.String("HEAD"),
 * 				HealthCheckPath:        pulumi.String("/tf-example"),
 * 				HealthCheckProtocol:    pulumi.String("HTTP"),
 * 				HealthCheckTimeout:     pulumi.Int(5),
 * 				HealthyThreshold:       pulumi.Int(3),
 * 				UnhealthyThreshold:     pulumi.Int(3),
 * 			},
 * 			Servers: alb.ServerGroupServerArray{
 * 				&alb.ServerGroupServerArgs{
 * 					Description: pulumi.String(name),
 * 					Port:        pulumi.Int(80),
 * 					ServerId:    exampleInstance.ID(),
 * 					ServerIp:    exampleInstance.PrivateIp,
 * 					ServerType:  pulumi.String("Ecs"),
 * 					Weight:      pulumi.Int(10),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.Instance;
 * import com.pulumi.alicloud.ecs.InstanceArgs;
 * import com.pulumi.alicloud.alb.ServerGroup;
 * import com.pulumi.alicloud.alb.ServerGroupArgs;
 * import com.pulumi.alicloud.alb.inputs.ServerGroupStickySessionConfigArgs;
 * import com.pulumi.alicloud.alb.inputs.ServerGroupHealthCheckConfigArgs;
 * import com.pulumi.alicloud.alb.inputs.ServerGroupServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var example = ResourcemanagerFunctions.getResourceGroups();
 *         final var exampleGetZones = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("Instance")
 *             .build());
 *         final var exampleGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(exampleGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .cpuCoreCount(1)
 *             .memorySize(2)
 *             .build());
 *         final var exampleGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .owners("system")
 *             .build());
 *         var exampleNetwork = new Network("exampleNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var exampleSwitch = new Switch("exampleSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .vpcId(exampleNetwork.id())
 *             .zoneId(exampleGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .build());
 *         var exampleSecurityGroup = new SecurityGroup("exampleSecurityGroup", SecurityGroupArgs.builder()
 *             .name(name)
 *             .description(name)
 *             .vpcId(exampleNetwork.id())
 *             .build());
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .availabilityZone(exampleGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .instanceName(name)
 *             .imageId(exampleGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .instanceType(exampleGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .securityGroups(exampleSecurityGroup.id())
 *             .vswitchId(exampleSwitch.id())
 *             .build());
 *         var exampleServerGroup = new ServerGroup("exampleServerGroup", ServerGroupArgs.builder()
 *             .protocol("HTTP")
 *             .vpcId(exampleNetwork.id())
 *             .serverGroupName(name)
 *             .resourceGroupId(example.applyValue(getResourceGroupsResult -> getResourceGroupsResult.groups()[0].id()))
 *             .stickySessionConfig(ServerGroupStickySessionConfigArgs.builder()
 *                 .stickySessionEnabled(true)
 *                 .cookie("tf-example")
 *                 .stickySessionType("Server")
 *                 .build())
 *             .healthCheckConfig(ServerGroupHealthCheckConfigArgs.builder()
 *                 .healthCheckConnectPort("46325")
 *                 .healthCheckEnabled(true)
 *                 .healthCheckHost("tf-example.com")
 *                 .healthCheckCodes(
 *                     "http_2xx",
 *                     "http_3xx",
 *                     "http_4xx")
 *                 .healthCheckHttpVersion("HTTP1.1")
 *                 .healthCheckInterval("2")
 *                 .healthCheckMethod("HEAD")
 *                 .healthCheckPath("/tf-example")
 *                 .healthCheckProtocol("HTTP")
 *                 .healthCheckTimeout(5)
 *                 .healthyThreshold(3)
 *                 .unhealthyThreshold(3)
 *                 .build())
 *             .servers(ServerGroupServerArgs.builder()
 *                 .description(name)
 *                 .port(80)
 *                 .serverId(exampleInstance.id())
 *                 .serverIp(exampleInstance.privateIp())
 *                 .serverType("Ecs")
 *                 .weight(10)
 *                 .build())
 *             .tags(Map.of("Created", "TF"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   exampleNetwork:
 *     type: alicloud:vpc:Network
 *     name: example
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   exampleSwitch:
 *     type: alicloud:vpc:Switch
 *     name: example
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *       vpcId: ${exampleNetwork.id}
 *       zoneId: ${exampleGetZones.zones[0].id}
 *   exampleSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: example
 *     properties:
 *       name: ${name}
 *       description: ${name}
 *       vpcId: ${exampleNetwork.id}
 *   exampleInstance:
 *     type: alicloud:ecs:Instance
 *     name: example
 *     properties:
 *       availabilityZone: ${exampleGetZones.zones[0].id}
 *       instanceName: ${name}
 *       imageId: ${exampleGetImages.images[0].id}
 *       instanceType: ${exampleGetInstanceTypes.instanceTypes[0].id}
 *       securityGroups:
 *         - ${exampleSecurityGroup.id}
 *       vswitchId: ${exampleSwitch.id}
 *   exampleServerGroup:
 *     type: alicloud:alb:ServerGroup
 *     name: example
 *     properties:
 *       protocol: HTTP
 *       vpcId: ${exampleNetwork.id}
 *       serverGroupName: ${name}
 *       resourceGroupId: ${example.groups[0].id}
 *       stickySessionConfig:
 *         stickySessionEnabled: true
 *         cookie: tf-example
 *         stickySessionType: Server
 *       healthCheckConfig:
 *         healthCheckConnectPort: '46325'
 *         healthCheckEnabled: true
 *         healthCheckHost: tf-example.com
 *         healthCheckCodes:
 *           - http_2xx
 *           - http_3xx
 *           - http_4xx
 *         healthCheckHttpVersion: HTTP1.1
 *         healthCheckInterval: '2'
 *         healthCheckMethod: HEAD
 *         healthCheckPath: /tf-example
 *         healthCheckProtocol: HTTP
 *         healthCheckTimeout: 5
 *         healthyThreshold: 3
 *         unhealthyThreshold: 3
 *       servers:
 *         - description: ${name}
 *           port: 80
 *           serverId: ${exampleInstance.id}
 *           serverIp: ${exampleInstance.privateIp}
 *           serverType: Ecs
 *           weight: 10
 *       tags:
 *         Created: TF
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 *   exampleGetZones:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: Instance
 *   exampleGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${exampleGetZones.zones[0].id}
 *         cpuCoreCount: 1
 *         memorySize: 2
 *   exampleGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         nameRegex: ^ubuntu_18.*64
 *         owners: system
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ALB Server Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:alb/serverGroup:ServerGroup example <id>
 * ```
 * @property dryRun The dry run.
 * @property healthCheckConfig The configuration of health checks. See `health_check_config` below.
 * @property protocol The server protocol. Valid values: ` HTTP`, `HTTPS`, `gRPC`. While `server_group_type` is `Fc` this parameter will not take effect. From version 1.215.0, `protocol` can be set to `gRPC`.
 * @property resourceGroupId The ID of the resource group.
 * @property scheduler The scheduling algorithm. Valid values: ` Sch`, ` Wlc`, `Wrr`. **NOTE:** This parameter takes effect when the `server_group_type` parameter is set to `Instance` or `Ip`.
 * @property serverGroupName The name of the server group.
 * @property serverGroupType The type of the server group. Default value: `Instance`. Valid values:
 * - `Instance`: allows you add servers by specifying Ecs, Ens, or Eci.
 * - `Ip`: allows you to add servers by specifying IP addresses.
 * - `Fc`: allows you to add servers by specifying functions of Function Compute.
 * @property servers The backend servers. See `servers` below.
 * @property stickySessionConfig The configuration of session persistence. See `sticky_session_config` below.
 * @property tags A mapping of tags to assign to the resource.
 * @property vpcId The ID of the VPC that you want to access. **NOTE:** This parameter takes effect when the `server_group_type` parameter is set to `Instance` or `Ip`.
 */
public data class ServerGroupArgs(
    public val dryRun: Output<Boolean>? = null,
    public val healthCheckConfig: Output<ServerGroupHealthCheckConfigArgs>? = null,
    public val protocol: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val scheduler: Output<String>? = null,
    public val serverGroupName: Output<String>? = null,
    public val serverGroupType: Output<String>? = null,
    public val servers: Output<List<ServerGroupServerArgs>>? = null,
    public val stickySessionConfig: Output<ServerGroupStickySessionConfigArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.ServerGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.ServerGroupArgs =
        com.pulumi.alicloud.alb.ServerGroupArgs.builder()
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .healthCheckConfig(healthCheckConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .scheduler(scheduler?.applyValue({ args0 -> args0 }))
            .serverGroupName(serverGroupName?.applyValue({ args0 -> args0 }))
            .serverGroupType(serverGroupType?.applyValue({ args0 -> args0 }))
            .servers(
                servers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .stickySessionConfig(
                stickySessionConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerGroupArgs].
 */
@PulumiTagMarker
public class ServerGroupArgsBuilder internal constructor() {
    private var dryRun: Output<Boolean>? = null

    private var healthCheckConfig: Output<ServerGroupHealthCheckConfigArgs>? = null

    private var protocol: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var scheduler: Output<String>? = null

    private var serverGroupName: Output<String>? = null

    private var serverGroupType: Output<String>? = null

    private var servers: Output<List<ServerGroupServerArgs>>? = null

    private var stickySessionConfig: Output<ServerGroupStickySessionConfigArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The dry run.
     */
    @JvmName("wuiegmaaojycfctf")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The configuration of health checks. See `health_check_config` below.
     */
    @JvmName("phasctunjamkfohl")
    public suspend fun healthCheckConfig(`value`: Output<ServerGroupHealthCheckConfigArgs>) {
        this.healthCheckConfig = value
    }

    /**
     * @param value The server protocol. Valid values: ` HTTP`, `HTTPS`, `gRPC`. While `server_group_type` is `Fc` this parameter will not take effect. From version 1.215.0, `protocol` can be set to `gRPC`.
     */
    @JvmName("herpansfmpwedway")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("fmpkfljdrijudmsu")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The scheduling algorithm. Valid values: ` Sch`, ` Wlc`, `Wrr`. **NOTE:** This parameter takes effect when the `server_group_type` parameter is set to `Instance` or `Ip`.
     */
    @JvmName("ricvcbwnhtruuodh")
    public suspend fun scheduler(`value`: Output<String>) {
        this.scheduler = value
    }

    /**
     * @param value The name of the server group.
     */
    @JvmName("fxwkoyhmqjgkomci")
    public suspend fun serverGroupName(`value`: Output<String>) {
        this.serverGroupName = value
    }

    /**
     * @param value The type of the server group. Default value: `Instance`. Valid values:
     * - `Instance`: allows you add servers by specifying Ecs, Ens, or Eci.
     * - `Ip`: allows you to add servers by specifying IP addresses.
     * - `Fc`: allows you to add servers by specifying functions of Function Compute.
     */
    @JvmName("proevvwwexicjfwq")
    public suspend fun serverGroupType(`value`: Output<String>) {
        this.serverGroupType = value
    }

    /**
     * @param value The backend servers. See `servers` below.
     */
    @JvmName("wndfyooarnhhihhv")
    public suspend fun servers(`value`: Output<List<ServerGroupServerArgs>>) {
        this.servers = value
    }

    @JvmName("sjhlcxwuhohtcshd")
    public suspend fun servers(vararg values: Output<ServerGroupServerArgs>) {
        this.servers = Output.all(values.asList())
    }

    /**
     * @param values The backend servers. See `servers` below.
     */
    @JvmName("qbtlhmwkfmmnnuqn")
    public suspend fun servers(values: List<Output<ServerGroupServerArgs>>) {
        this.servers = Output.all(values)
    }

    /**
     * @param value The configuration of session persistence. See `sticky_session_config` below.
     */
    @JvmName("vpxtqbosbprhfgeu")
    public suspend fun stickySessionConfig(`value`: Output<ServerGroupStickySessionConfigArgs>) {
        this.stickySessionConfig = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("cflcaoucyyasqklm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the VPC that you want to access. **NOTE:** This parameter takes effect when the `server_group_type` parameter is set to `Instance` or `Ip`.
     */
    @JvmName("lsxfhceihhjdqesn")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The dry run.
     */
    @JvmName("lnfiltyojjjekrxj")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The configuration of health checks. See `health_check_config` below.
     */
    @JvmName("ryfsxtatjyaojvri")
    public suspend fun healthCheckConfig(`value`: ServerGroupHealthCheckConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckConfig = mapped
    }

    /**
     * @param argument The configuration of health checks. See `health_check_config` below.
     */
    @JvmName("jtpkooteukcwaftg")
    public suspend fun healthCheckConfig(argument: suspend ServerGroupHealthCheckConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ServerGroupHealthCheckConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.healthCheckConfig = mapped
    }

    /**
     * @param value The server protocol. Valid values: ` HTTP`, `HTTPS`, `gRPC`. While `server_group_type` is `Fc` this parameter will not take effect. From version 1.215.0, `protocol` can be set to `gRPC`.
     */
    @JvmName("kcwubtvhjpmhslpj")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("dedydsayxxelrbny")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The scheduling algorithm. Valid values: ` Sch`, ` Wlc`, `Wrr`. **NOTE:** This parameter takes effect when the `server_group_type` parameter is set to `Instance` or `Ip`.
     */
    @JvmName("gnnscvvfasoymial")
    public suspend fun scheduler(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduler = mapped
    }

    /**
     * @param value The name of the server group.
     */
    @JvmName("bcxydefulfjxelcl")
    public suspend fun serverGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverGroupName = mapped
    }

    /**
     * @param value The type of the server group. Default value: `Instance`. Valid values:
     * - `Instance`: allows you add servers by specifying Ecs, Ens, or Eci.
     * - `Ip`: allows you to add servers by specifying IP addresses.
     * - `Fc`: allows you to add servers by specifying functions of Function Compute.
     */
    @JvmName("xuxtilqwgeybdeiu")
    public suspend fun serverGroupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverGroupType = mapped
    }

    /**
     * @param value The backend servers. See `servers` below.
     */
    @JvmName("rigejqualhqqxugb")
    public suspend fun servers(`value`: List<ServerGroupServerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servers = mapped
    }

    /**
     * @param argument The backend servers. See `servers` below.
     */
    @JvmName("wnbekttybbujemne")
    public suspend fun servers(argument: List<suspend ServerGroupServerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServerGroupServerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.servers = mapped
    }

    /**
     * @param argument The backend servers. See `servers` below.
     */
    @JvmName("ipvfhcdjfhrteqle")
    public suspend fun servers(vararg argument: suspend ServerGroupServerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ServerGroupServerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.servers = mapped
    }

    /**
     * @param argument The backend servers. See `servers` below.
     */
    @JvmName("qfftaipwspbrmdak")
    public suspend fun servers(argument: suspend ServerGroupServerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ServerGroupServerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.servers = mapped
    }

    /**
     * @param values The backend servers. See `servers` below.
     */
    @JvmName("rstkxtqitnosedtk")
    public suspend fun servers(vararg values: ServerGroupServerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servers = mapped
    }

    /**
     * @param value The configuration of session persistence. See `sticky_session_config` below.
     */
    @JvmName("cspxvjhloftfaorc")
    public suspend fun stickySessionConfig(`value`: ServerGroupStickySessionConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stickySessionConfig = mapped
    }

    /**
     * @param argument The configuration of session persistence. See `sticky_session_config` below.
     */
    @JvmName("lldcbrdhtladkltm")
    public suspend fun stickySessionConfig(argument: suspend ServerGroupStickySessionConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ServerGroupStickySessionConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.stickySessionConfig = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("traluuwutecmlkkc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("bnsmxtbgrlcyyqdu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the VPC that you want to access. **NOTE:** This parameter takes effect when the `server_group_type` parameter is set to `Instance` or `Ip`.
     */
    @JvmName("fyeouqvkvotdjved")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): ServerGroupArgs = ServerGroupArgs(
        dryRun = dryRun,
        healthCheckConfig = healthCheckConfig,
        protocol = protocol,
        resourceGroupId = resourceGroupId,
        scheduler = scheduler,
        serverGroupName = serverGroupName,
        serverGroupType = serverGroupType,
        servers = servers,
        stickySessionConfig = stickySessionConfig,
        tags = tags,
        vpcId = vpcId,
    )
}
