@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.AScriptExtAttributeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property attributeKey The key of the extended attribute.
 * @property attributeValue The value of the extended attribute.
 */
public data class AScriptExtAttributeArgs(
    public val attributeKey: Output<String>? = null,
    public val attributeValue: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.AScriptExtAttributeArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.AScriptExtAttributeArgs =
        com.pulumi.alicloud.alb.inputs.AScriptExtAttributeArgs.builder()
            .attributeKey(attributeKey?.applyValue({ args0 -> args0 }))
            .attributeValue(attributeValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AScriptExtAttributeArgs].
 */
@PulumiTagMarker
public class AScriptExtAttributeArgsBuilder internal constructor() {
    private var attributeKey: Output<String>? = null

    private var attributeValue: Output<String>? = null

    /**
     * @param value The key of the extended attribute.
     */
    @JvmName("xthtwyubrexfgryb")
    public suspend fun attributeKey(`value`: Output<String>) {
        this.attributeKey = value
    }

    /**
     * @param value The value of the extended attribute.
     */
    @JvmName("ykcpwtwygintdnef")
    public suspend fun attributeValue(`value`: Output<String>) {
        this.attributeValue = value
    }

    /**
     * @param value The key of the extended attribute.
     */
    @JvmName("jsfsnuvmqrlenokm")
    public suspend fun attributeKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributeKey = mapped
    }

    /**
     * @param value The value of the extended attribute.
     */
    @JvmName("ukmlhsrwtycrjdoq")
    public suspend fun attributeValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributeValue = mapped
    }

    internal fun build(): AScriptExtAttributeArgs = AScriptExtAttributeArgs(
        attributeKey = attributeKey,
        attributeValue = attributeValue,
    )
}
