@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.AclAclEntryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description The description of the ACL entry. The description must be `1` to `256` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.),and underscores (_). It can also contain Chinese characters.
 * @property entry The IP address for the ACL entry.
 * @property status The status of the ACL entry. Valid values:
 * - `Adding`: The ACL entry is being added.
 * - `Available`: The ACL entry is added and available.
 * - `Removing`: The ACL entry is being removed.
 */
public data class AclAclEntryArgs(
    public val description: Output<String>? = null,
    public val entry: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.AclAclEntryArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.AclAclEntryArgs =
        com.pulumi.alicloud.alb.inputs.AclAclEntryArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .entry(entry?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AclAclEntryArgs].
 */
@PulumiTagMarker
public class AclAclEntryArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var entry: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The description of the ACL entry. The description must be `1` to `256` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.),and underscores (_). It can also contain Chinese characters.
     */
    @JvmName("wtgqclxnsnlsubil")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The IP address for the ACL entry.
     */
    @JvmName("qmsobtwokkatjwkg")
    public suspend fun entry(`value`: Output<String>) {
        this.entry = value
    }

    /**
     * @param value The status of the ACL entry. Valid values:
     * - `Adding`: The ACL entry is being added.
     * - `Available`: The ACL entry is added and available.
     * - `Removing`: The ACL entry is being removed.
     */
    @JvmName("owosqmpjmlnrvugm")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The description of the ACL entry. The description must be `1` to `256` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.),and underscores (_). It can also contain Chinese characters.
     */
    @JvmName("irjyndhhblkqiwnt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The IP address for the ACL entry.
     */
    @JvmName("twxtwljrgxqiqqct")
    public suspend fun entry(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entry = mapped
    }

    /**
     * @param value The status of the ACL entry. Valid values:
     * - `Adding`: The ACL entry is being added.
     * - `Available`: The ACL entry is added and available.
     * - `Removing`: The ACL entry is being removed.
     */
    @JvmName("yrpbxdbulnqusphc")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): AclAclEntryArgs = AclAclEntryArgs(
        description = description,
        entry = entry,
        status = status,
    )
}
