@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.GetAclsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAcls.
 * @property aclIds The acl ids.
 * @property aclName The ACL Name.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Acl IDs.
 * @property nameRegex A regex string to filter results by Acl name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId Resource Group to Which the Number.
 * @property status The state of the ACL. Valid values:`Provisioning`,`Available`and`Configuring`.  `Provisioning`: The ACL is being created. `Available`: The ACL is available. `Configuring`: The ACL is being configured.
 */
public data class GetAclsPlainArgs(
    public val aclIds: List<String>? = null,
    public val aclName: String? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.GetAclsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.GetAclsPlainArgs =
        com.pulumi.alicloud.alb.inputs.GetAclsPlainArgs.builder()
            .aclIds(aclIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .aclName(aclName?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAclsPlainArgs].
 */
@PulumiTagMarker
public class GetAclsPlainArgsBuilder internal constructor() {
    private var aclIds: List<String>? = null

    private var aclName: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var status: String? = null

    /**
     * @param value The acl ids.
     */
    @JvmName("hgehiwkxepfqopqq")
    public suspend fun aclIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.aclIds = mapped
    }

    /**
     * @param values The acl ids.
     */
    @JvmName("vyppexxuadbgjxxy")
    public suspend fun aclIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.aclIds = mapped
    }

    /**
     * @param value The ACL Name.
     */
    @JvmName("cduvfavwmepikjnr")
    public suspend fun aclName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.aclName = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("kajvgxdicougyfcu")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Acl IDs.
     */
    @JvmName("nxvuekfgywfgankk")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Acl IDs.
     */
    @JvmName("orbewwtylfksfndi")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Acl name.
     */
    @JvmName("snhjympnxnjudbvp")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("yjljojuvoogxieds")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Resource Group to Which the Number.
     */
    @JvmName("ggodrspsmrwpruyw")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The state of the ACL. Valid values:`Provisioning`,`Available`and`Configuring`.  `Provisioning`: The ACL is being created. `Available`: The ACL is available. `Configuring`: The ACL is being configured.
     */
    @JvmName("ttwlldxutbqtrhnn")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetAclsPlainArgs = GetAclsPlainArgs(
        aclIds = aclIds,
        aclName = aclName,
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        status = status,
    )
}
