@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.GetAscriptsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAscripts.
 * @property ascriptName Script name.
 * @property enableDetails
 * @property ids A list of AScript IDs.
 * @property listenerId Listener ID of script attribution
 * @property nameRegex A regex string to filter results by Group Metric Rule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetAscriptsPlainArgs(
    public val ascriptName: String? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val listenerId: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.GetAscriptsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.GetAscriptsPlainArgs =
        com.pulumi.alicloud.alb.inputs.GetAscriptsPlainArgs.builder()
            .ascriptName(ascriptName?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .listenerId(listenerId?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAscriptsPlainArgs].
 */
@PulumiTagMarker
public class GetAscriptsPlainArgsBuilder internal constructor() {
    private var ascriptName: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var listenerId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value Script name.
     */
    @JvmName("jrqrlojfjanuhcgb")
    public suspend fun ascriptName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ascriptName = mapped
    }

    /**
     * @param value
     */
    @JvmName("sdmfgjpxxlrsbjyp")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of AScript IDs.
     */
    @JvmName("gwaxffutdcdlnkyo")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of AScript IDs.
     */
    @JvmName("jisjyjweaeklddur")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Listener ID of script attribution
     */
    @JvmName("dxqrnquosbhpoirr")
    public suspend fun listenerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.listenerId = mapped
    }

    /**
     * @param value A regex string to filter results by Group Metric Rule name.
     */
    @JvmName("junpcsojqgtifypg")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("drbfdxqukinmpxtr")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetAscriptsPlainArgs = GetAscriptsPlainArgs(
        ascriptName = ascriptName,
        enableDetails = enableDetails,
        ids = ids,
        listenerId = listenerId,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
