@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.GetHealthCheckTemplatesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getHealthCheckTemplates.
 * @property healthCheckTemplateIds The health check template ids.
 * @property healthCheckTemplateName The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
 * @property ids A list of Health Check Template IDs.
 * @property nameRegex A regex string to filter results by Health Check Template name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetHealthCheckTemplatesPlainArgs(
    public val healthCheckTemplateIds: List<String>? = null,
    public val healthCheckTemplateName: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.GetHealthCheckTemplatesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.GetHealthCheckTemplatesPlainArgs =
        com.pulumi.alicloud.alb.inputs.GetHealthCheckTemplatesPlainArgs.builder()
            .healthCheckTemplateIds(healthCheckTemplateIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .healthCheckTemplateName(healthCheckTemplateName?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHealthCheckTemplatesPlainArgs].
 */
@PulumiTagMarker
public class GetHealthCheckTemplatesPlainArgsBuilder internal constructor() {
    private var healthCheckTemplateIds: List<String>? = null

    private var healthCheckTemplateName: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value The health check template ids.
     */
    @JvmName("psogeosbmekgiaop")
    public suspend fun healthCheckTemplateIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.healthCheckTemplateIds = mapped
    }

    /**
     * @param values The health check template ids.
     */
    @JvmName("iqvquiagaeoydtlm")
    public suspend fun healthCheckTemplateIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.healthCheckTemplateIds = mapped
    }

    /**
     * @param value The name of the health check template.  The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
     */
    @JvmName("sajcdeehubnkwbmj")
    public suspend fun healthCheckTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.healthCheckTemplateName = mapped
    }

    /**
     * @param value A list of Health Check Template IDs.
     */
    @JvmName("yqpkkltcvokfyjbs")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Health Check Template IDs.
     */
    @JvmName("yuajjhslkftliorl")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Health Check Template name.
     */
    @JvmName("tulhpibokxlimuac")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("bvbfovmnvjaxqjnm")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetHealthCheckTemplatesPlainArgs = GetHealthCheckTemplatesPlainArgs(
        healthCheckTemplateIds = healthCheckTemplateIds,
        healthCheckTemplateName = healthCheckTemplateName,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
