@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.GetListenersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getListeners.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Listener IDs.
 * @property listenerIds The listener ids.
 * @property listenerProtocol Snooping Protocols. Valid Values: `HTTP`, `HTTPS` Or `QUIC`.
 * @property loadBalancerIds The load balancer ids.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The state of the listener. Valid Values: `Running` Or `Stopped`. `Running`: The listener is running. `Stopped`: The listener is stopped.
 */
public data class GetListenersPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val listenerIds: List<String>? = null,
    public val listenerProtocol: String? = null,
    public val loadBalancerIds: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.GetListenersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.GetListenersPlainArgs =
        com.pulumi.alicloud.alb.inputs.GetListenersPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .listenerIds(listenerIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .listenerProtocol(listenerProtocol?.let({ args0 -> args0 }))
            .loadBalancerIds(loadBalancerIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetListenersPlainArgs].
 */
@PulumiTagMarker
public class GetListenersPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var listenerIds: List<String>? = null

    private var listenerProtocol: String? = null

    private var loadBalancerIds: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("ptsdnndlwpsgwijo")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Listener IDs.
     */
    @JvmName("ykqlgcbnywutcmtu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Listener IDs.
     */
    @JvmName("idsnrynvfxrawvpp")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The listener ids.
     */
    @JvmName("qjmdimkciicxfvkx")
    public suspend fun listenerIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.listenerIds = mapped
    }

    /**
     * @param values The listener ids.
     */
    @JvmName("ptlveeafotrgnywi")
    public suspend fun listenerIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.listenerIds = mapped
    }

    /**
     * @param value Snooping Protocols. Valid Values: `HTTP`, `HTTPS` Or `QUIC`.
     */
    @JvmName("vyqijfipohyieubb")
    public suspend fun listenerProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.listenerProtocol = mapped
    }

    /**
     * @param value The load balancer ids.
     */
    @JvmName("xbcxhjewjrkujmnf")
    public suspend fun loadBalancerIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.loadBalancerIds = mapped
    }

    /**
     * @param values The load balancer ids.
     */
    @JvmName("wtaybadbiyhxrice")
    public suspend fun loadBalancerIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.loadBalancerIds = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("dcbbmneavnodewfe")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The state of the listener. Valid Values: `Running` Or `Stopped`. `Running`: The listener is running. `Stopped`: The listener is stopped.
     */
    @JvmName("ckptaqwwbdgmrxap")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetListenersPlainArgs = GetListenersPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        listenerIds = listenerIds,
        listenerProtocol = listenerProtocol,
        loadBalancerIds = loadBalancerIds,
        outputFile = outputFile,
        status = status,
    )
}
