@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.GetLoadBalancersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLoadBalancers.
 * @property addressType The type of IP address that the ALB instance uses to provide services. Valid
 * values: `Intranet`, `Internet`.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Load Balancer IDs.
 * @property loadBalancerBusinessStatus Load Balancing of the Service Status. Valid Values: `Abnormal`and `Normal`.
 * @property loadBalancerBussinessStatus Field 'load_balancer_bussiness_status' has been deprecated from provider version 1.142.0. Use 'load_balancer_business_status' replaces it.
 * @property loadBalancerIds The load balancer ids.
 * @property loadBalancerName The name of the resource.
 * @property nameRegex A regex string to filter results by Load Balancer name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId The ID of the resource group.
 * @property status The load balancer status. Valid values: `Active`, `Configuring`, `CreateFailed`, `Inactive` and `Provisioning`.
 * @property tags
 * @property vpcId The ID of the virtual private cloud (VPC) where the ALB instance is deployed.
 * @property vpcIds The vpc ids.
 * @property zoneId The zone ID of the resource.
 */
public data class GetLoadBalancersPlainArgs(
    public val addressType: String? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val loadBalancerBusinessStatus: String? = null,
    @Deprecated(
        message = """
  Field 'load_balancer_bussiness_status' has been deprecated from provider version 1.142.0 and it
      will be removed in the future version. Please use the new attribute
      'load_balancer_business_status' instead.
  """,
    )
    public val loadBalancerBussinessStatus: String? = null,
    public val loadBalancerIds: List<String>? = null,
    public val loadBalancerName: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val vpcId: String? = null,
    public val vpcIds: List<String>? = null,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.GetLoadBalancersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.GetLoadBalancersPlainArgs =
        com.pulumi.alicloud.alb.inputs.GetLoadBalancersPlainArgs.builder()
            .addressType(addressType?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .loadBalancerBusinessStatus(loadBalancerBusinessStatus?.let({ args0 -> args0 }))
            .loadBalancerBussinessStatus(loadBalancerBussinessStatus?.let({ args0 -> args0 }))
            .loadBalancerIds(loadBalancerIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .loadBalancerName(loadBalancerName?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.let({ args0 -> args0 }))
            .vpcIds(vpcIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLoadBalancersPlainArgs].
 */
@PulumiTagMarker
public class GetLoadBalancersPlainArgsBuilder internal constructor() {
    private var addressType: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var loadBalancerBusinessStatus: String? = null

    private var loadBalancerBussinessStatus: String? = null

    private var loadBalancerIds: List<String>? = null

    private var loadBalancerName: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    private var vpcId: String? = null

    private var vpcIds: List<String>? = null

    private var zoneId: String? = null

    /**
     * @param value The type of IP address that the ALB instance uses to provide services. Valid
     * values: `Intranet`, `Internet`.
     */
    @JvmName("iavgvgsxqipeuuvq")
    public suspend fun addressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.addressType = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("vcfaafpqnjxyrrpt")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Load Balancer IDs.
     */
    @JvmName("dokjnpkngdksgbdb")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Load Balancer IDs.
     */
    @JvmName("eefnfbsrygeidkmo")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Load Balancing of the Service Status. Valid Values: `Abnormal`and `Normal`.
     */
    @JvmName("jlxqsshmbrmgxtyu")
    public suspend fun loadBalancerBusinessStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.loadBalancerBusinessStatus = mapped
    }

    /**
     * @param value Field 'load_balancer_bussiness_status' has been deprecated from provider version 1.142.0. Use 'load_balancer_business_status' replaces it.
     */
    @Deprecated(
        message = """
  Field 'load_balancer_bussiness_status' has been deprecated from provider version 1.142.0 and it
      will be removed in the future version. Please use the new attribute
      'load_balancer_business_status' instead.
  """,
    )
    @JvmName("nmbcgyikmvcikxsc")
    public suspend fun loadBalancerBussinessStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.loadBalancerBussinessStatus = mapped
    }

    /**
     * @param value The load balancer ids.
     */
    @JvmName("rkypdourmhmovgdw")
    public suspend fun loadBalancerIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.loadBalancerIds = mapped
    }

    /**
     * @param values The load balancer ids.
     */
    @JvmName("nngesaimbpupcauu")
    public suspend fun loadBalancerIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.loadBalancerIds = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("cgknraoaqjbtctrn")
    public suspend fun loadBalancerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.loadBalancerName = mapped
    }

    /**
     * @param value A regex string to filter results by Load Balancer name.
     */
    @JvmName("wcnkhguiosrepxeq")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("drjdqrhrfrvxmpiv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("lcqacywsjdnhhnha")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The load balancer status. Valid values: `Active`, `Configuring`, `CreateFailed`, `Inactive` and `Provisioning`.
     */
    @JvmName("cfulnjwoaanvpjnk")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value
     */
    @JvmName("loijnmlawawdkhmw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("nnipmxrlhjporpgn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value The ID of the virtual private cloud (VPC) where the ALB instance is deployed.
     */
    @JvmName("kgtxkjuqqdersstg")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    /**
     * @param value The vpc ids.
     */
    @JvmName("vuqggxlgimglmljg")
    public suspend fun vpcIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcIds = mapped
    }

    /**
     * @param values The vpc ids.
     */
    @JvmName("vgryfcmiduulsfrb")
    public suspend fun vpcIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vpcIds = mapped
    }

    /**
     * @param value The zone ID of the resource.
     */
    @JvmName("luinwvhgtesuquvr")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetLoadBalancersPlainArgs = GetLoadBalancersPlainArgs(
        addressType = addressType,
        enableDetails = enableDetails,
        ids = ids,
        loadBalancerBusinessStatus = loadBalancerBusinessStatus,
        loadBalancerBussinessStatus = loadBalancerBussinessStatus,
        loadBalancerIds = loadBalancerIds,
        loadBalancerName = loadBalancerName,
        nameRegex = nameRegex,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        status = status,
        tags = tags,
        vpcId = vpcId,
        vpcIds = vpcIds,
        zoneId = zoneId,
    )
}
