@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.GetRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRules.
 * @property ids A list of Rule IDs.
 * @property listenerIds The listener ids.
 * @property loadBalancerIds The load balancer ids.
 * @property nameRegex A regex string to filter results by Rule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property ruleIds The rule ids.
 * @property status The status of the forwarding rule. Valid values: `Provisioning`, `Configuring`, `Available`.
 */
public data class GetRulesPlainArgs(
    public val ids: List<String>? = null,
    public val listenerIds: List<String>? = null,
    public val loadBalancerIds: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val ruleIds: List<String>? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.GetRulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.GetRulesPlainArgs =
        com.pulumi.alicloud.alb.inputs.GetRulesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .listenerIds(listenerIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .loadBalancerIds(loadBalancerIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .ruleIds(ruleIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRulesPlainArgs].
 */
@PulumiTagMarker
public class GetRulesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var listenerIds: List<String>? = null

    private var loadBalancerIds: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var ruleIds: List<String>? = null

    private var status: String? = null

    /**
     * @param value A list of Rule IDs.
     */
    @JvmName("elsrujmwnspmllhk")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Rule IDs.
     */
    @JvmName("opybutwfyocdtend")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The listener ids.
     */
    @JvmName("dgcaspyxyewqabog")
    public suspend fun listenerIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.listenerIds = mapped
    }

    /**
     * @param values The listener ids.
     */
    @JvmName("xolexpysgmcbiark")
    public suspend fun listenerIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.listenerIds = mapped
    }

    /**
     * @param value The load balancer ids.
     */
    @JvmName("dtdyqdfreyeyohan")
    public suspend fun loadBalancerIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.loadBalancerIds = mapped
    }

    /**
     * @param values The load balancer ids.
     */
    @JvmName("trgeaxosuihxqsqp")
    public suspend fun loadBalancerIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.loadBalancerIds = mapped
    }

    /**
     * @param value A regex string to filter results by Rule name.
     */
    @JvmName("wwxykqueqxrvyxpy")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("yuxcowdsqbpwsipw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The rule ids.
     */
    @JvmName("qwgsigfpnvfolkri")
    public suspend fun ruleIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ruleIds = mapped
    }

    /**
     * @param values The rule ids.
     */
    @JvmName("nslrajfbkimkdvlt")
    public suspend fun ruleIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleIds = mapped
    }

    /**
     * @param value The status of the forwarding rule. Valid values: `Provisioning`, `Configuring`, `Available`.
     */
    @JvmName("hkjxcbbwbhrfsffg")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetRulesPlainArgs = GetRulesPlainArgs(
        ids = ids,
        listenerIds = listenerIds,
        loadBalancerIds = loadBalancerIds,
        nameRegex = nameRegex,
        outputFile = outputFile,
        ruleIds = ruleIds,
        status = status,
    )
}
