@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.GetSecurityPoliciesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSecurityPolicies.
 * @property ids A list of Security Policy IDs.
 * @property nameRegex A regex string to filter results by Security Policy name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId The ID of the resource group.
 * @property securityPolicyIds The security policy ids.
 * @property securityPolicyName The name of the resource.
 * @property status The status of the resource. Valid values : `Available`, `Configuring`.
 * @property tags
 */
public data class GetSecurityPoliciesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val securityPolicyIds: List<String>? = null,
    public val securityPolicyName: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.GetSecurityPoliciesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.GetSecurityPoliciesPlainArgs =
        com.pulumi.alicloud.alb.inputs.GetSecurityPoliciesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .securityPolicyIds(securityPolicyIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .securityPolicyName(securityPolicyName?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetSecurityPoliciesPlainArgs].
 */
@PulumiTagMarker
public class GetSecurityPoliciesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var securityPolicyIds: List<String>? = null

    private var securityPolicyName: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value A list of Security Policy IDs.
     */
    @JvmName("hhiswvbjvmbhoejg")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Security Policy IDs.
     */
    @JvmName("qdrefwksxeysybsi")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Security Policy name.
     */
    @JvmName("dxkghdqgudnowfco")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("kdeuwtwosycogfno")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("ndxrdmhwhyddpjxm")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The security policy ids.
     */
    @JvmName("bkejokvadnyxplod")
    public suspend fun securityPolicyIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.securityPolicyIds = mapped
    }

    /**
     * @param values The security policy ids.
     */
    @JvmName("amuakpsxdqwwaoem")
    public suspend fun securityPolicyIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.securityPolicyIds = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("dsqbuiiidhlffqte")
    public suspend fun securityPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.securityPolicyName = mapped
    }

    /**
     * @param value The status of the resource. Valid values : `Available`, `Configuring`.
     */
    @JvmName("jbhilbcyjtmiyajc")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value
     */
    @JvmName("vsacnelrmokbnocb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("wrpubsejgntmncqb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetSecurityPoliciesPlainArgs = GetSecurityPoliciesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        securityPolicyIds = securityPolicyIds,
        securityPolicyName = securityPolicyName,
        status = status,
        tags = tags,
    )
}
