@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.GetSystemSecurityPoliciesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSystemSecurityPolicies.
 * @property ids A list of System Security Policy IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property tags
 */
public data class GetSystemSecurityPoliciesPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.GetSystemSecurityPoliciesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.GetSystemSecurityPoliciesPlainArgs =
        com.pulumi.alicloud.alb.inputs.GetSystemSecurityPoliciesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetSystemSecurityPoliciesPlainArgs].
 */
@PulumiTagMarker
public class GetSystemSecurityPoliciesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value A list of System Security Policy IDs.
     */
    @JvmName("pyyjvjohhpnmkigx")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of System Security Policy IDs.
     */
    @JvmName("jsyqbnbntqgfjlek")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("bxyrinaavyjdoohb")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("nillumunyammpcni")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("weylgnrvduipmmhx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetSystemSecurityPoliciesPlainArgs = GetSystemSecurityPoliciesPlainArgs(
        ids = ids,
        outputFile = outputFile,
        tags = tags,
    )
}
