@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.GetZonesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getZones.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetZonesPlainArgs(
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.GetZonesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.GetZonesPlainArgs =
        com.pulumi.alicloud.alb.inputs.GetZonesPlainArgs.builder()
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetZonesPlainArgs].
 */
@PulumiTagMarker
public class GetZonesPlainArgsBuilder internal constructor() {
    private var outputFile: String? = null

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("yuerdqvgsexanxvb")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetZonesPlainArgs = GetZonesPlainArgs(
        outputFile = outputFile,
    )
}
