@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.ListenerAccessLogTracingConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property tracingEnabled Xtrace Function. Value: `True` Or `False` . Default Value: `False`.
 * > **NOTE:** Only Instances outside the Security Group to Access the Log Switch `accesslogenabled` Open, in Order to Set This Parameter to the `True`.
 * @property tracingSample Xtrace Sampling Rate. Value: `1` to `10000`.
 * > **NOTE:** This attribute is valid when `tracingenabled` is `true`.
 * @property tracingType Xtrace Type Value Is `Zipkin`.
 * > **NOTE:** This attribute is valid when `tracingenabled` is `true`.
 */
public data class ListenerAccessLogTracingConfigArgs(
    public val tracingEnabled: Output<Boolean>? = null,
    public val tracingSample: Output<Int>? = null,
    public val tracingType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.ListenerAccessLogTracingConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.ListenerAccessLogTracingConfigArgs =
        com.pulumi.alicloud.alb.inputs.ListenerAccessLogTracingConfigArgs.builder()
            .tracingEnabled(tracingEnabled?.applyValue({ args0 -> args0 }))
            .tracingSample(tracingSample?.applyValue({ args0 -> args0 }))
            .tracingType(tracingType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerAccessLogTracingConfigArgs].
 */
@PulumiTagMarker
public class ListenerAccessLogTracingConfigArgsBuilder internal constructor() {
    private var tracingEnabled: Output<Boolean>? = null

    private var tracingSample: Output<Int>? = null

    private var tracingType: Output<String>? = null

    /**
     * @param value Xtrace Function. Value: `True` Or `False` . Default Value: `False`.
     * > **NOTE:** Only Instances outside the Security Group to Access the Log Switch `accesslogenabled` Open, in Order to Set This Parameter to the `True`.
     */
    @JvmName("bnexobkhjhportnh")
    public suspend fun tracingEnabled(`value`: Output<Boolean>) {
        this.tracingEnabled = value
    }

    /**
     * @param value Xtrace Sampling Rate. Value: `1` to `10000`.
     * > **NOTE:** This attribute is valid when `tracingenabled` is `true`.
     */
    @JvmName("ipwbaypcrjldfjtj")
    public suspend fun tracingSample(`value`: Output<Int>) {
        this.tracingSample = value
    }

    /**
     * @param value Xtrace Type Value Is `Zipkin`.
     * > **NOTE:** This attribute is valid when `tracingenabled` is `true`.
     */
    @JvmName("nacwcpdyjkvrtecx")
    public suspend fun tracingType(`value`: Output<String>) {
        this.tracingType = value
    }

    /**
     * @param value Xtrace Function. Value: `True` Or `False` . Default Value: `False`.
     * > **NOTE:** Only Instances outside the Security Group to Access the Log Switch `accesslogenabled` Open, in Order to Set This Parameter to the `True`.
     */
    @JvmName("csayjkoxcyywbgjw")
    public suspend fun tracingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracingEnabled = mapped
    }

    /**
     * @param value Xtrace Sampling Rate. Value: `1` to `10000`.
     * > **NOTE:** This attribute is valid when `tracingenabled` is `true`.
     */
    @JvmName("iammogdvmiodxhhb")
    public suspend fun tracingSample(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracingSample = mapped
    }

    /**
     * @param value Xtrace Type Value Is `Zipkin`.
     * > **NOTE:** This attribute is valid when `tracingenabled` is `true`.
     */
    @JvmName("nbtlgquxevnntgus")
    public suspend fun tracingType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracingType = mapped
    }

    internal fun build(): ListenerAccessLogTracingConfigArgs = ListenerAccessLogTracingConfigArgs(
        tracingEnabled = tracingEnabled,
        tracingSample = tracingSample,
        tracingType = tracingType,
    )
}
