@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.ListenerAclConfigAclRelationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property aclId Snooping Binding of the Access Policy Group ID List.
 * @property status The state of the listener. Valid Values: `Running` Or `Stopped`. Valid values: `Running`: The listener is running. `Stopped`: The listener is stopped.
 */
public data class ListenerAclConfigAclRelationArgs(
    public val aclId: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.ListenerAclConfigAclRelationArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.ListenerAclConfigAclRelationArgs =
        com.pulumi.alicloud.alb.inputs.ListenerAclConfigAclRelationArgs.builder()
            .aclId(aclId?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerAclConfigAclRelationArgs].
 */
@PulumiTagMarker
public class ListenerAclConfigAclRelationArgsBuilder internal constructor() {
    private var aclId: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value Snooping Binding of the Access Policy Group ID List.
     */
    @JvmName("ekhmedfpcvrwqolb")
    public suspend fun aclId(`value`: Output<String>) {
        this.aclId = value
    }

    /**
     * @param value The state of the listener. Valid Values: `Running` Or `Stopped`. Valid values: `Running`: The listener is running. `Stopped`: The listener is stopped.
     */
    @JvmName("tahnuoqgbukuxnpt")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Snooping Binding of the Access Policy Group ID List.
     */
    @JvmName("qdmkacfrwcmwspax")
    public suspend fun aclId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclId = mapped
    }

    /**
     * @param value The state of the listener. Valid Values: `Running` Or `Stopped`. Valid values: `Running`: The listener is running. `Stopped`: The listener is stopped.
     */
    @JvmName("pnssqtvuxgomtafs")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): ListenerAclConfigAclRelationArgs = ListenerAclConfigAclRelationArgs(
        aclId = aclId,
        status = status,
    )
}
