@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.alb.kotlin.inputs

import com.pulumi.alicloud.alb.inputs.ListenerAclConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property aclRelations The ACLs that are associated with the listener. See `acl_relations` below for details.
 * @property aclType The type of the ACL. Valid values: `White` Or `Black`. `White`: specifies the ACL as a whitelist. Only requests from the IP addresses or CIDR blocks in the ACL are forwarded. Whitelists apply to scenarios where only specific IP addresses are allowed to access an application. Risks may occur if the whitelist is improperly set. After you set a whitelist for an Application Load Balancer (ALB) listener, only requests from IP addresses that are added to the whitelist are distributed by the listener. If the whitelist is enabled without IP addresses specified, the ALB listener does not forward requests. `Black`: All requests from the IP addresses or CIDR blocks in the ACL are denied. The blacklist is used to prevent specified IP addresses from accessing an application. If the blacklist is enabled but the corresponding ACL does not contain IP addresses, the ALB listener forwards all requests.
 */
public data class ListenerAclConfigArgs(
    public val aclRelations: Output<List<ListenerAclConfigAclRelationArgs>>? = null,
    public val aclType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.alb.inputs.ListenerAclConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.alb.inputs.ListenerAclConfigArgs =
        com.pulumi.alicloud.alb.inputs.ListenerAclConfigArgs.builder()
            .aclRelations(
                aclRelations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .aclType(aclType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerAclConfigArgs].
 */
@PulumiTagMarker
public class ListenerAclConfigArgsBuilder internal constructor() {
    private var aclRelations: Output<List<ListenerAclConfigAclRelationArgs>>? = null

    private var aclType: Output<String>? = null

    /**
     * @param value The ACLs that are associated with the listener. See `acl_relations` below for details.
     */
    @JvmName("uiqfefnbnnactqbx")
    public suspend fun aclRelations(`value`: Output<List<ListenerAclConfigAclRelationArgs>>) {
        this.aclRelations = value
    }

    @JvmName("tkvecmqkjnestpfr")
    public suspend fun aclRelations(vararg values: Output<ListenerAclConfigAclRelationArgs>) {
        this.aclRelations = Output.all(values.asList())
    }

    /**
     * @param values The ACLs that are associated with the listener. See `acl_relations` below for details.
     */
    @JvmName("weocfnrayciypjhc")
    public suspend fun aclRelations(values: List<Output<ListenerAclConfigAclRelationArgs>>) {
        this.aclRelations = Output.all(values)
    }

    /**
     * @param value The type of the ACL. Valid values: `White` Or `Black`. `White`: specifies the ACL as a whitelist. Only requests from the IP addresses or CIDR blocks in the ACL are forwarded. Whitelists apply to scenarios where only specific IP addresses are allowed to access an application. Risks may occur if the whitelist is improperly set. After you set a whitelist for an Application Load Balancer (ALB) listener, only requests from IP addresses that are added to the whitelist are distributed by the listener. If the whitelist is enabled without IP addresses specified, the ALB listener does not forward requests. `Black`: All requests from the IP addresses or CIDR blocks in the ACL are denied. The blacklist is used to prevent specified IP addresses from accessing an application. If the blacklist is enabled but the corresponding ACL does not contain IP addresses, the ALB listener forwards all requests.
     */
    @JvmName("tiwpqdafvvevdcuq")
    public suspend fun aclType(`value`: Output<String>) {
        this.aclType = value
    }

    /**
     * @param value The ACLs that are associated with the listener. See `acl_relations` below for details.
     */
    @JvmName("rdokajgikmurnswu")
    public suspend fun aclRelations(`value`: List<ListenerAclConfigAclRelationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclRelations = mapped
    }

    /**
     * @param argument The ACLs that are associated with the listener. See `acl_relations` below for details.
     */
    @JvmName("eicxbhulryyqekcm")
    public suspend fun aclRelations(argument: List<suspend ListenerAclConfigAclRelationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ListenerAclConfigAclRelationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.aclRelations = mapped
    }

    /**
     * @param argument The ACLs that are associated with the listener. See `acl_relations` below for details.
     */
    @JvmName("gafyadcsrneyqxsd")
    public suspend fun aclRelations(vararg argument: suspend ListenerAclConfigAclRelationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ListenerAclConfigAclRelationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.aclRelations = mapped
    }

    /**
     * @param argument The ACLs that are associated with the listener. See `acl_relations` below for details.
     */
    @JvmName("fmjfqnocdelltwdh")
    public suspend fun aclRelations(argument: suspend ListenerAclConfigAclRelationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ListenerAclConfigAclRelationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.aclRelations = mapped
    }

    /**
     * @param values The ACLs that are associated with the listener. See `acl_relations` below for details.
     */
    @JvmName("qhxfsampynqdrioj")
    public suspend fun aclRelations(vararg values: ListenerAclConfigAclRelationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aclRelations = mapped
    }

    /**
     * @param value The type of the ACL. Valid values: `White` Or `Black`. `White`: specifies the ACL as a whitelist. Only requests from the IP addresses or CIDR blocks in the ACL are forwarded. Whitelists apply to scenarios where only specific IP addresses are allowed to access an application. Risks may occur if the whitelist is improperly set. After you set a whitelist for an Application Load Balancer (ALB) listener, only requests from IP addresses that are added to the whitelist are distributed by the listener. If the whitelist is enabled without IP addresses specified, the ALB listener does not forward requests. `Black`: All requests from the IP addresses or CIDR blocks in the ACL are denied. The blacklist is used to prevent specified IP addresses from accessing an application. If the blacklist is enabled but the corresponding ACL does not contain IP addresses, the ALB listener forwards all requests.
     */
    @JvmName("ggbnbdeebcrtgoig")
    public suspend fun aclType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclType = mapped
    }

    internal fun build(): ListenerAclConfigArgs = ListenerAclConfigArgs(
        aclRelations = aclRelations,
        aclType = aclType,
    )
}
